/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.qpid.server.security;

import static org.apache.qpid.server.security.access.Operation.INVOKE_METHOD;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.util.FixedKeyMapCreator;

final class AutoGeneratedSelfSignedKeyStoreImplWithAccessChecking extends AutoGeneratedSelfSignedKeyStoreImpl
{
    AutoGeneratedSelfSignedKeyStoreImplWithAccessChecking(final Map<String, Object> attributes, final org.apache.qpid.server.model.Broker<?> broker)
    {
        super(attributes, broker);
    }

    public java.util.Map<java.lang.String,java.lang.Object> getStatistics(final java.util.List<java.lang.String> statistics)
    {
        return super.getStatistics(statistics);
    }

    public java.lang.String setContextVariable(final java.lang.String name, final java.lang.String value)
    {
        return doSync(doOnConfigThread(new Task<CompletableFuture<java.lang.String>, RuntimeException>()
            {
                private String _args;
                @Override
                public CompletableFuture<java.lang.String> execute()
                {
                    return CompletableFuture.<java.lang.String>completedFuture(AutoGeneratedSelfSignedKeyStoreImplWithAccessChecking.super.setContextVariable(name, value));
                }
                @Override
                public String getObject()
                {
                    return AutoGeneratedSelfSignedKeyStoreImplWithAccessChecking.this.toString();
                }
                @Override
                public String getAction()
                {
                    return "setContextVariable";
                }
                @Override
                public String getArguments()
                {
                    if (_args == null)
                    {
                        _args = "name=" + name + "," + "value=" + value;
                    }
                    return _args;
                }
            }));

    }

    public java.lang.String removeContextVariable(final java.lang.String name)
    {
        return doSync(doOnConfigThread(new Task<CompletableFuture<java.lang.String>, RuntimeException>()
            {
                private String _args;
                @Override
                public CompletableFuture<java.lang.String> execute()
                {
                    return CompletableFuture.<java.lang.String>completedFuture(AutoGeneratedSelfSignedKeyStoreImplWithAccessChecking.super.removeContextVariable(name));
                }
                @Override
                public String getObject()
                {
                    return AutoGeneratedSelfSignedKeyStoreImplWithAccessChecking.this.toString();
                }
                @Override
                public String getAction()
                {
                    return "removeContextVariable";
                }
                @Override
                public String getArguments()
                {
                    if (_args == null)
                    {
                        _args = "name=" + name;
                    }
                    return _args;
                }
            }));

    }

    public void regenerateCertificate()
    {
        authorise(INVOKE_METHOD("regenerateCertificate"));

        doSync(doOnConfigThread(new Task<CompletableFuture<Void>, RuntimeException>()
            {
                private String _args;
                @Override
                public CompletableFuture<Void> execute()
                {
                    AutoGeneratedSelfSignedKeyStoreImplWithAccessChecking.super.regenerateCertificate();
                    return CompletableFuture.<Void>completedFuture(null);
                }
                @Override
                public String getObject()
                {
                    return AutoGeneratedSelfSignedKeyStoreImplWithAccessChecking.this.toString();
                }
                @Override
                public String getAction()
                {
                    return "regenerateCertificate";
                }
                @Override
                public String getArguments()
                {
                    return _args;
                }
            }));

    }

    private static final FixedKeyMapCreator GET_CLIENT_TRUST_STORE_MAP_CREATOR = new FixedKeyMapCreator("password");

    public org.apache.qpid.server.model.Content getClientTrustStore(final java.lang.String password)
    {
        authorise(INVOKE_METHOD("getClientTrustStore"), GET_CLIENT_TRUST_STORE_MAP_CREATOR.createMap(password));

        return super.getClientTrustStore(password);
    }

    public org.apache.qpid.server.model.Content getCertificate()
    {
        authorise(INVOKE_METHOD("getCertificate"));

        return super.getCertificate();
    }

}
