/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.HeadersBinding;
import org.apache.qpid.server.exchange.HeadersExchange;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadersExchangeImpl
extends AbstractExchange<HeadersExchangeImpl>
implements HeadersExchange<HeadersExchangeImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadersExchangeImpl.class);
    private final Set<HeadersBinding> _bindingHeaderMatchers = Collections.newSetFromMap(new ConcurrentHashMap());

    @ManagedObjectFactoryConstructor
    public HeadersExchangeImpl(Map<String, Object> attributes, QueueManagingVirtualHost<?> vhost) {
        super(attributes, vhost);
    }

    @Override
    public <M extends ServerMessage<? extends StorableMessageMetaData>> void doRoute(M payload, String routingKey, InstanceProperties instanceProperties, RoutingResult<M> routingResult) {
        LOGGER.debug("Exchange {}: routing message with headers {}", (Object)this.getName(), (Object)payload.getMessageHeader());
        for (HeadersBinding hb : this._bindingHeaderMatchers) {
            if (!hb.matches(Filterable.Factory.newInstance(payload, instanceProperties))) continue;
            MessageDestination destination = hb.getBinding().getDestination();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exchange '{}' delivering message with headers '{}' to '{}'", new Object[]{this.getName(), payload.getMessageHeader(), destination.getName()});
            }
            String actualRoutingKey = hb.getReplacementRoutingKey() == null ? routingKey : hb.getReplacementRoutingKey();
            routingResult.add(destination.route(payload, actualRoutingKey, instanceProperties));
        }
    }

    @Override
    protected void onBind(AbstractExchange.BindingIdentifier binding, Map<String, Object> arguments) {
        this._bindingHeaderMatchers.add(new HeadersBinding(binding, arguments));
    }

    @Override
    protected void onBindingUpdated(AbstractExchange.BindingIdentifier binding, Map<String, Object> arguments) {
        this._bindingHeaderMatchers.add(new HeadersBinding(binding, arguments));
    }

    @Override
    protected void onUnbind(AbstractExchange.BindingIdentifier binding) {
        this._bindingHeaderMatchers.remove(new HeadersBinding(binding, Collections.emptyMap()));
    }
}

