/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange.topic;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.topic.TopicMatcherResult;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.MessageDestination;

public final class TopicExchangeResult
implements TopicMatcherResult {
    private final Map<MessageDestination, Integer> _unfilteredDestinations = new ConcurrentHashMap<MessageDestination, Integer>();
    private final ConcurrentMap<MessageDestination, Map<FilterManager, Integer>> _filteredDestinations = new ConcurrentHashMap<MessageDestination, Map<FilterManager, Integer>>();
    private final Map<MessageDestination, String> _replacementKeys = new ConcurrentHashMap<MessageDestination, String>();

    public void addUnfilteredDestination(MessageDestination destination) {
        this._unfilteredDestinations.merge(destination, 1, (oldCount, increment) -> oldCount + increment);
    }

    public void removeUnfilteredDestination(MessageDestination destination) {
        Integer instances = this._unfilteredDestinations.get(destination);
        if (instances == 1) {
            this._unfilteredDestinations.remove(destination);
        } else {
            this._unfilteredDestinations.put(destination, instances - 1);
        }
    }

    public void addBinding(AbstractExchange.BindingIdentifier binding, Map<String, Object> bindingArguments) {
        Object keyObject;
        Object object = keyObject = bindingArguments != null ? bindingArguments.get("x-replacement-routing-key") : null;
        if (keyObject == null) {
            this._replacementKeys.remove(binding.getDestination());
        } else {
            this._replacementKeys.put(binding.getDestination(), String.valueOf(keyObject));
        }
    }

    public void removeBinding(AbstractExchange.BindingIdentifier binding) {
        this._replacementKeys.remove(binding.getDestination());
    }

    public void addFilteredDestination(MessageDestination destination, FilterManager filter) {
        Map filters = this._filteredDestinations.computeIfAbsent(destination, filterManagerMap -> new ConcurrentHashMap());
        filters.merge(filter, 1, (oldCount, increment) -> oldCount + increment);
    }

    public void removeFilteredDestination(MessageDestination destination, FilterManager filter) {
        Integer instances;
        Map filters = (Map)this._filteredDestinations.get(destination);
        if (filters != null && (instances = (Integer)filters.get(filter)) != null) {
            if (instances == 1) {
                filters.remove(filter);
                if (filters.isEmpty()) {
                    this._filteredDestinations.remove(destination);
                }
            } else {
                filters.put(filter, instances - 1);
            }
        }
    }

    public void replaceDestinationFilter(MessageDestination queue, FilterManager oldFilter, FilterManager newFilter) {
        Map filters = (Map)this._filteredDestinations.get(queue);
        ConcurrentHashMap<FilterManager, Integer> newFilters = new ConcurrentHashMap<FilterManager, Integer>(filters);
        Integer oldFilterInstances = (Integer)filters.get(oldFilter);
        if (oldFilterInstances == 1) {
            newFilters.remove(oldFilter);
        } else {
            newFilters.put(oldFilter, oldFilterInstances - 1);
        }
        Integer newFilterInstances = (Integer)filters.get(newFilter);
        if (newFilterInstances == null) {
            newFilters.put(newFilter, 1);
        } else {
            newFilters.put(newFilter, newFilterInstances + 1);
        }
        this._filteredDestinations.put(queue, newFilters);
    }

    public Map<MessageDestination, String> processMessage(Filterable msg) {
        HashMap<MessageDestination, String> result = new HashMap<MessageDestination, String>();
        for (MessageDestination messageDestination : this._unfilteredDestinations.keySet()) {
            result.put(messageDestination, this._replacementKeys.get(messageDestination));
        }
        if (!this._filteredDestinations.isEmpty()) {
            for (Map.Entry entry : this._filteredDestinations.entrySet()) {
                MessageDestination destination = (MessageDestination)entry.getKey();
                if (this._unfilteredDestinations.containsKey(destination)) continue;
                for (FilterManager filter : ((Map)entry.getValue()).keySet()) {
                    if (!filter.allAllow(msg)) continue;
                    result.put(destination, this._replacementKeys.get(destination));
                }
            }
        }
        return result;
    }
}

