/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging;

import java.security.AccessController;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.qpid.server.connection.ConnectionPrincipal;
import org.apache.qpid.server.connection.SessionPrincipal;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.MessageLogger;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.ManagementConnectionPrincipal;
import org.apache.qpid.server.security.auth.TaskPrincipal;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.transport.AMQPConnection;

public abstract class AbstractMessageLogger
implements MessageLogger {
    public static final String DEFAULT_LOG_HIERARCHY_PREFIX = "qpid.message.";
    private final String _msgPrefix = System.getProperty("qpid.logging.prefix", "");
    private boolean _enabled = true;

    public AbstractMessageLogger() {
    }

    public AbstractMessageLogger(boolean statusUpdatesEnabled) {
        this._enabled = statusUpdatesEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public boolean isMessageEnabled(String logHierarchy) {
        return this._enabled;
    }

    @Override
    public void message(LogMessage message) {
        if (this.isMessageEnabled(message.getLogHierarchy())) {
            this.rawMessage(this._msgPrefix + this.getActor() + message, message.getLogHierarchy());
        }
    }

    @Override
    public void message(LogSubject subject, LogMessage message) {
        if (this.isMessageEnabled(message.getLogHierarchy())) {
            this.rawMessage(this._msgPrefix + this.getActor() + subject.toLogString() + message, message.getLogHierarchy());
        }
    }

    abstract void rawMessage(String var1, String var2);

    abstract void rawMessage(String var1, Throwable var2, String var3);

    protected String getActor() {
        ManagementConnectionPrincipal managementConnection;
        TaskPrincipal taskPrincipal;
        ConnectionPrincipal connPrincipal;
        Subject subject = Subject.getSubject(AccessController.getContext());
        SessionPrincipal sessionPrincipal = this.getPrincipal(subject, SessionPrincipal.class);
        String message = sessionPrincipal != null ? this.generateSessionMessage(sessionPrincipal.getSession()) : ((connPrincipal = this.getPrincipal(subject, ConnectionPrincipal.class)) != null ? this.generateConnectionMessage(connPrincipal.getConnection()) : ((taskPrincipal = this.getPrincipal(subject, TaskPrincipal.class)) != null ? this.generateTaskMessage(taskPrincipal) : ((managementConnection = this.getPrincipal(subject, ManagementConnectionPrincipal.class)) != null ? this.generateManagementConnectionMessage(managementConnection, this.getPrincipal(subject, AuthenticatedPrincipal.class)) : "<<UNKNOWN>> ")));
        return message;
    }

    private String generateManagementConnectionMessage(ManagementConnectionPrincipal managementConnection, AuthenticatedPrincipal userPrincipal) {
        String remoteAddress = managementConnection.getRemoteAddress().toString();
        String user = userPrincipal == null ? "N/A" : userPrincipal.getName();
        String sessionId = managementConnection.getSessionId();
        if (sessionId == null) {
            sessionId = "N/A";
        }
        return "[" + MessageFormat.format("mng:{0}({1}@{2})", sessionId, user, remoteAddress) + "] ";
    }

    private String generateTaskMessage(TaskPrincipal taskPrincipal) {
        return "[" + taskPrincipal.getName() + "] ";
    }

    protected String generateConnectionMessage(AMQPConnection<?> connection) {
        if (connection.getAuthorizedPrincipal() != null) {
            if (connection.getAddressSpaceName() != null) {
                return "[" + MessageFormat.format("con:{0}({1}@{2}/{3})", connection.getConnectionId(), connection.getAuthorizedPrincipal().getName(), connection.getRemoteAddressString(), connection.getAddressSpaceName()) + "] ";
            }
            return "[" + MessageFormat.format("con:{0}({1}@{2})", connection.getConnectionId(), connection.getAuthorizedPrincipal().getName(), connection.getRemoteAddressString()) + "] ";
        }
        return "[" + MessageFormat.format("con:{0}({1})", connection.getConnectionId(), connection.getRemoteAddressString()) + "] ";
    }

    protected String generateSessionMessage(AMQPSession session) {
        AMQPConnection<?> connection = session.getAMQPConnection();
        return "[" + MessageFormat.format("con:{0}({1}@{2}/{3})/ch:{4}", connection == null ? -1L : connection.getConnectionId(), connection == null || connection.getAuthorizedPrincipal() == null ? "?" : connection.getAuthorizedPrincipal().getName(), connection == null || connection.getRemoteAddressString() == null ? "?" : connection.getRemoteAddressString(), connection == null || connection.getAddressSpaceName() == null ? "?" : connection.getAddressSpaceName(), session.getChannelId()) + "] ";
    }

    private <P extends Principal> P getPrincipal(Subject subject, Class<P> clazz) {
        Set<P> principals;
        if (subject != null && (principals = subject.getPrincipals(clazz)) != null && !principals.isEmpty()) {
            return (P)((Principal)principals.iterator().next());
        }
        return null;
    }
}

