/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.apache.qpid.server.model.ConfiguredAutomatedAttribute;
import org.apache.qpid.server.model.ConfiguredDerivedMethodAttribute;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectAttributeOrStatistic;
import org.apache.qpid.server.model.ConfiguredObjectFactory;
import org.apache.qpid.server.model.ConfiguredObjectInjectedAttribute;
import org.apache.qpid.server.model.ConfiguredObjectInjectedOperation;
import org.apache.qpid.server.model.ConfiguredObjectInjectedStatistic;
import org.apache.qpid.server.model.ConfiguredObjectJacksonModule;
import org.apache.qpid.server.model.ConfiguredObjectMethodOperation;
import org.apache.qpid.server.model.ConfiguredObjectMethodStatistic;
import org.apache.qpid.server.model.ConfiguredObjectOperation;
import org.apache.qpid.server.model.ConfiguredObjectStatistic;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAnnotation;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedContextDependency;
import org.apache.qpid.server.model.ManagedInterface;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.ModelRoot;
import org.apache.qpid.server.model.NoFactoryForCategoryException;
import org.apache.qpid.server.model.NoFactoryForTypeException;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.plugin.ConfiguredObjectAttributeInjector;
import org.apache.qpid.server.plugin.ConfiguredObjectRegistration;
import org.apache.qpid.server.plugin.ConfiguredObjectTypeFactory;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredObjectTypeRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredObjectTypeRegistry.class);
    private static Map<String, Integer> STANDARD_FIRST_FIELDS_ORDER = new HashMap<String, Integer>();
    private static final ConcurrentMap<Class<?>, Class<? extends ConfiguredObject>> CATEGORY_CACHE = new ConcurrentHashMap();
    private static Map<String, Integer> STANDARD_LAST_FIELDS_ORDER;
    private static final Comparator<ConfiguredObjectAttributeOrStatistic<?, ?>> OBJECT_NAME_COMPARATOR;
    private static final Comparator<String> NAME_COMPARATOR;
    private final Map<Class<? extends ConfiguredObject>, Collection<ConfiguredObjectAttribute<?, ?>>> _allAttributes = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends ConfiguredObject>, Collection<ConfiguredObjectStatistic<?, ?>>> _allStatistics = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends ConfiguredObject>, Map<String, ConfiguredObjectAttribute<?, ?>>> _allAttributeTypes = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends ConfiguredObject>, Map<String, AutomatedField>> _allAutomatedFields = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> _defaultContext = Collections.synchronizedMap(new HashMap());
    private final Map<String, ManagedContextDefault> _contextDefinitions = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends ConfiguredObject>, Set<String>> _contextUses = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends ConfiguredObject>, Set<Class<? extends ConfiguredObject>>> _knownTypes = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends ConfiguredObject>, Collection<ConfiguredObjectAttribute<?, ?>>> _typeSpecificAttributes = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends ConfiguredObject>, Collection<ConfiguredObjectStatistic<?, ?>>> _typeSpecificStatistics = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends ConfiguredObject>, Map<State, Map<State, Method>>> _stateChangeMethods = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends ConfiguredObject>, Set<Class<? extends ManagedInterface>>> _allManagedInterfaces = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends ConfiguredObject>, Set<ConfiguredObjectOperation<?>>> _allOperations = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends ConfiguredObject>, Map<String, Collection<String>>> _validChildTypes = Collections.synchronizedMap(new HashMap());
    private final ConfiguredObjectFactory _objectFactory;
    private final Iterable<ConfiguredObjectAttributeInjector> _attributeInjectors;

    private static int compareAttributeNames(String leftName, String rightName) {
        int result = leftName.equals(rightName) ? 0 : (STANDARD_FIRST_FIELDS_ORDER.containsKey(leftName) ? (STANDARD_FIRST_FIELDS_ORDER.containsKey(rightName) ? STANDARD_FIRST_FIELDS_ORDER.get(leftName) - STANDARD_FIRST_FIELDS_ORDER.get(rightName) : -1) : (STANDARD_FIRST_FIELDS_ORDER.containsKey(rightName) ? 1 : (STANDARD_LAST_FIELDS_ORDER.containsKey(rightName) ? (STANDARD_LAST_FIELDS_ORDER.containsKey(leftName) ? STANDARD_LAST_FIELDS_ORDER.get(leftName) - STANDARD_LAST_FIELDS_ORDER.get(rightName) : -1) : (STANDARD_LAST_FIELDS_ORDER.containsKey(leftName) ? 1 : leftName.compareTo(rightName)))));
        return result;
    }

    public ConfiguredObjectTypeRegistry(Iterable<ConfiguredObjectRegistration> configuredObjectRegistrations, Iterable<ConfiguredObjectAttributeInjector> attributeInjectors, Collection<Class<? extends ConfiguredObject>> categoriesRestriction, ConfiguredObjectFactory objectFactory) {
        Object annotation;
        this._objectFactory = objectFactory;
        this._attributeInjectors = attributeInjectors;
        HashSet<Class<? extends ConfiguredObject>> categories = new HashSet<Class<? extends ConfiguredObject>>();
        HashSet<Class<? extends ConfiguredObject>> types = new HashSet<Class<? extends ConfiguredObject>>();
        for (ConfiguredObjectRegistration configuredObjectRegistration : configuredObjectRegistrations) {
            for (Class<? extends ConfiguredObject> clazz : configuredObjectRegistration.getConfiguredObjectClasses()) {
                if (!categoriesRestriction.isEmpty() && !categoriesRestriction.contains(ConfiguredObjectTypeRegistry.getCategory(clazz))) continue;
                try {
                    this.process(clazz);
                    annotation = clazz.getAnnotation(ManagedObject.class);
                    if (annotation.category()) {
                        categories.add(clazz);
                    } else {
                        Class<? extends ConfiguredObject> clazz2 = ConfiguredObjectTypeRegistry.getCategory(clazz);
                        if (clazz2 != null) {
                            categories.add(clazz2);
                        }
                    }
                    if ("".equals(annotation.type())) continue;
                    types.add(clazz);
                }
                catch (NoClassDefFoundError ncdfe) {
                    LOGGER.warn("A class definition could not be found while processing the model for '" + clazz.getName() + "': " + ncdfe.getMessage());
                }
            }
        }
        for (Class clazz : categories) {
            this._knownTypes.put(clazz, new HashSet());
        }
        for (Class clazz : types) {
            for (Class<ConfiguredObject<Object>> clazz3 : categories) {
                if (!clazz3.isAssignableFrom(clazz)) continue;
                annotation = clazz.getAnnotation(ManagedObject.class);
                String string = annotation.type();
                if (!ModelRoot.class.isAssignableFrom(clazz3) && !this.factoryExists(clazz3, string)) continue;
                this._knownTypes.get(clazz3).add(clazz);
            }
        }
        for (Class clazz : categories) {
            Set<Class<? extends ConfiguredObject>> typesForCategory = this._knownTypes.get(clazz);
            if (typesForCategory.isEmpty()) {
                typesForCategory.add(clazz);
                this._typeSpecificAttributes.put(clazz, Collections.emptySet());
                this._typeSpecificStatistics.put(clazz, Collections.emptySet());
                continue;
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (ConfiguredObjectAttribute configuredObjectAttribute : this._allAttributes.get(clazz)) {
                hashSet.add(configuredObjectAttribute.getName());
            }
            HashSet<String> commonStatistics = new HashSet<String>();
            for (ConfiguredObjectStatistic<?, ?> configuredObjectStatistic : this._allStatistics.get(clazz)) {
                commonStatistics.add(configuredObjectStatistic.getName());
            }
            for (Class<? extends ConfiguredObject> clazz4 : typesForCategory) {
                HashSet attributes = new HashSet();
                for (ConfiguredObjectAttribute<?, ?> attr : this._allAttributes.get(clazz4)) {
                    if (hashSet.contains(attr.getName())) continue;
                    attributes.add(attr);
                }
                this._typeSpecificAttributes.put(clazz4, attributes);
                HashSet statistics = new HashSet();
                for (ConfiguredObjectStatistic<?, ?> statistic : this._allStatistics.get(clazz4)) {
                    if (commonStatistics.contains(statistic.getName())) continue;
                    statistics.add(statistic);
                }
                this._typeSpecificStatistics.put(clazz4, statistics);
            }
        }
        for (Class clazz : types) {
            Method validChildTypesMethod;
            ManagedObject annotation2 = clazz.getAnnotation(ManagedObject.class);
            String string = annotation2.validChildTypes();
            if ("".equals(string) || (validChildTypesMethod = ConfiguredObjectTypeRegistry.getValidChildTypesFunction(string, clazz)) == null) continue;
            try {
                this._validChildTypes.put(clazz, (Map)validChildTypesMethod.invoke(null, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new IllegalArgumentException("Exception while evaluating valid child types for " + clazz.getName(), reflectiveOperationException);
            }
        }
        this.validateContextDependencies();
    }

    public static boolean returnsCollectionOfConfiguredObjects(ConfiguredObjectOperation operation) {
        return Collection.class.isAssignableFrom(operation.getReturnType()) && operation.getGenericReturnType() instanceof ParameterizedType && ConfiguredObject.class.isAssignableFrom(ConfiguredObjectTypeRegistry.getCollectionMemberType((ParameterizedType)operation.getGenericReturnType()));
    }

    public static Class getCollectionMemberType(ParameterizedType collectionType) {
        return ConfiguredObjectTypeRegistry.getRawType(collectionType.getActualTypeArguments()[0]);
    }

    public static Class getRawType(Type t) {
        Type[] upperBounds;
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)t).getBounds();
            if (bounds.length == 1) {
                return ConfiguredObjectTypeRegistry.getRawType(bounds[0]);
            }
        } else if (t instanceof WildcardType && (upperBounds = ((WildcardType)t).getUpperBounds()).length == 1) {
            return ConfiguredObjectTypeRegistry.getRawType(upperBounds[0]);
        }
        throw new ServerScopedRuntimeException("Unable to process type when constructing configuration model: " + t);
    }

    private void validateContextDependencies() {
        for (Map.Entry<Class<? extends ConfiguredObject>, Set<String>> entry : this._contextUses.entrySet()) {
            for (String dependency : entry.getValue()) {
                if (this._contextDefinitions.containsKey(dependency)) continue;
                throw new IllegalArgumentException("Class " + entry.getKey().getSimpleName() + " defines a context dependency on a context variable '" + dependency + "' which is never defined");
            }
        }
    }

    private boolean factoryExists(Class<? extends ConfiguredObject> categoryClass, String type) {
        try {
            ConfiguredObjectTypeFactory factory = this._objectFactory.getConfiguredObjectTypeFactory(categoryClass.getSimpleName(), type);
            return factory != null && factory.getType().equals(type);
        }
        catch (NoFactoryForCategoryException | NoFactoryForTypeException e) {
            return false;
        }
    }

    private static Method getValidChildTypesFunction(String validValue, Class<? extends ConfiguredObject> clazz) {
        if (validValue.matches("([\\w][\\w\\d_]+\\.)+[\\w][\\w\\d_\\$]*#[\\w\\d_]+\\s*\\(\\s*\\)")) {
            String function = validValue;
            try {
                Type valueType;
                Type keyType;
                String className = function.split("#")[0].trim();
                String methodName = function.split("#")[1].split("\\(")[0].trim();
                Class<?> validValueCalculatingClass = Class.forName(className);
                Method method = validValueCalculatingClass.getMethod(methodName, new Class[0]);
                if (Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && Map.class.isAssignableFrom(method.getReturnType()) && method.getGenericReturnType() instanceof ParameterizedType && (keyType = ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0]) == String.class && (valueType = ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[1]) instanceof ParameterizedType) {
                    ParameterizedType paramType = (ParameterizedType)valueType;
                    Type rawType = paramType.getRawType();
                    Type[] args = paramType.getActualTypeArguments();
                    if (Collection.class.isAssignableFrom((Class)rawType) && args.length == 1 && args[0] == String.class) {
                        return method;
                    }
                }
                throw new IllegalArgumentException("The validChildTypes of the class " + clazz.getSimpleName() + " has value '" + validValue + "' but the method does not meet the requirements - is it public and static");
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new IllegalArgumentException("The validChildTypes of the class " + clazz.getSimpleName() + " has value '" + validValue + "' which looks like it should be a method, but no such method could be used.", e);
            }
        }
        throw new IllegalArgumentException("The validChildTypes of the class " + clazz.getSimpleName() + " has value '" + validValue + "' which does not match the required <package>.<class>#<method>() format.");
    }

    public static Class<? extends ConfiguredObject> getCategory(Class<?> clazz) {
        Class<? extends ConfiguredObject> category = (Class<? extends ConfiguredObject>)CATEGORY_CACHE.get(clazz);
        if (category == null && (category = ConfiguredObjectTypeRegistry.calculateCategory(clazz)) != null) {
            CATEGORY_CACHE.putIfAbsent(clazz, category);
        }
        return category;
    }

    private static Class<? extends ConfiguredObject> calculateCategory(Class<?> clazz) {
        ManagedObject annotation = clazz.getAnnotation(ManagedObject.class);
        if (annotation != null && annotation.category()) {
            return clazz;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            Class<? extends ConfiguredObject> cat = ConfiguredObjectTypeRegistry.getCategory(iface);
            if (cat == null) continue;
            return cat;
        }
        if (clazz.getSuperclass() != null) {
            return ConfiguredObjectTypeRegistry.getCategory(clazz.getSuperclass());
        }
        return null;
    }

    public Class<? extends ConfiguredObject> getTypeClass(Class<? extends ConfiguredObject> clazz) {
        String typeName = ConfiguredObjectTypeRegistry.getType(clazz);
        Class<? extends ConfiguredObject> typeClass = null;
        if (typeName != null) {
            Class<? extends ConfiguredObject> category = ConfiguredObjectTypeRegistry.getCategory(clazz);
            Set<Class<? extends ConfiguredObject>> types = this._knownTypes.get(category);
            if (types != null) {
                for (Class<? extends ConfiguredObject> type : types) {
                    ManagedObject annotation = type.getAnnotation(ManagedObject.class);
                    if (!typeName.equals(annotation.type())) continue;
                    typeClass = type;
                    break;
                }
            }
            if (typeClass == null && typeName.equals(category.getSimpleName())) {
                typeClass = category;
            }
        }
        return typeClass;
    }

    public Collection<Class<? extends ConfiguredObject>> getTypeSpecialisations(Class<? extends ConfiguredObject> clazz) {
        Class<? extends ConfiguredObject> categoryClass = ConfiguredObjectTypeRegistry.getCategory(clazz);
        if (categoryClass == null) {
            throw new IllegalArgumentException("Cannot locate ManagedObject information for " + clazz.getName());
        }
        Set<Class<? extends ConfiguredObject>> classes = this._knownTypes.get(categoryClass);
        if (classes == null) {
            classes = Collections.singleton(clazz);
        }
        return Collections.unmodifiableCollection(classes);
    }

    public Collection<ConfiguredObjectAttribute<?, ?>> getTypeSpecificAttributes(Class<? extends ConfiguredObject> clazz) {
        Class<? extends ConfiguredObject> typeClass = this.getTypeClass(clazz);
        if (typeClass == null) {
            throw new IllegalArgumentException("Cannot locate ManagedObject information for " + clazz.getName());
        }
        Collection<ConfiguredObjectAttribute<?, ?>> typeAttrs = this._typeSpecificAttributes.get(typeClass);
        return Collections.unmodifiableCollection(typeAttrs == null ? Collections.emptySet() : typeAttrs);
    }

    public Collection<ConfiguredObjectStatistic<?, ?>> getTypeSpecificStatistics(Class<? extends ConfiguredObject> clazz) {
        Class<? extends ConfiguredObject> typeClass = this.getTypeClass(clazz);
        if (typeClass == null) {
            throw new IllegalArgumentException("Cannot locate ManagedObject information for " + clazz.getName());
        }
        Collection<ConfiguredObjectStatistic<?, ?>> typeAttrs = this._typeSpecificStatistics.get(typeClass);
        return Collections.unmodifiableCollection(typeAttrs == null ? Collections.emptySet() : typeAttrs);
    }

    public static String getType(Class<? extends ConfiguredObject> clazz) {
        String type = ConfiguredObjectTypeRegistry.getActualType(clazz);
        if ("".equals(type)) {
            Class<? extends ConfiguredObject> category = ConfiguredObjectTypeRegistry.getCategory(clazz);
            if (category == null) {
                throw new IllegalArgumentException("No category for " + clazz.getSimpleName());
            }
            ManagedObject annotation = category.getAnnotation(ManagedObject.class);
            if (annotation == null) {
                throw new NullPointerException("No definition found for category " + category.getSimpleName());
            }
            type = !"".equals(annotation.defaultType()) ? annotation.defaultType() : category.getSimpleName();
        }
        return type;
    }

    private static String getActualType(Class<? extends ConfiguredObject> clazz) {
        String type;
        ManagedObject annotation = clazz.getAnnotation(ManagedObject.class);
        if (annotation != null && !"".equals(annotation.type())) {
            return annotation.type();
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            String type2;
            if (!ConfiguredObject.class.isAssignableFrom(iface) || "".equals(type2 = ConfiguredObjectTypeRegistry.getActualType(iface))) continue;
            return type2;
        }
        if (clazz.getSuperclass() != null && ConfiguredObject.class.isAssignableFrom(clazz.getSuperclass()) && !"".equals(type = ConfiguredObjectTypeRegistry.getActualType(clazz.getSuperclass()))) {
            return type;
        }
        return "";
    }

    public Strings.Resolver getDefaultContextResolver() {
        return new Strings.MapResolver(this._defaultContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X extends ConfiguredObject> void process(Class<X> clazz) {
        Map<Class<? extends ConfiguredObject>, Collection<ConfiguredObjectAttribute<?, ?>>> map = this._allAttributes;
        synchronized (map) {
            if (this._allAttributes.containsKey(clazz)) {
                return;
            }
            ConfiguredObjectTypeRegistry.doWithAllParents(clazz, new Action<Class<? extends ConfiguredObject>>(){

                @Override
                public void performAction(Class<? extends ConfiguredObject> parent) {
                    ConfiguredObjectTypeRegistry.this.process(parent);
                }
            });
            final TreeSet attributeSet = new TreeSet(OBJECT_NAME_COMPARATOR);
            final TreeSet statisticSet = new TreeSet(OBJECT_NAME_COMPARATOR);
            final HashSet managedInterfaces = new HashSet();
            final HashSet operationsSet = new HashSet();
            final HashSet<String> contextSet = new HashSet<String>();
            this._allAttributes.put(clazz, attributeSet);
            this._allStatistics.put(clazz, statisticSet);
            this._allManagedInterfaces.put(clazz, managedInterfaces);
            this._allOperations.put(clazz, operationsSet);
            this._contextUses.put(clazz, contextSet);
            ConfiguredObjectTypeRegistry.doWithAllParents(clazz, new Action<Class<? extends ConfiguredObject>>(){

                @Override
                public void performAction(Class<? extends ConfiguredObject> parent) {
                    ConfiguredObjectTypeRegistry.this.initialiseWithParentAttributes(attributeSet, statisticSet, managedInterfaces, operationsSet, contextSet, parent);
                }
            });
            this.processMethods(clazz, attributeSet, statisticSet, operationsSet);
            this.processAttributesTypesAndFields(clazz);
            this.processDefaultContext(clazz, contextSet);
            this.processStateChangeMethods(clazz);
            this.processManagedInterfaces(clazz);
            this.processContextUages(clazz, contextSet);
        }
    }

    private <X extends ConfiguredObject> void processContextUages(Class<X> clazz, Set<String> contextSet) {
        if (clazz.isAnnotationPresent(ManagedContextDependency.class)) {
            ManagedContextDependency dependencies = clazz.getAnnotation(ManagedContextDependency.class);
            for (String dependency : dependencies.value()) {
                contextSet.add(dependency);
            }
        }
    }

    private static void doWithAllParents(Class<?> clazz, Action<Class<? extends ConfiguredObject>> action) {
        for (Class<?> parent : clazz.getInterfaces()) {
            if (!ConfiguredObject.class.isAssignableFrom(parent)) continue;
            action.performAction(parent);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && ConfiguredObject.class.isAssignableFrom(superclass)) {
            action.performAction(superclass);
        }
    }

    private <X extends ConfiguredObject> void processMethods(Class<X> clazz, SortedSet<ConfiguredObjectAttribute<?, ?>> attributeSet, SortedSet<ConfiguredObjectStatistic<?, ?>> statisticSet, Set<ConfiguredObjectOperation<?>> operationsSet) {
        for (Method method : clazz.getDeclaredMethods()) {
            this.processMethod(clazz, attributeSet, statisticSet, operationsSet, method);
        }
        for (ConfiguredObjectAttributeInjector injector : this._attributeInjectors) {
            for (ConfiguredObjectInjectedAttribute<?, ?> configuredObjectInjectedAttribute : injector.getInjectedAttributes()) {
                if (!configuredObjectInjectedAttribute.appliesToConfiguredObjectType(clazz)) continue;
                attributeSet.add(configuredObjectInjectedAttribute);
            }
            for (ConfiguredObjectInjectedStatistic configuredObjectInjectedStatistic : injector.getInjectedStatistics()) {
                if (!configuredObjectInjectedStatistic.appliesToConfiguredObjectType(clazz)) continue;
                statisticSet.add(configuredObjectInjectedStatistic);
            }
            for (ConfiguredObjectInjectedOperation configuredObjectInjectedOperation : injector.getInjectedOperations()) {
                if (!configuredObjectInjectedOperation.appliesToConfiguredObjectType(clazz)) continue;
                operationsSet.add(configuredObjectInjectedOperation);
            }
        }
    }

    private <X extends ConfiguredObject> void processMethod(Class<X> clazz, SortedSet<ConfiguredObjectAttribute<?, ?>> attributeSet, SortedSet<ConfiguredObjectStatistic<?, ?>> statisticSet, Set<ConfiguredObjectOperation<?>> operationsSet, Method m) {
        if (m.isAnnotationPresent(ManagedAttribute.class)) {
            this.processManagedAttribute(clazz, attributeSet, m);
        } else if (m.isAnnotationPresent(DerivedAttribute.class)) {
            this.processDerivedAttribute(clazz, attributeSet, m);
        } else if (m.isAnnotationPresent(ManagedStatistic.class)) {
            this.processManagedStatistic(clazz, statisticSet, m);
        } else if (m.isAnnotationPresent(ManagedOperation.class)) {
            this.processManagedOperation(clazz, operationsSet, m);
        }
    }

    private <X extends ConfiguredObject> void processManagedStatistic(Class<X> clazz, SortedSet<ConfiguredObjectStatistic<?, ?>> statisticSet, Method m) {
        ManagedStatistic statAnnotation = m.getAnnotation(ManagedStatistic.class);
        if (!clazz.isInterface() || !ConfiguredObject.class.isAssignableFrom(clazz)) {
            throw new ServerScopedRuntimeException("Can only define ManagedStatistics on interfaces which extend " + ConfiguredObject.class.getSimpleName() + ". " + clazz.getSimpleName() + " does not meet these criteria.");
        }
        ConfiguredObjectMethodStatistic statistic = new ConfiguredObjectMethodStatistic(clazz, m, statAnnotation);
        if (statisticSet.contains(statistic)) {
            statisticSet.remove(statistic);
        }
        statisticSet.add(statistic);
    }

    private <X extends ConfiguredObject> void processDerivedAttribute(Class<X> clazz, SortedSet<ConfiguredObjectAttribute<?, ?>> attributeSet, Method m) {
        DerivedAttribute annotation = m.getAnnotation(DerivedAttribute.class);
        if (!clazz.isInterface() || !ConfiguredObject.class.isAssignableFrom(clazz)) {
            throw new ServerScopedRuntimeException("Can only define DerivedAttributes on interfaces which extend " + ConfiguredObject.class.getSimpleName() + ". " + clazz.getSimpleName() + " does not meet these criteria.");
        }
        ConfiguredDerivedMethodAttribute attribute = new ConfiguredDerivedMethodAttribute(clazz, m, annotation);
        if (attributeSet.contains(attribute)) {
            attributeSet.remove(attribute);
        }
        attributeSet.add(attribute);
    }

    private <X extends ConfiguredObject> void processManagedAttribute(Class<X> clazz, SortedSet<ConfiguredObjectAttribute<?, ?>> attributeSet, Method m) {
        ManagedAttribute annotation = m.getAnnotation(ManagedAttribute.class);
        if (!clazz.isInterface() || !ConfiguredObject.class.isAssignableFrom(clazz)) {
            throw new ServerScopedRuntimeException("Can only define ManagedAttributes on interfaces which extend " + ConfiguredObject.class.getSimpleName() + ". " + clazz.getSimpleName() + " does not meet these criteria.");
        }
        ConfiguredAutomatedAttribute attribute = new ConfiguredAutomatedAttribute(clazz, m, annotation);
        if (attributeSet.contains(attribute)) {
            attributeSet.remove(attribute);
        }
        attributeSet.add(attribute);
    }

    private <X extends ConfiguredObject> void processManagedOperation(Class<X> clazz, Set<ConfiguredObjectOperation<?>> operationSet, Method m) {
        ManagedOperation annotation = m.getAnnotation(ManagedOperation.class);
        if (!clazz.isInterface() || !ConfiguredObject.class.isAssignableFrom(clazz)) {
            throw new ServerScopedRuntimeException("Can only define ManagedOperations on interfaces which extend " + ConfiguredObject.class.getSimpleName() + ". " + clazz.getSimpleName() + " does not meet these criteria.");
        }
        ConfiguredObjectMethodOperation<X> operation = new ConfiguredObjectMethodOperation<X>(clazz, m, this);
        Iterator<ConfiguredObjectOperation<?>> iter = operationSet.iterator();
        while (iter.hasNext()) {
            ConfiguredObjectOperation<?> existingOperation = iter.next();
            if (!operation.getName().equals(existingOperation.getName())) continue;
            if (!operation.hasSameParameters(existingOperation)) {
                throw new IllegalArgumentException("Cannot redefine the operation " + operation.getName() + " with different parameters in " + clazz.getSimpleName());
            }
            iter.remove();
            break;
        }
        operationSet.add(operation);
    }

    private void initialiseWithParentAttributes(SortedSet<ConfiguredObjectAttribute<?, ?>> attributeSet, SortedSet<ConfiguredObjectStatistic<?, ?>> statisticSet, Set<Class<? extends ManagedInterface>> managedInterfaces, Set<ConfiguredObjectOperation<?>> operationsSet, Set<String> contextSet, Class<? extends ConfiguredObject> parent) {
        attributeSet.addAll(this._allAttributes.get(parent));
        statisticSet.addAll(this._allStatistics.get(parent));
        managedInterfaces.addAll((Collection<Class<? extends ManagedInterface>>)this._allManagedInterfaces.get(parent));
        operationsSet.addAll((Collection)this._allOperations.get(parent));
        contextSet.addAll((Collection<String>)this._contextUses.get(parent));
    }

    private <X extends ConfiguredObject> void processAttributesTypesAndFields(Class<X> clazz) {
        TreeMap attrMap = new TreeMap(NAME_COMPARATOR);
        HashMap<String, AutomatedField> fieldMap = new HashMap<String, AutomatedField>();
        Collection<ConfiguredObjectAttribute<?, ?>> attrCol = this._allAttributes.get(clazz);
        for (ConfiguredObjectAttribute<?, ?> attr : attrCol) {
            attrMap.put(attr.getName(), attr);
            if (!attr.isAutomated()) continue;
            fieldMap.put(attr.getName(), this.findField(attr, clazz));
        }
        for (ConfiguredObjectAttributeInjector injector : this._attributeInjectors) {
            for (ConfiguredObjectInjectedAttribute<?, ?> attr : injector.getInjectedAttributes()) {
                if (attrMap.containsKey(attr.getName()) || !attr.appliesToConfiguredObjectType(clazz)) continue;
                attrMap.put(attr.getName(), attr);
            }
        }
        this._allAttributeTypes.put(clazz, attrMap);
        this._allAutomatedFields.put(clazz, fieldMap);
    }

    private <X extends ConfiguredObject> void processDefaultContext(Class<X> clazz, Set<String> contextSet) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !field.isAnnotationPresent(ManagedContextDefault.class)) continue;
            try {
                String stringValue;
                ManagedContextDefault annotation = field.getAnnotation(ManagedContextDefault.class);
                String name = annotation.name();
                Object value = field.get(null);
                if (!this._defaultContext.containsKey(name)) {
                    if (value instanceof Collection || value instanceof Map) {
                        try {
                            stringValue = ConfiguredObjectJacksonModule.newObjectMapper(false).writeValueAsString(value);
                        }
                        catch (JsonProcessingException e) {
                            throw new ServerScopedRuntimeException("Unable to convert value of type '" + value.getClass() + "' to a JSON string for context variable ${" + name + "}");
                        }
                    } else {
                        stringValue = String.valueOf(value);
                    }
                } else {
                    throw new IllegalArgumentException("Multiple definitions of the default context variable ${" + name + "}");
                }
                this._defaultContext.put(name, stringValue);
                this._contextDefinitions.put(name, annotation);
                contextSet.add(name);
            }
            catch (IllegalAccessException e) {
                throw new ServerScopedRuntimeException("Unexpected illegal access exception (only inspecting public static fields)", e);
            }
        }
    }

    private void processStateChangeMethods(Class<? extends ConfiguredObject> clazz) {
        final HashMap<State, Map<State, Method>> map = new HashMap<State, Map<State, Method>>();
        this._stateChangeMethods.put(clazz, map);
        this.addStateTransitions(clazz, map);
        ConfiguredObjectTypeRegistry.doWithAllParents(clazz, new Action<Class<? extends ConfiguredObject>>(){

            @Override
            public void performAction(Class<? extends ConfiguredObject> parent) {
                ConfiguredObjectTypeRegistry.this.inheritTransitions(parent, map);
            }
        });
    }

    private void inheritTransitions(Class<? extends ConfiguredObject> parent, Map<State, Map<State, Method>> map) {
        Map<State, Map<State, Method>> parentMap = this._stateChangeMethods.get(parent);
        for (Map.Entry<State, Map<State, Method>> parentEntry : parentMap.entrySet()) {
            if (map.containsKey((Object)parentEntry.getKey())) {
                Map<State, Method> methodMap = map.get((Object)parentEntry.getKey());
                for (Map.Entry<State, Method> methodEntry : parentEntry.getValue().entrySet()) {
                    if (methodMap.containsKey((Object)methodEntry.getKey())) continue;
                    methodMap.put(methodEntry.getKey(), methodEntry.getValue());
                }
                continue;
            }
            map.put(parentEntry.getKey(), new HashMap<State, Method>(parentEntry.getValue()));
        }
    }

    private void addStateTransitions(Class<? extends ConfiguredObject> clazz, Map<State, Map<State, Method>> map) {
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(StateTransition.class)) continue;
            if (ListenableFuture.class.isAssignableFrom(m.getReturnType())) {
                if (m.getParameterTypes().length == 0) {
                    m.setAccessible(true);
                    StateTransition annotation = m.getAnnotation(StateTransition.class);
                    for (State state : annotation.currentState()) {
                        this.addStateTransition(state, annotation.desiredState(), m, map);
                    }
                    continue;
                }
                throw new ServerScopedRuntimeException("A state transition method must have no arguments. Method " + m.getName() + " on " + clazz.getName() + " does not meet this criteria.");
            }
            throw new ServerScopedRuntimeException("A state transition method must return a ListenableFuture. Method " + m.getName() + " on " + clazz.getName() + " does not meet this criteria.");
        }
    }

    private void addStateTransition(State fromState, State toState, Method method, Map<State, Map<State, Method>> map) {
        if (map.containsKey((Object)fromState)) {
            Map<State, Method> toMap = map.get((Object)fromState);
            if (!toMap.containsKey((Object)toState)) {
                toMap.put(toState, method);
            }
        } else {
            HashMap<State, Method> toMap = new HashMap<State, Method>();
            toMap.put(toState, method);
            map.put(fromState, toMap);
        }
    }

    private AutomatedField findField(ConfiguredObjectAttribute<?, ?> attr, Class<?> objClass) {
        for (Class<?> clazz = objClass; clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ManagedAttributeField.class) || !field.getName().equals("_" + attr.getName().replace('.', '_'))) continue;
                try {
                    Method afterSet;
                    Method beforeSet;
                    ManagedAttributeField annotation = field.getAnnotation(ManagedAttributeField.class);
                    field.setAccessible(true);
                    if (!"".equals(annotation.beforeSet())) {
                        beforeSet = clazz.getDeclaredMethod(annotation.beforeSet(), new Class[0]);
                        beforeSet.setAccessible(true);
                    } else {
                        beforeSet = null;
                    }
                    if (!"".equals(annotation.afterSet())) {
                        afterSet = clazz.getDeclaredMethod(annotation.afterSet(), new Class[0]);
                        afterSet.setAccessible(true);
                    } else {
                        afterSet = null;
                    }
                    return new AutomatedField(field, beforeSet, afterSet);
                }
                catch (NoSuchMethodException e) {
                    throw new ServerScopedRuntimeException("Cannot find method referenced by annotation for pre/post setting action", e);
                }
            }
        }
        if (objClass.isInterface() || Modifier.isAbstract(objClass.getModifiers())) {
            return null;
        }
        throw new ServerScopedRuntimeException("Unable to find field definition for automated field " + attr.getName() + " in class " + objClass.getName());
    }

    public <X extends ConfiguredObject> Collection<String> getAttributeNames(Class<X> clazz) {
        final Collection<ConfiguredObjectAttribute<X, ?>> attrs = this.getAttributes(clazz);
        return new AbstractCollection<String>(){

            @Override
            public Iterator<String> iterator() {
                final Iterator underlyingIterator = attrs.iterator();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return underlyingIterator.hasNext();
                    }

                    @Override
                    public String next() {
                        return ((ConfiguredObjectAttribute)underlyingIterator.next()).getName();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return attrs.size();
            }
        };
    }

    protected <X extends ConfiguredObject> Collection<ConfiguredObjectAttribute<? super X, ?>> getAttributes(Class<X> clazz) {
        this.processClassIfNecessary(clazz);
        Collection<ConfiguredObjectAttribute<? super X, ?>> attributes = this._allAttributes.get(clazz);
        return attributes;
    }

    private <X extends ConfiguredObject> void processClassIfNecessary(Class<X> clazz) {
        if (!this._allAttributes.containsKey(clazz)) {
            this.process(clazz);
        }
    }

    public Collection<ConfiguredObjectStatistic<?, ?>> getStatistics(Class<? extends ConfiguredObject> clazz) {
        this.processClassIfNecessary(clazz);
        Collection<ConfiguredObjectStatistic<?, ?>> statistics = this._allStatistics.get(clazz);
        return statistics;
    }

    public Map<String, ConfiguredObjectOperation<?>> getOperations(Class<? extends ConfiguredObject> clazz) {
        return this.getOperations(clazz, null);
    }

    public Map<String, ConfiguredObjectOperation<?>> getOperations(Class<? extends ConfiguredObject> clazz, Predicate<ConfiguredObjectOperation<?>> predicate) {
        this.processClassIfNecessary(clazz);
        Set<ConfiguredObjectOperation<?>> operations = this._allOperations.get(clazz);
        if (operations == null) {
            return Collections.emptyMap();
        }
        HashMap returnVal = new HashMap();
        for (ConfiguredObjectOperation<?> operation : operations) {
            if (predicate != null && !predicate.test(operation)) continue;
            returnVal.put(operation.getName(), operation);
        }
        return returnVal;
    }

    public Map<String, ConfiguredObjectAttribute<?, ?>> getAttributeTypes(Class<? extends ConfiguredObject> clazz) {
        this.processClassIfNecessary(clazz);
        return this._allAttributeTypes.get(clazz);
    }

    Map<String, AutomatedField> getAutomatedFields(Class<? extends ConfiguredObject> clazz) {
        this.processClassIfNecessary(clazz);
        return this._allAutomatedFields.get(clazz);
    }

    Map<State, Map<State, Method>> getStateChangeMethods(Class<? extends ConfiguredObject> objectClass) {
        this.processClassIfNecessary(objectClass);
        Map<State, Map<State, Method>> map = this._stateChangeMethods.get(objectClass);
        return map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    public Map<String, String> getDefaultContext() {
        return Collections.unmodifiableMap(this._defaultContext);
    }

    public Set<Class<? extends ManagedInterface>> getManagedInterfaces(Class<? extends ConfiguredObject> classObject) {
        this.processClassIfNecessary(classObject);
        Set<Class<? extends ManagedInterface>> interfaces = this._allManagedInterfaces.get(classObject);
        return interfaces == null ? Collections.emptySet() : interfaces;
    }

    private <X extends ConfiguredObject> void processManagedInterfaces(Class<X> clazz) {
        Set<Class<? extends ManagedInterface>> managedInterfaces = this._allManagedInterfaces.get(clazz);
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!iface.isAnnotationPresent(ManagedAnnotation.class) || !ManagedInterface.class.isAssignableFrom(iface)) continue;
            managedInterfaces.add(iface);
        }
    }

    public Collection<String> getValidChildTypes(Class<? extends ConfiguredObject> type, Class<? extends ConfiguredObject> childType) {
        return this.getValidChildTypes(type, ConfiguredObjectTypeRegistry.getCategory(childType).getSimpleName());
    }

    public Collection<String> getValidChildTypes(Class<? extends ConfiguredObject> type, String childCategory) {
        Map<String, Collection<String>> allValidChildTypes = this._validChildTypes.get(this.getTypeClass(type));
        if (allValidChildTypes != null) {
            Collection<String> validTypesForSpecificChild = allValidChildTypes.get(childCategory);
            return validTypesForSpecificChild == null ? null : Collections.unmodifiableCollection(validTypesForSpecificChild);
        }
        return null;
    }

    public Collection<ManagedContextDefault> getContextDependencies(Class<? extends ConfiguredObject> type) {
        Collection dependencyNames = this._contextUses.get(type);
        if (dependencyNames != null) {
            ArrayList<ManagedContextDefault> dependencies = new ArrayList<ManagedContextDefault>(dependencyNames.size());
            for (String dependencyName : dependencyNames) {
                dependencies.add(this._contextDefinitions.get(dependencyName));
            }
            return dependencies;
        }
        return Collections.emptySet();
    }

    public Collection<ManagedContextDefault> getTypeSpecificContextDependencies(Class<? extends ConfiguredObject> type) {
        Collection<ManagedContextDefault> contextDependencies = this.getContextDependencies(type);
        contextDependencies.removeAll(this.getContextDependencies(ConfiguredObjectTypeRegistry.getCategory(type)));
        return contextDependencies;
    }

    static {
        int i = 0;
        for (String name : Arrays.asList("id", "name", "description", "type", "desiredState", "state", "durable", "lifetimePolicy", "context")) {
            STANDARD_FIRST_FIELDS_ORDER.put(name, i++);
        }
        STANDARD_LAST_FIELDS_ORDER = new HashMap<String, Integer>();
        i = 0;
        for (String name : Arrays.asList("lastUpdatedBy", "lastUpdatedTime", "createdBy", "createdTime")) {
            STANDARD_LAST_FIELDS_ORDER.put(name, i++);
        }
        OBJECT_NAME_COMPARATOR = new Comparator<ConfiguredObjectAttributeOrStatistic<?, ?>>(){

            @Override
            public int compare(ConfiguredObjectAttributeOrStatistic<?, ?> left, ConfiguredObjectAttributeOrStatistic<?, ?> right) {
                String leftName = left.getName();
                String rightName = right.getName();
                return ConfiguredObjectTypeRegistry.compareAttributeNames(leftName, rightName);
            }
        };
        NAME_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                return ConfiguredObjectTypeRegistry.compareAttributeNames(left, right);
            }
        };
    }

    static class AutomatedField {
        private final Field _field;
        private final Method _preSettingAction;
        private final Method _postSettingAction;

        private AutomatedField(Field field, Method preSettingAction, Method postSettingAction) {
            this._field = field;
            this._preSettingAction = preSettingAction;
            this._postSettingAction = postSettingAction;
        }

        public Field getField() {
            return this._field;
        }

        public Method getPreSettingAction() {
            return this._preSettingAction;
        }

        public Method getPostSettingAction() {
            return this._postSettingAction;
        }
    }
}

