/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.TrustManager;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.CertificateDetails;

@ManagedObject(defaultType="FileTrustStore")
public interface TrustStore<X extends TrustStore<X>>
extends ConfiguredObject<X> {
    public static final String TRUST_ANCHOR_VALIDITY_ENFORCED = "trustAnchorValidityEnforced";
    public static final String CERTIFICATE_EXPIRY_WARN_PERIOD = "qpid.truststore.certificateExpiryWarnPeriod";
    @ManagedContextDefault(name="qpid.truststore.certificateExpiryWarnPeriod", description="The number of days before a certificate's expiry that certificate expiration warnings will be written to the log")
    public static final int DEFAULT_CERTIFICATE_EXPIRY_WARN_PERIOD = 30;
    public static final String CERTIFICATE_EXPIRY_CHECK_FREQUENCY = "qpid.truststore.certificateExpiryCheckFrequency";
    @ManagedContextDefault(name="qpid.truststore.certificateExpiryCheckFrequency", description="Period (in days) with which the Broker will repeat the certificate expiration warning")
    public static final int DEFAULT_CERTIFICATE_EXPIRY_CHECK_FREQUENCY = 1;
    @ManagedContextDefault(name="qpid.truststore.trustAnchorValidityEnforced")
    public static final boolean DEFAULT_TRUST_ANCHOR_VALIDITY_ENFORCED = false;

    @Override
    @ManagedAttribute(immutable=true)
    public String getName();

    @ManagedAttribute(defaultValue="false", description="If true the Trust Store will expose its certificates as a special artificial message source.")
    public boolean isExposedAsMessageSource();

    @ManagedAttribute(defaultValue="[]", description="If 'exposedAsMessageSource' is true, the trust store will expose its certificates only to VirtualHostNodes in this list or if this list is empty to all VirtualHostNodes who are not in the 'excludedVirtualHostNodeMessageSources' list.")
    public List<VirtualHostNode<?>> getIncludedVirtualHostNodeMessageSources();

    @ManagedAttribute(defaultValue="[]", description="If 'exposedAsMessageSource' is true and 'includedVirtualHostNodeMessageSources' is empty, the trust store will expose its certificates only to VirtualHostNodes who are not in this list.")
    public List<VirtualHostNode<?>> getExcludedVirtualHostNodeMessageSources();

    @ManagedAttribute(defaultValue="${qpid.truststore.trustAnchorValidityEnforced}", description="If true, the trust anchor's validity dates will be enforced.")
    public boolean isTrustAnchorValidityEnforced();

    @DerivedAttribute(description="List of details about the certificates like validity dates, SANs, issuer and subject names, etc.")
    public List<CertificateDetails> getCertificateDetails();

    @DerivedAttribute
    public int getCertificateExpiryWarnPeriod();

    @DerivedAttribute
    public int getCertificateExpiryCheckFrequency();

    public TrustManager[] getTrustManagers() throws GeneralSecurityException;

    public Certificate[] getCertificates() throws GeneralSecurityException;
}

