/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import java.util.Set;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.PortManager;

@ManagedObject(category=false, type="HTTP", amqpName="org.apache.qpid.HttpPort")
public interface HttpPort<X extends HttpPort<X>>
extends Port<X> {
    public static final String DEFAULT_HTTP_NEED_CLIENT_AUTH = "false";
    public static final String DEFAULT_HTTP_WANT_CLIENT_AUTH = "false";
    public static final String THREAD_POOL_MINIMUM = "threadPoolMinimum";
    public static final String THREAD_POOL_MAXIMUM = "threadPoolMaximum";
    public static final String PORT_HTTP_NUMBER_OF_SELECTORS = "qpid.port.http.threadPool.numberOfSelectors";
    @ManagedContextDefault(name="qpid.port.http.threadPool.numberOfSelectors", description="Desired number of selectors, if negative the number of selector is determined by Jetty")
    public static final long DEFAULT_PORT_HTTP_NUMBER_OF_SELECTORS = -1L;
    public static final String PORT_HTTP_NUMBER_OF_ACCEPTORS = "qpid.port.http.threadPool.numberOfAcceptors";
    @ManagedContextDefault(name="qpid.port.http.threadPool.numberOfAcceptors", description="Desired number of acceptors. If negative the number of acceptors is determined by Jetty. If zero, the selector threads are used as acceptors.")
    public static final long DEFAULT_PORT_HTTP_NUMBER_OF_ACCEPTORS = -1L;
    public static final String PORT_HTTP_ACCEPT_BACKLOG = "qpid.port.http.acceptBacklog";
    @ManagedContextDefault(name="qpid.port.http.acceptBacklog", description="The size of the pending connection backlog")
    public static final int DEFAULT_PORT_HTTP_ACCEPT_BACKLOG = 1024;
    public static final String ABSOLUTE_SESSION_TIMEOUT = "qpid.port.http.absoluteSessionTimeout";
    @ManagedContextDefault(name="qpid.port.http.absoluteSessionTimeout", description="The maximum amount of time (in milliseconds) a session can be active.")
    public static final long DEFAULT_ABSOLUTE_SESSION_TIMEOUT = -1L;
    public static final String TLS_SESSION_TIMEOUT = "qpid.port.http.tlsSessionTimeout";
    @ManagedContextDefault(name="qpid.port.http.tlsSessionTimeout", description="TLS session timeout for HTTP ports (seconds).")
    public static final int DEFAULT_TLS_SESSION_TIMEOUT = 900;
    public static final String TLS_SESSION_CACHE_SIZE = "qpid.port.http.tlsSessionCacheSize";
    @ManagedContextDefault(name="qpid.port.http.tlsSessionCacheSize", description="TLS session cache size for HTTP ports.")
    public static final int DEFAULT_TLS_SESSION_CACHE_SIZE = 1000;
    public static final String PORT_HTTP_THREAD_POOL_MAXIMUM = "port.http.threadPool.maximum";
    @ManagedContextDefault(name="port.http.threadPool.maximum")
    public static final long DEFAULT_PORT_HTTP_THREAD_POOL_MAXIMUM = 24L;
    public static final String PORT_HTTP_THREAD_POOL_MINIMUM = "port.http.threadPool.minimum";
    @ManagedContextDefault(name="port.http.threadPool.minimum")
    public static final long DEFAULT_PORT_HTTP_THREAD_POOL_MINIMUM = 8L;

    @ManagedAttribute(defaultValue="*")
    public String getBindingAddress();

    @Override
    @ManagedAttribute(defaultValue="false")
    public boolean getNeedClientAuth();

    @Override
    @ManagedAttribute(defaultValue="false")
    public boolean getWantClientAuth();

    @Override
    @ManagedAttribute(defaultValue="TCP", validValues={"[ \"TCP\" ]", "[ \"SSL\" ]", "[ \"TCP\", \"SSL\" ]"})
    public Set<Transport> getTransports();

    @Override
    @ManagedAttribute(defaultValue="HTTP", validValues={"[ \"HTTP\"]"})
    public Set<Protocol> getProtocols();

    public void setPortManager(PortManager var1);

    @ManagedAttribute(defaultValue="${port.http.threadPool.maximum}")
    public int getThreadPoolMaximum();

    @ManagedAttribute(defaultValue="${port.http.threadPool.minimum}")
    public int getThreadPoolMinimum();

    @ManagedAttribute(defaultValue="true", description="If true then this port will provide HTTP management services for the broker, if no virtualhostalaias matches the HTTP Host in the request")
    public boolean isManageBrokerOnNoAliasMatch();

    @DerivedAttribute(description="Desired number of acceptors. See context variable 'qpid.port.http.threadPool.numberOfAcceptors'")
    public int getDesiredNumberOfAcceptors();

    @DerivedAttribute(description="Desired number of selectors. See context variable 'qpid.port.http.threadPool.numberOfAcceptors'")
    public int getDesiredNumberOfSelectors();

    @DerivedAttribute(description="Size of accept backlog")
    public int getAcceptBacklogSize();

    @DerivedAttribute(description="Actual number of acceptors.")
    public int getNumberOfAcceptors();

    @DerivedAttribute(description="Actual number of selectors.")
    public int getNumberOfSelectors();

    @DerivedAttribute(description="This timeout defines the maximum amount of time (in milliseconds) a session can be active, regardless of any session activity. A value of zero or less disables the limit.")
    public long getAbsoluteSessionTimeout();
}

