/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectFactory;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.ConfiguredSettableAttribute;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.plugin.ConfiguredObjectTypeFactory;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.UnresolvedConfiguredObject;

@PluggableService
public class PortFactory<X extends Port<X>>
implements ConfiguredObjectTypeFactory<X> {
    public static final int DEFAULT_AMQP_SEND_BUFFER_SIZE = 262144;
    public static final int DEFAULT_AMQP_RECEIVE_BUFFER_SIZE = 262144;
    public static final boolean DEFAULT_AMQP_NEED_CLIENT_AUTH = false;
    public static final boolean DEFAULT_AMQP_WANT_CLIENT_AUTH = false;
    public static final boolean DEFAULT_AMQP_TCP_NO_DELAY = true;
    public static final String DEFAULT_AMQP_BINDING = "*";
    public static final Transport DEFAULT_TRANSPORT = Transport.TCP;

    private Protocol.ProtocolType getProtocolType(Map<String, Object> portAttributes, Broker<?> broker) {
        Model model = broker.getModel();
        ConfiguredObjectTypeRegistry typeRegistry = model.getTypeRegistry();
        Map<String, ConfiguredObjectAttribute<?, ?>> attributeTypes = typeRegistry.getAttributeTypes(Port.class);
        ConfiguredSettableAttribute protocolsAttribute = (ConfiguredSettableAttribute)attributeTypes.get("protocols");
        Set protocols = (Set)protocolsAttribute.convert(portAttributes.get("protocols"), broker);
        Protocol.ProtocolType protocolType = null;
        if (protocols == null || protocols.isEmpty()) {
            protocolType = Protocol.ProtocolType.AMQP;
        } else {
            for (Protocol protocol : protocols) {
                if (protocolType == null) {
                    protocolType = protocol.getProtocolType();
                    continue;
                }
                if (protocolType == protocol.getProtocolType()) continue;
                throw new IllegalConfigurationException("Found different protocol types '" + (Object)((Object)protocolType) + "' and '" + (Object)((Object)protocol.getProtocolType()) + "' for port configuration: " + portAttributes);
            }
        }
        return protocolType;
    }

    @Override
    public Class<? super Port> getCategoryClass() {
        return Port.class;
    }

    @Override
    public X create(ConfiguredObjectFactory factory, Map<String, Object> attributes, ConfiguredObject<?> parent) {
        return (X)((Port)this.getPortFactory(factory, attributes, (Broker)parent).create(factory, attributes, parent));
    }

    @Override
    public ListenableFuture<X> createAsync(ConfiguredObjectFactory factory, Map<String, Object> attributes, ConfiguredObject<?> parent) {
        return this.getPortFactory(factory, attributes, (Broker)parent).createAsync(factory, attributes, parent);
    }

    @Override
    public UnresolvedConfiguredObject<X> recover(ConfiguredObjectFactory factory, ConfiguredObjectRecord record, ConfiguredObject<?> parent) {
        return this.getPortFactory(factory, record.getAttributes(), (Broker)parent).recover(factory, record, parent);
    }

    public ConfiguredObjectTypeFactory<X> getPortFactory(ConfiguredObjectFactory factory, Map<String, Object> attributes, Broker<?> broker) {
        String type = attributes.containsKey("type") ? (String)attributes.get("type") : this.getProtocolType(attributes, broker).name();
        return factory.getConfiguredObjectTypeFactory(Port.class.getSimpleName(), type);
    }

    @Override
    public String getType() {
        return null;
    }
}

