/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Map;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.messages.QueueMessages;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.queue.OutOfOrderQueue;
import org.apache.qpid.server.queue.PriorityQueue;
import org.apache.qpid.server.queue.PriorityQueueList;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

public class PriorityQueueImpl
extends OutOfOrderQueue<PriorityQueueImpl>
implements PriorityQueue<PriorityQueueImpl> {
    private PriorityQueueList _entries;
    @ManagedAttributeField
    private int _priorities;

    @ManagedObjectFactoryConstructor
    public PriorityQueueImpl(Map<String, Object> attributes, QueueManagingVirtualHost<?> virtualHost) {
        super(attributes, virtualHost);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._entries = PriorityQueueList.newInstance(this);
    }

    @Override
    public int getPriorities() {
        return this._priorities;
    }

    @Override
    PriorityQueueList getEntries() {
        return this._entries;
    }

    @Override
    protected LogMessage getCreatedLogMessage() {
        String ownerString = this.getOwner();
        return QueueMessages.CREATED(this.getId().toString(), ownerString, this.getPriorities(), ownerString != null, this.getLifetimePolicy() != LifetimePolicy.PERMANENT, this.isDurable(), !this.isDurable(), true);
    }
}

