/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.OverflowPolicy;
import org.apache.qpid.server.queue.MessageGroupType;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueArgumentsConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueArgumentsConverter.class);
    private static final String SHARED_MSG_GROUP_ARG_VALUE = "1";
    private static final String X_QPID_FLOW_RESUME_CAPACITY = "x-qpid-flow-resume-capacity";
    private static final String X_QPID_CAPACITY = "x-qpid-capacity";
    private static final String X_QPID_MINIMUM_ALERT_REPEAT_GAP = "x-qpid-minimum-alert-repeat-gap";
    private static final String X_QPID_MAXIMUM_MESSAGE_COUNT = "x-qpid-maximum-message-count";
    private static final String X_QPID_MAXIMUM_MESSAGE_SIZE = "x-qpid-maximum-message-size";
    private static final String X_QPID_MAXIMUM_MESSAGE_AGE = "x-qpid-maximum-message-age";
    private static final String X_QPID_MAXIMUM_QUEUE_DEPTH = "x-qpid-maximum-queue-depth";
    private static final String QPID_ALERT_COUNT = "qpid.alert_count";
    private static final String QPID_ALERT_SIZE = "qpid.alert_size";
    private static final String QPID_ALERT_REPEAT_GAP = "qpid.alert_repeat_gap";
    public static final String X_QPID_PRIORITIES = "x-qpid-priorities";
    public static final String X_QPID_DESCRIPTION = "x-qpid-description";
    private static final String QPID_LAST_VALUE_QUEUE_KEY = "qpid.last_value_queue_key";
    private static final String QPID_QUEUE_SORT_KEY = "qpid.queue_sort_key";
    static final String X_QPID_DLQ_ENABLED = "x-qpid-dlq-enabled";
    private static final String X_QPID_MAXIMUM_DELIVERY_COUNT = "x-qpid-maximum-delivery-count";
    static final String QPID_GROUP_HEADER_KEY = "qpid.group_header_key";
    static final String QPID_SHARED_MSG_GROUP = "qpid.shared_msg_group";
    private static final String QPID_DEFAULT_MESSAGE_GROUP_ARG = "qpid.default-message-group";
    private static final String QPID_MESSAGE_DURABILITY = "qpid.message_durability";
    private static final String QPID_LAST_VALUE_QUEUE = "qpid.last_value_queue";
    private static final String QPID_DEFAULT_FILTERS = "qpid.default_filters";
    private static final String QPID_ENSURE_NONDESTRUCTIVE_CONSUMERS = "qpid.ensure_nondestructive_consumers";
    private static final String QPID_EXCLUSIVITY_POLICY = "qpid.exclusivity_policy";
    private static final String QPID_LIFETIME_POLICY = "qpid.lifetime_policy";
    private static final String QPID_POLICY_TYPE = "qpid.policy_type";
    private static final String QPID_MAX_COUNT = "qpid.max_count";
    private static final String QPID_MAX_SIZE = "qpid.max_size";
    private static final String QPID_NO_LOCAL = "no-local";
    private static final Map<String, String> ATTRIBUTE_MAPPINGS = new LinkedHashMap<String, String>();
    private static final String ALTERNATE_EXCHANGE = "alternateExchange";
    private static final String DEFAULT_DLQ_NAME_SUFFIX = "_DLQ";
    private static final String PROPERTY_DEAD_LETTER_QUEUE_SUFFIX = "qpid.broker_dead_letter_queue_suffix";

    public static Map<String, Object> convertWireArgsToModel(String queueName, Map<String, Object> wireArguments) {
        HashMap<String, Object> modelArguments = new HashMap<String, Object>();
        if (wireArguments != null) {
            Object argument;
            for (Map.Entry<String, String> entry : ATTRIBUTE_MAPPINGS.entrySet()) {
                if (!wireArguments.containsKey(entry.getKey())) continue;
                modelArguments.put(entry.getValue(), wireArguments.get(entry.getKey()));
            }
            if (wireArguments.containsKey(QPID_LAST_VALUE_QUEUE) && !wireArguments.containsKey(QPID_LAST_VALUE_QUEUE_KEY)) {
                modelArguments.put("lvqKey", "qpid.LVQ_key");
            }
            if (wireArguments.containsKey(QPID_POLICY_TYPE)) {
                modelArguments.put("overflowPolicy", (Object)OverflowPolicy.valueOf(String.valueOf(wireArguments.get(QPID_POLICY_TYPE)).toUpperCase()));
            }
            if (wireArguments.containsKey(QPID_SHARED_MSG_GROUP) && SHARED_MSG_GROUP_ARG_VALUE.equals(String.valueOf(wireArguments.get(QPID_SHARED_MSG_GROUP)))) {
                modelArguments.put("messageGroupType", (Object)MessageGroupType.SHARED_GROUPS);
            } else if (wireArguments.containsKey(QPID_GROUP_HEADER_KEY)) {
                modelArguments.put("messageGroupType", (Object)MessageGroupType.STANDARD);
                if ("JMSXGroupId".equals(wireArguments.get(QPID_GROUP_HEADER_KEY))) {
                    modelArguments.remove("messageGroupKeyOverride");
                }
            }
            if (wireArguments.get(QPID_NO_LOCAL) != null) {
                modelArguments.put("noLocal", Boolean.parseBoolean(wireArguments.get(QPID_NO_LOCAL).toString()));
            }
            if (wireArguments.get(X_QPID_FLOW_RESUME_CAPACITY) != null && wireArguments.get(X_QPID_CAPACITY) != null) {
                double maximumCapacity;
                double resumeCapacity = Integer.parseInt(wireArguments.get(X_QPID_FLOW_RESUME_CAPACITY).toString());
                if (resumeCapacity > (maximumCapacity = (double)Integer.parseInt(wireArguments.get(X_QPID_CAPACITY).toString()))) {
                    throw new ConnectionScopedRuntimeException("Flow resume size can't be greater than flow control size");
                }
                HashMap<String, String> context = (HashMap<String, String>)modelArguments.get("context");
                if (context == null) {
                    context = new HashMap<String, String>();
                    modelArguments.put("context", context);
                }
                double ratio = resumeCapacity / maximumCapacity;
                context.put("queue.queueFlowResumeLimit", String.format("%.2f", ratio * 100.0));
                modelArguments.put("overflowPolicy", (Object)OverflowPolicy.PRODUCER_FLOW_CONTROL);
            }
            if (wireArguments.get(ALTERNATE_EXCHANGE) != null) {
                modelArguments.put("alternateBinding", Collections.singletonMap("destination", wireArguments.get(ALTERNATE_EXCHANGE)));
            } else if (wireArguments.containsKey(X_QPID_DLQ_ENABLED) && ((argument = wireArguments.get(X_QPID_DLQ_ENABLED)) instanceof Boolean && ((Boolean)argument).booleanValue() || argument instanceof String && Boolean.parseBoolean((String)argument))) {
                modelArguments.put("alternateBinding", Collections.singletonMap("destination", QueueArgumentsConverter.getDeadLetterQueueName(queueName)));
            }
        }
        return modelArguments;
    }

    public static Map<String, Object> convertModelArgsToWire(Map<String, Object> modelArguments) {
        HashMap<String, Object> wireArguments = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : ATTRIBUTE_MAPPINGS.entrySet()) {
            if (!modelArguments.containsKey(entry.getValue())) continue;
            Object value = modelArguments.get(entry.getValue());
            if (value instanceof Enum) {
                value = ((Enum)value).name();
            } else if (value instanceof ConfiguredObject) {
                value = ((ConfiguredObject)value).getName();
            }
            wireArguments.put(entry.getKey(), value);
        }
        if (MessageGroupType.SHARED_GROUPS.equals(modelArguments.get("messageGroupType"))) {
            wireArguments.put(QPID_SHARED_MSG_GROUP, SHARED_MSG_GROUP_ARG_VALUE);
        }
        return wireArguments;
    }

    private static String getDeadLetterQueueName(String name) {
        return name + System.getProperty(PROPERTY_DEAD_LETTER_QUEUE_SUFFIX, DEFAULT_DLQ_NAME_SUFFIX);
    }

    static {
        ATTRIBUTE_MAPPINGS.put(X_QPID_MINIMUM_ALERT_REPEAT_GAP, "alertRepeatGap");
        ATTRIBUTE_MAPPINGS.put(X_QPID_MAXIMUM_MESSAGE_AGE, "alertThresholdMessageAge");
        ATTRIBUTE_MAPPINGS.put(X_QPID_MAXIMUM_MESSAGE_SIZE, "alertThresholdMessageSize");
        ATTRIBUTE_MAPPINGS.put(X_QPID_MAXIMUM_MESSAGE_COUNT, "alertThresholdQueueDepthMessages");
        ATTRIBUTE_MAPPINGS.put(X_QPID_MAXIMUM_QUEUE_DEPTH, "alertThresholdQueueDepthBytes");
        ATTRIBUTE_MAPPINGS.put(QPID_ALERT_COUNT, "alertThresholdQueueDepthMessages");
        ATTRIBUTE_MAPPINGS.put(QPID_ALERT_SIZE, "alertThresholdQueueDepthBytes");
        ATTRIBUTE_MAPPINGS.put(QPID_ALERT_REPEAT_GAP, "alertRepeatGap");
        ATTRIBUTE_MAPPINGS.put(X_QPID_MAXIMUM_DELIVERY_COUNT, "maximumDeliveryAttempts");
        ATTRIBUTE_MAPPINGS.put(X_QPID_CAPACITY, "maximumQueueDepthBytes");
        ATTRIBUTE_MAPPINGS.put(QPID_QUEUE_SORT_KEY, "sortKey");
        ATTRIBUTE_MAPPINGS.put(QPID_LAST_VALUE_QUEUE_KEY, "lvqKey");
        ATTRIBUTE_MAPPINGS.put(X_QPID_PRIORITIES, "priorities");
        ATTRIBUTE_MAPPINGS.put(X_QPID_DESCRIPTION, "description");
        ATTRIBUTE_MAPPINGS.put(QPID_GROUP_HEADER_KEY, "messageGroupKeyOverride");
        ATTRIBUTE_MAPPINGS.put(QPID_DEFAULT_MESSAGE_GROUP_ARG, "messageGroupDefaultGroup");
        ATTRIBUTE_MAPPINGS.put(QPID_NO_LOCAL, "noLocal");
        ATTRIBUTE_MAPPINGS.put(QPID_MESSAGE_DURABILITY, "messageDurability");
        ATTRIBUTE_MAPPINGS.put(QPID_DEFAULT_FILTERS, "defaultFilters");
        ATTRIBUTE_MAPPINGS.put(QPID_ENSURE_NONDESTRUCTIVE_CONSUMERS, "ensureNondestructiveConsumers");
        ATTRIBUTE_MAPPINGS.put(QPID_EXCLUSIVITY_POLICY, "exclusive");
        ATTRIBUTE_MAPPINGS.put(QPID_LIFETIME_POLICY, "lifetimePolicy");
        ATTRIBUTE_MAPPINGS.put(QPID_POLICY_TYPE, "overflowPolicy");
        ATTRIBUTE_MAPPINGS.put(QPID_MAX_COUNT, "maximumQueueDepthMessages");
        ATTRIBUTE_MAPPINGS.put(QPID_MAX_SIZE, "maximumQueueDepthBytes");
    }
}

