/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AbstractTrustStore;
import org.apache.qpid.server.security.FileTrustStore;
import org.apache.qpid.server.transport.network.security.ssl.QpidMultipleTrustManager;
import org.apache.qpid.server.transport.network.security.ssl.QpidPeersOnlyTrustManager;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;

public class FileTrustStoreImpl
extends AbstractTrustStore<FileTrustStoreImpl>
implements FileTrustStore<FileTrustStoreImpl> {
    @ManagedAttributeField
    private volatile String _trustStoreType;
    @ManagedAttributeField
    private volatile String _trustManagerFactoryAlgorithm;
    @ManagedAttributeField(afterSet="postSetStoreUrl")
    private volatile String _storeUrl;
    private volatile String _path;
    @ManagedAttributeField
    private volatile boolean _peersOnly;
    @ManagedAttributeField
    private volatile String _password;
    private volatile TrustManager[] _trustManagers;
    private volatile Certificate[] _certificates;

    @ManagedObjectFactoryConstructor
    public FileTrustStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        FileTrustStoreImpl.validateTrustStore(this);
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED}, desiredState=State.DELETED)
    protected ListenableFuture<Void> doDelete() {
        return this.deleteIfNotInUse();
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> doActivate() {
        this.initializeExpiryChecking();
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        FileTrustStore updated = (FileTrustStore)proxyForValidation;
        if (changedAttributes.contains("desiredState") && updated.getDesiredState() == State.DELETED) {
            return;
        }
        FileTrustStoreImpl.validateTrustStore(updated);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this.initialize();
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        super.changeAttributes(attributes);
        if (attributes.containsKey("storeUrl") || attributes.containsKey("password") || attributes.containsKey("trustStoreType") || attributes.containsKey("trustManagerFactoryAlgorithm") || attributes.containsKey("peersOnly")) {
            this.initialize();
        }
    }

    private static KeyStore initializeKeyStore(FileTrustStore trustStore) throws GeneralSecurityException, IOException {
        URL trustStoreUrl = FileTrustStoreImpl.getUrlFromString(trustStore.getStoreUrl());
        return SSLUtil.getInitializedKeyStore(trustStoreUrl, trustStore.getPassword(), trustStore.getTrustStoreType());
    }

    private static void validateTrustStore(FileTrustStore trustStore) {
        try {
            FileTrustStoreImpl.initializeKeyStore(trustStore);
        }
        catch (Exception e) {
            String message = e instanceof IOException && e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException ? "Check trust store password. Cannot instantiate trust store from '" + trustStore.getStoreUrl() + "'." : "Cannot instantiate trust store from '" + trustStore.getStoreUrl() + "'.";
            throw new IllegalConfigurationException(message, e);
        }
        try {
            TrustManagerFactory.getInstance(trustStore.getTrustManagerFactoryAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalConfigurationException("Unknown trustManagerFactoryAlgorithm: " + trustStore.getTrustManagerFactoryAlgorithm());
        }
    }

    @Override
    public String getStoreUrl() {
        return this._storeUrl;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public String getTrustManagerFactoryAlgorithm() {
        return this._trustManagerFactoryAlgorithm;
    }

    @Override
    public String getTrustStoreType() {
        return this._trustStoreType;
    }

    @Override
    public boolean isPeersOnly() {
        return this._peersOnly;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    protected TrustManager[] getTrustManagersInternal() throws GeneralSecurityException {
        TrustManager[] trustManagers = this._trustManagers;
        if (trustManagers == null || trustManagers.length == 0) {
            throw new IllegalStateException("Truststore " + this + " defines no trust managers");
        }
        return Arrays.copyOf(trustManagers, trustManagers.length);
    }

    @Override
    public Certificate[] getCertificates() throws GeneralSecurityException {
        Certificate[] certificates = this._certificates;
        return certificates == null ? new Certificate[]{} : Arrays.copyOf(certificates, certificates.length);
    }

    private static URL getUrlFromString(String urlString) throws MalformedURLException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            File file = new File(urlString);
            url = file.toURI().toURL();
        }
        return url;
    }

    private void postSetStoreUrl() {
        this._path = this._storeUrl != null && !this._storeUrl.startsWith("data:") ? this._storeUrl : null;
    }

    private void initialize() {
        try {
            KeyStore ts = FileTrustStoreImpl.initializeKeyStore(this);
            this._trustManagers = this.createTrustManagers(ts);
            this._certificates = this.createCertificates(ts);
        }
        catch (Exception e) {
            throw new IllegalConfigurationException(String.format("Cannot instantiate trust store '%s'", this.getName()), e);
        }
    }

    private TrustManager[] createTrustManagers(KeyStore ts) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this._trustManagerFactoryAlgorithm);
        tmf.init(ts);
        TrustManager[] delegateManagers = tmf.getTrustManagers();
        if (delegateManagers.length == 0) {
            throw new IllegalStateException("Truststore " + this + " defines no trust managers");
        }
        if (delegateManagers.length == 1) {
            if (this._peersOnly && delegateManagers[0] instanceof X509TrustManager) {
                return new TrustManager[]{new QpidPeersOnlyTrustManager(ts, (X509TrustManager)delegateManagers[0])};
            }
            return delegateManagers;
        }
        ArrayList<TrustManager> trustManagersCol = new ArrayList<TrustManager>();
        QpidMultipleTrustManager mulTrustManager = new QpidMultipleTrustManager();
        for (TrustManager tm : delegateManagers) {
            if (tm instanceof X509TrustManager) {
                if (this._peersOnly) {
                    mulTrustManager.addTrustManager(new QpidPeersOnlyTrustManager(ts, (X509TrustManager)tm));
                    continue;
                }
                mulTrustManager.addTrustManager((X509TrustManager)tm);
                continue;
            }
            trustManagersCol.add(tm);
        }
        if (!mulTrustManager.isEmpty()) {
            trustManagersCol.add(mulTrustManager);
        }
        return trustManagersCol.toArray(new TrustManager[trustManagersCol.size()]);
    }

    private Certificate[] createCertificates(KeyStore ts) throws KeyStoreException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        Enumeration<String> aliases = ts.aliases();
        while (aliases.hasMoreElements()) {
            certificates.add(ts.getCertificate(aliases.nextElement()));
        }
        return certificates.toArray(new Certificate[certificates.size()]);
    }

    static {
        Handler.register();
    }
}

