/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AbstractKeyStore;
import org.apache.qpid.server.security.NonJavaKeyStore;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false)
public class NonJavaKeyStoreImpl
extends AbstractKeyStore<NonJavaKeyStoreImpl>
implements NonJavaKeyStore<NonJavaKeyStoreImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonJavaKeyStoreImpl.class);
    @ManagedAttributeField(afterSet="updateKeyManagers")
    private volatile String _privateKeyUrl;
    @ManagedAttributeField(afterSet="updateKeyManagers")
    private volatile String _certificateUrl;
    @ManagedAttributeField(afterSet="updateKeyManagers")
    private volatile String _intermediateCertificateUrl;
    private volatile KeyManager[] _keyManagers = new KeyManager[0];
    private static final SecureRandom RANDOM = new SecureRandom();
    private volatile X509Certificate _certificate;

    @ManagedObjectFactoryConstructor
    public NonJavaKeyStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public String getPrivateKeyUrl() {
        return this._privateKeyUrl;
    }

    @Override
    public String getCertificateUrl() {
        return this._certificateUrl;
    }

    @Override
    public String getIntermediateCertificateUrl() {
        return this._intermediateCertificateUrl;
    }

    @Override
    public String getSubjectName() {
        if (this._certificate != null) {
            try {
                String dn = this._certificate.getSubjectX500Principal().getName();
                LdapName ldapDN = new LdapName(dn);
                String name = dn;
                for (Rdn rdn : ldapDN.getRdns()) {
                    if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                    name = String.valueOf(rdn.getValue());
                    break;
                }
                return name;
            }
            catch (InvalidNameException e) {
                LOGGER.error("Error getting subject name from certificate");
                return null;
            }
        }
        return null;
    }

    @Override
    public Date getCertificateValidEnd() {
        return this._certificate == null ? null : this._certificate.getNotAfter();
    }

    @Override
    public Date getCertificateValidStart() {
        return this._certificate == null ? null : this._certificate.getNotBefore();
    }

    @Override
    public KeyManager[] getKeyManagers() throws GeneralSecurityException {
        KeyManager[] keyManagers = this._keyManagers;
        return keyManagers == null ? new KeyManager[]{} : Arrays.copyOf(keyManagers, keyManagers.length);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this.validateKeyStoreAttributes(this);
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED}, desiredState=State.DELETED)
    protected ListenableFuture<Void> doDelete() {
        return this.deleteIfNotInUse();
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> doActivate() {
        this.initializeExpiryChecking();
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        NonJavaKeyStore changedStore = (NonJavaKeyStore)proxyForValidation;
        if (changedAttributes.contains("name") && !this.getName().equals(changedStore.getName())) {
            throw new IllegalConfigurationException("Changing the key store name is not allowed");
        }
        this.validateKeyStoreAttributes(changedStore);
    }

    private void validateKeyStoreAttributes(NonJavaKeyStore<?> keyStore) {
        try {
            SSLUtil.readPrivateKey(this.getUrlFromString(keyStore.getPrivateKeyUrl()));
            SSLUtil.readCertificates(this.getUrlFromString(keyStore.getCertificateUrl()));
            if (keyStore.getIntermediateCertificateUrl() != null) {
                SSLUtil.readCertificates(this.getUrlFromString(keyStore.getIntermediateCertificateUrl()));
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalConfigurationException("Cannot validate private key or certificate(s):" + e, e);
        }
    }

    private void updateKeyManagers() {
        try {
            if (this._privateKeyUrl != null && this._certificateUrl != null) {
                PrivateKey privateKey = SSLUtil.readPrivateKey(this.getUrlFromString(this._privateKeyUrl));
                Certificate[] certs = SSLUtil.readCertificates(this.getUrlFromString(this._certificateUrl));
                if (this._intermediateCertificateUrl != null) {
                    ArrayList<X509Certificate> allCerts = new ArrayList<X509Certificate>(Arrays.asList(certs));
                    allCerts.addAll(Arrays.asList(SSLUtil.readCertificates(this.getUrlFromString(this._intermediateCertificateUrl))));
                    certs = allCerts.toArray(new X509Certificate[allCerts.size()]);
                }
                this.checkCertificateExpiry((X509Certificate[])certs);
                KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                byte[] bytes = new byte[64];
                char[] chars = new char[64];
                RANDOM.nextBytes(bytes);
                StandardCharsets.US_ASCII.decode(ByteBuffer.wrap(bytes)).get(chars);
                inMemoryKeyStore.load(null, chars);
                inMemoryKeyStore.setKeyEntry("1", privateKey, chars, certs);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(inMemoryKeyStore, chars);
                this._keyManagers = kmf.getKeyManagers();
                this._certificate = certs[0];
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalConfigurationException("Cannot load private key or certificate(s): " + e, e);
        }
    }

    @Override
    protected void checkCertificateExpiry() {
        try {
            if (this._privateKeyUrl != null && this._certificateUrl != null) {
                X509Certificate[] certs = SSLUtil.readCertificates(this.getUrlFromString(this._certificateUrl));
                if (this._intermediateCertificateUrl != null) {
                    ArrayList<X509Certificate> allCerts = new ArrayList<X509Certificate>(Arrays.asList(certs));
                    allCerts.addAll(Arrays.asList(SSLUtil.readCertificates(this.getUrlFromString(this._intermediateCertificateUrl))));
                    certs = allCerts.toArray(new X509Certificate[allCerts.size()]);
                }
                this.checkCertificateExpiry(certs);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            LOGGER.info("Unexpected exception while trying to check certificate validity", (Throwable)e);
        }
    }

    private void checkCertificateExpiry(X509Certificate ... certificates) {
        int expiryWarning = this.getCertificateExpiryWarnPeriod();
        if (expiryWarning > 0) {
            long currentTime = System.currentTimeMillis();
            Date expiryTestDate = new Date(currentTime + 86400000L * (long)expiryWarning);
            this.checkCertificatesExpiry(currentTime, expiryTestDate, certificates);
        }
    }

    private URL getUrlFromString(String urlString) throws MalformedURLException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            File file = new File(urlString);
            url = file.toURI().toURL();
        }
        return url;
    }

    static {
        Handler.register();
    }
}

