/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.messages.AccessControlMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.CommonAccessControlProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;

public abstract class AbstractAccessControlProvider<X extends AbstractAccessControlProvider<X, Y, T>, Y extends CommonAccessControlProvider<Y>, T extends EventLoggerProvider & ConfiguredObject<?>>
extends AbstractConfiguredObject<X>
implements EventLoggerProvider,
CommonAccessControlProvider<Y> {
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private int _priority;

    public AbstractAccessControlProvider(Map<String, Object> attributes, T parent) {
        super((ConfiguredObject)parent, attributes);
        this._eventLogger = parent.getEventLogger();
        this._eventLogger.message(AccessControlMessages.CREATE(this.getName()));
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLogger;
    }

    @Override
    public final int getPriority() {
        return this._priority;
    }

    @Override
    public int compareTo(Y o) {
        return ACCESS_CONTROL_PROVIDER_COMPARATOR.compare(this, o);
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    private ListenableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.ACTIVE, State.QUIESCED, State.ERRORED}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        return this.doAfterAlways(this.closeAsync(), new Runnable(){

            @Override
            public void run() {
                AbstractAccessControlProvider.this.setState(State.DELETED);
                AbstractAccessControlProvider.this.deleted();
                AbstractAccessControlProvider.this.getEventLogger().message(AccessControlMessages.DELETE(AbstractAccessControlProvider.this.getName()));
            }
        });
    }

    @Override
    protected void logOperation(String operation) {
        this.getAncestor(Container.class).getEventLogger().message(AccessControlMessages.OPERATION(operation));
    }
}

