/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.database.PasswordPrincipal;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.sasl.PasswordSource;
import org.apache.qpid.server.util.BaseAction;
import org.apache.qpid.server.util.FileHelper;
import org.slf4j.Logger;

public abstract class AbstractPasswordFilePrincipalDatabase<U extends PasswordPrincipal>
implements PrincipalDatabase {
    protected static final String DEFAULT_ENCODING = "utf-8";
    private final Pattern _regexp = Pattern.compile(":");
    private final Map<String, U> _userMap = new HashMap<String, U>();
    private final ReentrantLock _userUpdate = new ReentrantLock();
    private final FileHelper _fileHelper = new FileHelper();
    private final PasswordCredentialManagingAuthenticationProvider<?> _authenticationProvider;
    private File _passwordFile;

    public AbstractPasswordFilePrincipalDatabase(PasswordCredentialManagingAuthenticationProvider<?> authenticationProvider) {
        this._authenticationProvider = authenticationProvider;
    }

    @Override
    public final PasswordCredentialManagingAuthenticationProvider<?> getAuthenticationProvider() {
        return this._authenticationProvider;
    }

    @Override
    public final void open(File passwordFile) throws IOException {
        this.getLogger().debug("PasswordFile using file : {}", (Object)passwordFile.getAbsolutePath());
        this._passwordFile = passwordFile;
        if (!passwordFile.exists()) {
            throw new FileNotFoundException("Cannot find password file " + passwordFile);
        }
        if (!passwordFile.canRead()) {
            throw new FileNotFoundException("Cannot read password file " + passwordFile + ". Check permissions.");
        }
        this.loadPasswordFile();
    }

    @Override
    public final void setPassword(Principal principal, PasswordCallback callback) throws AccountNotFoundException {
        if (this._passwordFile == null) {
            throw new AccountNotFoundException("Unable to locate principal since no password file was specified during initialisation");
        }
        if (principal == null) {
            throw new IllegalArgumentException("principal must not be null");
        }
        char[] pwd = this.lookupPassword(principal.getName());
        if (pwd == null) {
            throw new AccountNotFoundException("No account found for principal " + principal);
        }
        callback.setPassword(pwd);
    }

    protected final char[] lookupPassword(String name) {
        PasswordPrincipal user = (PasswordPrincipal)this._userMap.get(name);
        if (user == null) {
            return null;
        }
        return user.getPassword();
    }

    protected boolean compareCharArray(char[] a, char[] b) {
        boolean equal = false;
        if (a.length == b.length) {
            equal = true;
            for (int index = 0; equal && index < a.length; ++index) {
                equal = a[index] == b[index];
            }
        }
        return equal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePassword(Principal principal, char[] password) throws AccountNotFoundException {
        PasswordPrincipal user = (PasswordPrincipal)this._userMap.get(principal.getName());
        if (user == null) {
            throw new AccountNotFoundException(principal.getName());
        }
        for (char c : password) {
            if (c != ':') continue;
            throw new IllegalArgumentException("Illegal character in password");
        }
        char[] orig = user.getPassword();
        this._userUpdate.lock();
        try {
            user.setPassword(password);
            this.savePasswordFile();
            int n = 1;
            return n != 0;
        }
        catch (IOException e) {
            this.getLogger().error("Unable to save password file due to '{}', password change for user '{}' discarded", (Object)e.getMessage(), (Object)principal);
            user.restorePassword(orig);
            int n = 0;
            return n != 0;
        }
        finally {
            this._userUpdate.unlock();
        }
    }

    protected PasswordSource getPasswordSource() {
        return new PasswordSource(){

            @Override
            public char[] getPassword(String username) {
                return AbstractPasswordFilePrincipalDatabase.this.lookupPassword(username);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPasswordFile() throws IOException {
        try {
            this._userUpdate.lock();
            HashMap<String, U> newUserMap = new HashMap<String, U>();
            try (BufferedReader reader = new BufferedReader(new FileReader(this._passwordFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] result = this._regexp.split(line);
                    if (result == null || result.length < 2 || result[0].startsWith("#")) continue;
                    U user = this.createUserFromFileData(result);
                    newUserMap.put(user.getName(), user);
                }
            }
            this.getLogger().debug("Loaded {} user(s) from {}", (Object)newUserMap.size(), (Object)this._passwordFile);
            this._userMap.clear();
            this._userMap.putAll(newUserMap);
        }
        finally {
            this._userUpdate.unlock();
        }
    }

    protected abstract U createUserFromFileData(String[] var1);

    protected abstract Logger getLogger();

    protected void savePasswordFile() throws IOException {
        try {
            this._userUpdate.lock();
            this._fileHelper.writeFileSafely(this._passwordFile.toPath(), new BaseAction<File, IOException>(){

                @Override
                public void performAction(File file) throws IOException {
                    AbstractPasswordFilePrincipalDatabase.this.writeToFile(file);
                }
            });
        }
        finally {
            this._userUpdate.unlock();
        }
    }

    private void writeToFile(File tmp) throws IOException {
        try (PrintStream writer = new PrintStream(tmp);
             BufferedReader reader = new BufferedReader(new FileReader(this._passwordFile));){
            byte[] encodedPassword;
            String line;
            while ((line = reader.readLine()) != null) {
                String[] result = this._regexp.split(line);
                if (result == null || result.length < 2 || result[0].startsWith("#")) {
                    writer.write(line.getBytes(DEFAULT_ENCODING));
                    writer.println();
                    continue;
                }
                PasswordPrincipal user = (PasswordPrincipal)this._userMap.get(result[0]);
                if (user == null) {
                    writer.write(line.getBytes(DEFAULT_ENCODING));
                    writer.println();
                    continue;
                }
                if (user.isDeleted()) continue;
                if (!user.isModified()) {
                    writer.write(line.getBytes(DEFAULT_ENCODING));
                    writer.println();
                    continue;
                }
                encodedPassword = user.getEncodedPassword();
                writer.write((user.getName() + ":").getBytes(DEFAULT_ENCODING));
                writer.write(encodedPassword);
                writer.println();
                user.saved();
            }
            for (PasswordPrincipal user : this._userMap.values()) {
                if (!user.isModified()) continue;
                encodedPassword = user.getEncodedPassword();
                writer.write((user.getName() + ":").getBytes(DEFAULT_ENCODING));
                writer.write(encodedPassword);
                writer.println();
                user.saved();
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to create the new password file", (Throwable)e);
            throw new IOException("Unable to create the new password file", e);
        }
    }

    protected abstract U createUserFromPassword(Principal var1, char[] var2);

    @Override
    public void reload() throws IOException {
        this.loadPasswordFile();
    }

    @Override
    public List<Principal> getUsers() {
        return new LinkedList<Principal>(this._userMap.values());
    }

    @Override
    public Principal getUser(String username) {
        if (this._userMap.containsKey(username)) {
            return new UsernamePrincipal(username, this.getAuthenticationProvider());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePrincipal(Principal principal) throws AccountNotFoundException {
        PasswordPrincipal user = (PasswordPrincipal)this._userMap.get(principal.getName());
        if (user == null) {
            throw new AccountNotFoundException(principal.getName());
        }
        try {
            this._userUpdate.lock();
            user.delete();
            try {
                this.savePasswordFile();
            }
            catch (IOException e) {
                this.getLogger().error("Unable to remove user '{}' from password file.", (Object)user.getName());
                boolean bl = false;
                this._userUpdate.unlock();
                return bl;
            }
            this._userMap.remove(user.getName());
        }
        finally {
            this._userUpdate.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createPrincipal(Principal principal, char[] password) {
        if (this._userMap.get(principal.getName()) != null) {
            return false;
        }
        if (principal.getName().contains(":")) {
            throw new IllegalArgumentException("Username must not contain colons (\":\").");
        }
        for (char c : password) {
            if (c != ':') continue;
            throw new IllegalArgumentException("Illegal character in password");
        }
        U user = this.createUserFromPassword(principal, password);
        try {
            this._userUpdate.lock();
            this._userMap.put(user.getName(), user);
            try {
                this.savePasswordFile();
                int n = 1;
                return n != 0;
            }
            catch (IOException e) {
                this._userMap.remove(user.getName());
                int n = 0;
                this._userUpdate.unlock();
                return n != 0;
            }
        }
        finally {
            this._userUpdate.unlock();
        }
    }
}

