/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.AuthenticationProviderMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.SystemConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationManager<T extends AbstractAuthenticationManager<T>>
extends AbstractConfiguredObject<T>
implements AuthenticationProvider<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAuthenticationManager.class);
    private final Container<?> _container;
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private List<String> _secureOnlyMechanisms;
    @ManagedAttributeField
    private List<String> _disabledMechanisms;

    protected AbstractAuthenticationManager(Map<String, Object> attributes, Container<?> container) {
        super(container, attributes);
        this._container = container;
        this._eventLogger = this._container.getEventLogger();
        this._eventLogger.message(AuthenticationProviderMessages.CREATE(this.getName()));
    }

    @Override
    public void onValidate() {
        super.onValidate();
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    @Override
    public List<String> getAvailableMechanisms(boolean secure) {
        HashSet<String> filter;
        List<String> mechanisms = this.getMechanisms();
        HashSet<String> hashSet = filter = this.getDisabledMechanisms() != null ? new HashSet<String>(this.getDisabledMechanisms()) : new HashSet();
        if (!secure) {
            filter.addAll(this.getSecureOnlyMechanisms());
        }
        if (!filter.isEmpty()) {
            mechanisms = new ArrayList<String>(mechanisms);
            mechanisms.removeAll(filter);
        }
        return mechanisms;
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    protected ListenableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.QUIESCED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> activate() {
        try {
            this.setState(State.ACTIVE);
        }
        catch (RuntimeException e) {
            this.setState(State.ERRORED);
            if (this.getAncestor(SystemConfig.class).isManagementMode()) {
                LOGGER.warn("Failed to activate authentication provider: " + this.getName(), (Throwable)e);
            }
            throw e;
        }
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.ACTIVE, State.QUIESCED, State.ERRORED}, desiredState=State.DELETED)
    protected ListenableFuture<Void> doDelete() {
        String providerName = this.getName();
        ArrayList<Port> ports = new ArrayList<Port>(this._container.getChildren(Port.class));
        for (Port port : ports) {
            if (port.getAuthenticationProvider() != this) continue;
            throw new IntegrityViolationException("Authentication provider '" + providerName + "' is set on port " + port.getName());
        }
        return this.performDelete();
    }

    private ListenableFuture<Void> performDelete() {
        final SettableFuture futureResult = SettableFuture.create();
        AbstractAuthenticationManager.addFutureCallback(this.closeAsync(), new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                try {
                    this.tidyUp();
                    futureResult.set(null);
                }
                catch (Exception e) {
                    futureResult.setException((Throwable)e);
                }
            }

            public void onFailure(Throwable t) {
                try {
                    this.tidyUp();
                }
                finally {
                    futureResult.setException(t);
                }
            }

            private void tidyUp() {
                AbstractAuthenticationManager.this.deleted();
                AbstractAuthenticationManager.this.setState(State.DELETED);
                AbstractAuthenticationManager.this._eventLogger.message(AuthenticationProviderMessages.DELETE(AbstractAuthenticationManager.this.getName()));
            }
        }, this.getTaskExecutor());
        return futureResult;
    }

    @Override
    public final List<String> getSecureOnlyMechanisms() {
        return this._secureOnlyMechanisms;
    }

    @Override
    public final List<String> getDisabledMechanisms() {
        return this._disabledMechanisms;
    }

    @Override
    protected void logOperation(String operation) {
        this._container.getEventLogger().message(AuthenticationProviderMessages.OPERATION(operation));
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLogger;
    }
}

