/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.kerberos.KerberosNegotiator;

@ManagedObject(category=false, type="Kerberos")
public class KerberosAuthenticationManager
extends AbstractAuthenticationManager<KerberosAuthenticationManager> {
    public static final String PROVIDER_TYPE = "Kerberos";
    public static final String GSSAPI_MECHANISM = "GSSAPI";

    @ManagedObjectFactoryConstructor
    protected KerberosAuthenticationManager(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.singletonList(GSSAPI_MECHANISM);
    }

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings, NamedAddressSpace addressSpace) {
        if (GSSAPI_MECHANISM.equals(mechanism)) {
            return new KerberosNegotiator(this, saslSettings.getLocalFQDN());
        }
        return null;
    }
}

