/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.ConfigModelPasswordManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.ManagedUser;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.crammd5.CramMd5Base64HashedNegotiator;
import org.apache.qpid.server.security.auth.sasl.crammd5.CramMd5Base64HexNegotiator;
import org.apache.qpid.server.security.auth.sasl.plain.PlainNegotiator;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

@ManagedObject(category=false, type="MD5", validChildTypes="org.apache.qpid.server.security.auth.manager.ConfigModelPasswordManagingAuthenticationProvider#getSupportedUserTypes()")
public class MD5AuthenticationProvider
extends ConfigModelPasswordManagingAuthenticationProvider<MD5AuthenticationProvider> {
    private final List<String> _mechanisms = Collections.unmodifiableList(Arrays.asList("PLAIN", "CRAM-MD5-HASHED", "CRAM-MD5-HEX"));

    @ManagedObjectFactoryConstructor
    protected MD5AuthenticationProvider(Map<String, Object> attributes, Broker broker) {
        super(attributes, broker);
    }

    @Override
    protected String createStoredPassword(String password) {
        byte[] data = password.getBytes(StandardCharsets.UTF_8);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServerScopedRuntimeException("MD5 not supported although Java compliance requires it");
        }
        md.update(data);
        return DatatypeConverter.printBase64Binary((byte[])md.digest());
    }

    @Override
    void validateUser(ManagedUser managedUser) {
    }

    @Override
    public List<String> getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings, NamedAddressSpace addressSpace) {
        if ("PLAIN".equals(mechanism)) {
            return new PlainNegotiator(this);
        }
        if ("CRAM-MD5-HASHED".equals(mechanism)) {
            return new CramMd5Base64HashedNegotiator(this, saslSettings.getLocalFQDN(), this.getPasswordSource());
        }
        if ("CRAM-MD5-HEX".equals(mechanism)) {
            return new CramMd5Base64HexNegotiator(this, saslSettings.getLocalFQDN(), this.getPasswordSource());
        }
        return null;
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        ManagedUser user = this.getUser(username);
        AuthenticationResult result = user != null && user.getPassword().equals(this.createStoredPassword(password)) ? new AuthenticationResult(new UsernamePrincipal(username, this)) : new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        return result;
    }
}

