/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager.oauth2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationResultCacher;
import org.apache.qpid.server.security.auth.manager.oauth2.IdentityResolverException;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2AuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2IdentityResolverService;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2UserPrincipal;
import org.apache.qpid.server.security.auth.manager.oauth2.OAuth2Utils;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.security.auth.sasl.oauth2.OAuth2Negotiator;
import org.apache.qpid.server.util.ConnectionBuilder;
import org.apache.qpid.server.util.ParameterizedTypes;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2AuthenticationProviderImpl
extends AbstractAuthenticationManager<OAuth2AuthenticationProviderImpl>
implements OAuth2AuthenticationProvider<OAuth2AuthenticationProviderImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2AuthenticationProviderImpl.class);
    private final ObjectMapper _objectMapper = new ObjectMapper();
    @ManagedAttributeField
    private URI _authorizationEndpointURI;
    @ManagedAttributeField
    private URI _tokenEndpointURI;
    @ManagedAttributeField
    private URI _identityResolverEndpointURI;
    @ManagedAttributeField
    private boolean _tokenEndpointNeedsAuth;
    @ManagedAttributeField
    private URI _postLogoutURI;
    @ManagedAttributeField
    private String _clientId;
    @ManagedAttributeField
    private String _clientSecret;
    @ManagedAttributeField
    private TrustStore _trustStore;
    @ManagedAttributeField
    private String _scope;
    @ManagedAttributeField
    private String _identityResolverType;
    private OAuth2IdentityResolverService _identityResolverService;
    private List<String> _tlsProtocolWhiteList;
    private List<String> _tlsProtocolBlackList;
    private List<String> _tlsCipherSuiteWhiteList;
    private List<String> _tlsCipherSuiteBlackList;
    private int _connectTimeout;
    private int _readTimeout;
    private AuthenticationResultCacher _authenticationResultCacher;

    @ManagedObjectFactoryConstructor
    protected OAuth2AuthenticationProviderImpl(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        String type = this.getIdentityResolverType();
        this._identityResolverService = new QpidServiceLoader().getInstancesByType(OAuth2IdentityResolverService.class).get(type);
        this._tlsProtocolWhiteList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.protocolWhiteList");
        this._tlsProtocolBlackList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.protocolBlackList");
        this._tlsCipherSuiteWhiteList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.cipherSuiteWhiteList");
        this._tlsCipherSuiteBlackList = this.getContextValue(List.class, ParameterizedTypes.LIST_OF_STRINGS, "qpid.security.tls.cipherSuiteBlackList");
        this._connectTimeout = this.getContextValue(Integer.class, "qpid.authentication.oauth2.connectTimeout");
        this._readTimeout = this.getContextValue(Integer.class, "qpid.authentication.oauth2.readTimeout");
        Integer cacheMaxSize = this.getContextValue(Integer.class, "qpid.auth.cache.size");
        Long cacheExpirationTime = this.getContextValue(Long.class, "qpid.auth.cache.expiration_time");
        Integer cacheIterationCount = this.getContextValue(Integer.class, "qpid.auth.cache.iteration_count");
        if (cacheMaxSize == null || cacheMaxSize <= 0 || cacheExpirationTime == null || cacheExpirationTime <= 0L || cacheIterationCount == null || cacheIterationCount < 0) {
            LOGGER.debug("disabling authentication result caching");
            cacheMaxSize = 0;
            cacheExpirationTime = 1L;
            cacheIterationCount = 0;
        }
        this._authenticationResultCacher = new AuthenticationResultCacher(cacheMaxSize, cacheExpirationTime, cacheIterationCount);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        OAuth2AuthenticationProvider validationProxy = (OAuth2AuthenticationProvider)proxyForValidation;
        this.validateResolver(validationProxy);
        this.validateSecureEndpoints(validationProxy);
        this.validatePostLogoutURI(validationProxy);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this.validateResolver(this);
        this.validateSecureEndpoints(this);
        this.validatePostLogoutURI(this);
    }

    private void validateSecureEndpoints(OAuth2AuthenticationProvider<?> provider) {
        if (!"https".equals(provider.getAuthorizationEndpointURI().getScheme())) {
            throw new IllegalConfigurationException(String.format("Authorization endpoint is not secure: '%s'", provider.getAuthorizationEndpointURI()));
        }
        if (!"https".equals(provider.getTokenEndpointURI().getScheme())) {
            throw new IllegalConfigurationException(String.format("Token endpoint is not secure: '%s'", provider.getTokenEndpointURI()));
        }
        if (!"https".equals(provider.getIdentityResolverEndpointURI().getScheme())) {
            throw new IllegalConfigurationException(String.format("Identity resolver endpoint is not secure: '%s'", provider.getIdentityResolverEndpointURI()));
        }
    }

    private void validatePostLogoutURI(OAuth2AuthenticationProvider<?> provider) {
        String scheme;
        if (provider.getPostLogoutURI() != null && !"https".equals(scheme = provider.getPostLogoutURI().getScheme()) && !"http".equals(scheme)) {
            throw new IllegalConfigurationException(String.format("Post logout URI does not have a http or https scheme: '%s'", provider.getPostLogoutURI()));
        }
    }

    private void validateResolver(OAuth2AuthenticationProvider<?> provider) {
        OAuth2IdentityResolverService identityResolverService = new QpidServiceLoader().getInstancesByType(OAuth2IdentityResolverService.class).get(provider.getIdentityResolverType());
        if (identityResolverService == null) {
            throw new IllegalConfigurationException("Unknown identity resolver " + provider.getType());
        }
        identityResolverService.validate(provider);
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.singletonList("XOAUTH2");
    }

    @Override
    public SaslNegotiator createSaslNegotiator(String mechanism, SaslSettings saslSettings, NamedAddressSpace addressSpace) {
        if ("XOAUTH2".equals(mechanism)) {
            return new OAuth2Negotiator(this, addressSpace);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AuthenticationResult authenticateViaAuthorizationCode(String authorizationCode, String redirectUri, NamedAddressSpace addressSpace) {
        try {
            URL tokenEndpoint = this.getTokenEndpointURI(addressSpace).toURL();
            ConnectionBuilder connectionBuilder = new ConnectionBuilder(tokenEndpoint);
            connectionBuilder.setConnectTimeout(this._connectTimeout).setReadTimeout(this._readTimeout);
            if (this.getTrustStore() != null) {
                try {
                    connectionBuilder.setTrustMangers(this.getTrustStore().getTrustManagers());
                }
                catch (GeneralSecurityException e) {
                    throw new ServerScopedRuntimeException("Cannot initialise TLS", e);
                }
            }
            connectionBuilder.setTlsProtocolWhiteList(this.getTlsProtocolWhiteList()).setTlsProtocolBlackList(this.getTlsProtocolBlackList()).setTlsCipherSuiteWhiteList(this.getTlsCipherSuiteWhiteList()).setTlsCipherSuiteBlackList(this.getTlsCipherSuiteBlackList());
            LOGGER.debug("About to call token endpoint '{}'", (Object)tokenEndpoint);
            HttpURLConnection connection = connectionBuilder.build();
            connection.setDoOutput(true);
            connection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + StandardCharsets.UTF_8.name());
            connection.setRequestProperty("Accept", "application/json");
            if (this.getTokenEndpointNeedsAuth()) {
                String encoded = DatatypeConverter.printBase64Binary((byte[])(this.getClientId() + ":" + this.getClientSecret()).getBytes(StandardCharsets.UTF_8));
                connection.setRequestProperty("Authorization", "Basic " + encoded);
            }
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("code", authorizationCode);
            requestBody.put("client_id", this.getClientId());
            requestBody.put("client_secret", this.getClientSecret());
            requestBody.put("redirect_uri", redirectUri);
            requestBody.put("grant_type", "authorization_code");
            requestBody.put("response_type", "token");
            byte[] body = OAuth2Utils.buildRequestQuery(requestBody).getBytes(StandardCharsets.UTF_8);
            connection.connect();
            try (OutputStream output = connection.getOutputStream();){
                output.write(body);
            }
            try {
                var10_13 = null;
                try (InputStream input = OAuth2Utils.getResponseStream(connection);){
                    int responseCode = connection.getResponseCode();
                    LOGGER.debug("Call to token endpoint '{}' complete, response code : {}", (Object)tokenEndpoint, (Object)responseCode);
                    Map responseMap = (Map)this._objectMapper.readValue(input, Map.class);
                    if (responseCode != 200 || responseMap.containsKey("error")) {
                        IllegalStateException e = new IllegalStateException(String.format("Token endpoint failed, response code %d, error '%s', description '%s'", responseCode, responseMap.get("error"), responseMap.get("error_description")));
                        LOGGER.error(e.getMessage());
                        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
                        return authenticationResult;
                    }
                    Object accessTokenObject = responseMap.get("access_token");
                    if (accessTokenObject == null) {
                        IllegalStateException e = new IllegalStateException("Token endpoint response did not include 'access_token'");
                        LOGGER.error("Unexpected token endpoint response", (Throwable)e);
                        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
                        return authenticationResult;
                    }
                    String accessToken = String.valueOf(accessTokenObject);
                    AuthenticationResult authenticationResult = this.authenticateViaAccessToken(accessToken, addressSpace);
                    return authenticationResult;
                }
                catch (Throwable throwable) {
                    var10_13 = throwable;
                    throw throwable;
                }
            }
            catch (JsonProcessingException e) {
                IllegalStateException ise = new IllegalStateException(String.format("Token endpoint '%s' did not return json", tokenEndpoint), e);
                LOGGER.error("Unexpected token endpoint response", (Throwable)e);
                return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, ise);
            }
        }
        catch (IOException e) {
            LOGGER.error("Call to token endpoint failed", (Throwable)e);
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    @Override
    public AuthenticationResult authenticateViaAccessToken(String accessToken, NamedAddressSpace addressSpace) {
        return this._authenticationResultCacher.getOrLoad(new String[]{accessToken}, () -> {
            try {
                Principal userPrincipal = this._identityResolverService.getUserPrincipal(this, accessToken, addressSpace);
                OAuth2UserPrincipal oauthUserPrincipal = new OAuth2UserPrincipal(userPrincipal.getName(), accessToken, this);
                return new AuthenticationResult(oauthUserPrincipal);
            }
            catch (IOException | IdentityResolverException e) {
                LOGGER.error("Call to identity resolver failed", (Throwable)e);
                return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
            }
        });
    }

    @Override
    public URI getAuthorizationEndpointURI() {
        return this._authorizationEndpointURI;
    }

    @Override
    public URI getAuthorizationEndpointURI(NamedAddressSpace addressSpace) {
        return this.getUriForAddressSpace(this.getAuthorizationEndpointURI(), addressSpace);
    }

    @Override
    public URI getTokenEndpointURI() {
        return this._tokenEndpointURI;
    }

    @Override
    public URI getTokenEndpointURI(NamedAddressSpace addressSpace) {
        return this.getUriForAddressSpace(this.getTokenEndpointURI(), addressSpace);
    }

    @Override
    public URI getIdentityResolverEndpointURI() {
        return this._identityResolverEndpointURI;
    }

    @Override
    public URI getIdentityResolverEndpointURI(NamedAddressSpace addressSpace) {
        return this.getUriForAddressSpace(this.getIdentityResolverEndpointURI(), addressSpace);
    }

    private URI getUriForAddressSpace(URI uri, NamedAddressSpace addressSpace) {
        try {
            String vhostName = URLEncoder.encode(addressSpace == null ? "" : addressSpace.getName(), StandardCharsets.UTF_8.name());
            Strings.MapResolver virtualhostResolver = new Strings.MapResolver(Collections.singletonMap("virtualhost", vhostName));
            String substitutedURI = Strings.expand(uri.toString(), false, virtualhostResolver);
            uri = new URI(substitutedURI);
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            LOGGER.error("Error when attempting to build URI from address space: ", (Throwable)e);
        }
        return uri;
    }

    @Override
    public URI getPostLogoutURI() {
        return this._postLogoutURI;
    }

    @Override
    public boolean getTokenEndpointNeedsAuth() {
        return this._tokenEndpointNeedsAuth;
    }

    @Override
    public String getIdentityResolverType() {
        return this._identityResolverType;
    }

    @Override
    public String getClientId() {
        return this._clientId;
    }

    @Override
    public String getClientSecret() {
        return this._clientSecret;
    }

    @Override
    public TrustStore getTrustStore() {
        return this._trustStore;
    }

    @Override
    public String getScope() {
        return this._scope;
    }

    @Override
    public URI getDefaultAuthorizationEndpointURI() {
        OAuth2IdentityResolverService identityResolverService = new QpidServiceLoader().getInstancesByType(OAuth2IdentityResolverService.class).get(this.getIdentityResolverType());
        return identityResolverService == null ? null : identityResolverService.getDefaultAuthorizationEndpointURI(this);
    }

    @Override
    public URI getDefaultTokenEndpointURI() {
        OAuth2IdentityResolverService identityResolverService = new QpidServiceLoader().getInstancesByType(OAuth2IdentityResolverService.class).get(this.getIdentityResolverType());
        return identityResolverService == null ? null : identityResolverService.getDefaultTokenEndpointURI(this);
    }

    @Override
    public URI getDefaultIdentityResolverEndpointURI() {
        OAuth2IdentityResolverService identityResolverService = new QpidServiceLoader().getInstancesByType(OAuth2IdentityResolverService.class).get(this.getIdentityResolverType());
        return identityResolverService == null ? null : identityResolverService.getDefaultIdentityResolverEndpointURI(this);
    }

    @Override
    public String getDefaultScope() {
        OAuth2IdentityResolverService identityResolverService = new QpidServiceLoader().getInstancesByType(OAuth2IdentityResolverService.class).get(this.getIdentityResolverType());
        return identityResolverService == null ? null : identityResolverService.getDefaultScope(this);
    }

    @Override
    public List<String> getTlsProtocolWhiteList() {
        return this._tlsProtocolWhiteList;
    }

    @Override
    public List<String> getTlsProtocolBlackList() {
        return this._tlsProtocolBlackList;
    }

    @Override
    public List<String> getTlsCipherSuiteWhiteList() {
        return this._tlsCipherSuiteWhiteList;
    }

    @Override
    public List<String> getTlsCipherSuiteBlackList() {
        return this._tlsCipherSuiteBlackList;
    }

    @Override
    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this._readTimeout;
    }

    public static Collection<String> validIdentityResolvers() {
        return new QpidServiceLoader().getInstancesByType(OAuth2IdentityResolverService.class).keySet();
    }
}

