/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.ByteBufferSender;
import org.apache.qpid.server.transport.NetworkConnectionScheduler;
import org.apache.qpid.server.transport.NonBlockingConnectionDelegate;
import org.apache.qpid.server.transport.NonBlockingConnectionPlainDelegate;
import org.apache.qpid.server.transport.NonBlockingConnectionTLSDelegate;
import org.apache.qpid.server.transport.NonBlockingConnectionUndecidedDelegate;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.transport.SchedulingDelayNotificationListener;
import org.apache.qpid.server.transport.SelectorThread;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.transport.network.TransportEncryption;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingConnection
implements ServerNetworkConnection,
ByteBufferSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonBlockingConnection.class);
    private final SocketChannel _socketChannel;
    private volatile NonBlockingConnectionDelegate _delegate;
    private final Deque<NetworkConnectionScheduler> _schedulerDeque = new ConcurrentLinkedDeque<NetworkConnectionScheduler>();
    private final ConcurrentLinkedQueue<QpidByteBuffer> _buffers = new ConcurrentLinkedQueue();
    private final String _remoteSocketAddress;
    private final AtomicBoolean _closed = new AtomicBoolean(false);
    private final ProtocolEngine _protocolEngine;
    private final Runnable _onTransportEncryptionAction;
    private volatile boolean _fullyWritten = true;
    private volatile boolean _partialRead = false;
    private final AmqpPort _port;
    private final AtomicBoolean _scheduled = new AtomicBoolean();
    private volatile long _scheduledTime;
    private volatile boolean _unexpectedByteBufferSizeReported;
    private final String _threadName;
    private volatile SelectorThread.SelectionTask _selectionTask;
    private volatile Iterator<Runnable> _pendingIterator;
    private final AtomicLong _maxWriteIdleMillis = new AtomicLong();
    private final AtomicLong _maxReadIdleMillis = new AtomicLong();
    private final List<SchedulingDelayNotificationListener> _schedulingDelayNotificationListeners = new CopyOnWriteArrayList<SchedulingDelayNotificationListener>();
    private final AtomicBoolean _hasShutdown = new AtomicBoolean();
    private volatile long _bufferedSize;
    private String _selectedHost;

    public NonBlockingConnection(SocketChannel socketChannel, ProtocolEngine protocolEngine, Set<TransportEncryption> encryptionSet, Runnable onTransportEncryptionAction, NetworkConnectionScheduler scheduler, AmqpPort port) {
        this._socketChannel = socketChannel;
        this.pushScheduler(scheduler);
        this._protocolEngine = protocolEngine;
        this._onTransportEncryptionAction = onTransportEncryptionAction;
        this._remoteSocketAddress = this._socketChannel.socket().getRemoteSocketAddress().toString();
        this._port = port;
        this._threadName = "IO-" + this._remoteSocketAddress.toString();
        protocolEngine.setWorkListener(new Action<ProtocolEngine>(){

            @Override
            public void performAction(ProtocolEngine object) {
                if (!NonBlockingConnection.this._scheduled.get()) {
                    NonBlockingConnection.this.getScheduler().schedule(NonBlockingConnection.this);
                }
            }
        });
        if (encryptionSet.size() == 1) {
            this.setTransportEncryption(encryptionSet.iterator().next());
        } else {
            this._delegate = new NonBlockingConnectionUndecidedDelegate(this);
        }
    }

    String getThreadName() {
        return this._threadName;
    }

    public boolean isPartialRead() {
        return this._partialRead;
    }

    AggregateTicker getTicker() {
        return this._protocolEngine.getAggregateTicker();
    }

    SocketChannel getSocketChannel() {
        return this._socketChannel;
    }

    @Override
    public void start() {
    }

    @Override
    public ByteBufferSender getSender() {
        return this;
    }

    @Override
    public void close() {
        LOGGER.debug("Closing " + this._remoteSocketAddress);
        if (this._closed.compareAndSet(false, true)) {
            this._protocolEngine.notifyWork();
            this._selectionTask.wakeup();
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._socketChannel.socket().getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this._socketChannel.socket().getLocalSocketAddress();
    }

    @Override
    public void setMaxWriteIdleMillis(long millis) {
        this._maxWriteIdleMillis.set(millis);
    }

    @Override
    public void setMaxReadIdleMillis(long millis) {
        this._maxReadIdleMillis.set(millis);
    }

    @Override
    public Principal getPeerPrincipal() {
        return this._delegate.getPeerPrincipal();
    }

    @Override
    public Certificate getPeerCertificate() {
        return this._delegate.getPeerCertificate();
    }

    @Override
    public long getMaxReadIdleMillis() {
        return this._maxReadIdleMillis.get();
    }

    @Override
    public long getMaxWriteIdleMillis() {
        return this._maxWriteIdleMillis.get();
    }

    @Override
    public String getTransportInfo() {
        return this._delegate.getTransportInfo();
    }

    boolean wantsRead() {
        return this._fullyWritten;
    }

    boolean wantsWrite() {
        return !this._fullyWritten;
    }

    public boolean isStateChanged() {
        return this._protocolEngine.hasWork();
    }

    public void doPreWork() {
        if (!this._closed.get()) {
            long currentTime = System.currentTimeMillis();
            long schedulingDelay = currentTime - this.getScheduledTime();
            if (!this._schedulingDelayNotificationListeners.isEmpty()) {
                for (SchedulingDelayNotificationListener listener : this._schedulingDelayNotificationListeners) {
                    listener.notifySchedulingDelay(schedulingDelay);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWork() {
        boolean closed;
        this._protocolEngine.clearWork();
        if (!this._closed.get()) {
            try {
                long currentTime = System.currentTimeMillis();
                int tick = this.getTicker().getTimeToNextTick(currentTime);
                if (tick <= 0) {
                    this.getTicker().tick(currentTime);
                }
                this._protocolEngine.setIOThread(Thread.currentThread());
                boolean processPendingComplete = this.processPending();
                if (processPendingComplete) {
                    this._pendingIterator = null;
                    this._protocolEngine.setTransportBlockedForWriting(false);
                    boolean dataRead = this.doRead();
                    this._protocolEngine.setTransportBlockedForWriting(!this.doWrite());
                    if (!this._fullyWritten || dataRead || this._delegate.needsWork() && this._delegate.getNetInputBuffer().position() != 0) {
                        this._protocolEngine.notifyWork();
                    }
                } else {
                    this._protocolEngine.notifyWork();
                }
            }
            catch (IOException | ConnectionScopedRuntimeException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception performing I/O for connection '{}'", (Object)this._remoteSocketAddress, (Object)e);
                } else {
                    LOGGER.info("Exception performing I/O for connection '{}' : {}", (Object)this._remoteSocketAddress, (Object)e.getMessage());
                }
                if (this._closed.compareAndSet(false, true)) {
                    this._protocolEngine.notifyWork();
                }
            }
            finally {
                this._protocolEngine.setIOThread(null);
            }
        }
        if (closed = this._closed.get()) {
            this.shutdown();
        }
        return closed;
    }

    @Override
    public void addSchedulingDelayNotificationListeners(SchedulingDelayNotificationListener listener) {
        this._schedulingDelayNotificationListeners.add(listener);
    }

    @Override
    public void removeSchedulingDelayNotificationListeners(SchedulingDelayNotificationListener listener) {
        this._schedulingDelayNotificationListeners.remove(listener);
    }

    private boolean processPending() throws IOException {
        boolean complete;
        if (this._pendingIterator == null) {
            this._pendingIterator = this._protocolEngine.processPendingIterator();
        }
        int networkBufferSize = this._port.getNetworkBufferSize();
        while (this._pendingIterator.hasNext()) {
            long size = this.getBufferedSize();
            if (size >= (long)networkBufferSize) {
                this.doWrite();
                long bytesWritten = size - this.getBufferedSize();
                if (bytesWritten >= (long)(networkBufferSize / 2)) continue;
                break;
            }
            Runnable task = this._pendingIterator.next();
            task.run();
        }
        boolean bl = complete = !this._pendingIterator.hasNext();
        if (this.getBufferedSize() >= (long)networkBufferSize) {
            this.doWrite();
            complete &= this.getBufferedSize() < (long)(networkBufferSize / 2);
        }
        return complete;
    }

    private long getBufferedSize() {
        return this._bufferedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        if (!this._hasShutdown.compareAndSet(false, true)) {
            return;
        }
        try {
            this.shutdownInput();
            this.shutdownFinalWrite();
            this._protocolEngine.closed();
            this.shutdownOutput();
        }
        finally {
            try {
                try {
                    NetworkConnectionScheduler scheduler = this.getScheduler();
                    if (scheduler != null) {
                        scheduler.removeConnection(this);
                    }
                }
                finally {
                    this._socketChannel.close();
                }
            }
            catch (IOException e) {
                LOGGER.info("Exception closing socket '{}': {}", (Object)this._remoteSocketAddress, (Object)e.getMessage());
            }
            if (SystemUtils.isWindows()) {
                this._delegate.shutdownInput();
                this._delegate.shutdownOutput();
            }
        }
    }

    private void shutdownFinalWrite() {
        try {
            while (!this.doWrite()) {
            }
        }
        catch (IOException e) {
            LOGGER.info("Exception performing final write/close for '{}': {}", (Object)this._remoteSocketAddress, (Object)e.getMessage());
        }
    }

    private void shutdownOutput() {
        block9: {
            try {
                if (SystemUtils.isWindows()) break block9;
                try {
                    this._socketChannel.shutdownOutput();
                }
                catch (IOException e) {
                    LOGGER.info("Exception closing socket '{}': {}", (Object)this._remoteSocketAddress, (Object)e.getMessage());
                }
                finally {
                    this._delegate.shutdownOutput();
                }
            }
            finally {
                while (!this._buffers.isEmpty()) {
                    QpidByteBuffer buffer = this._buffers.poll();
                    buffer.dispose();
                }
            }
        }
    }

    private void shutdownInput() {
        if (!SystemUtils.isWindows()) {
            try {
                this._socketChannel.shutdownInput();
            }
            catch (IOException e) {
                LOGGER.info("Exception shutting down input for '{}': {}", (Object)this._remoteSocketAddress, (Object)e.getMessage());
            }
            finally {
                this._delegate.shutdownInput();
            }
        }
    }

    boolean doRead() throws IOException {
        this._partialRead = false;
        if (!this._closed.get() && this._delegate.readyForRead()) {
            long readData = this.readFromNetwork();
            if (readData > 0L) {
                return this._delegate.processData();
            }
            return false;
        }
        return false;
    }

    long writeToTransport(Collection<QpidByteBuffer> buffers) throws IOException {
        long written = QpidByteBuffer.write(this._socketChannel, buffers);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Written " + written + " bytes");
        }
        return written;
    }

    private boolean doWrite() throws IOException {
        QpidByteBuffer buf;
        NonBlockingConnectionDelegate.WriteResult result = this._delegate.doWrite(this._buffers);
        this._bufferedSize -= result.getBytesConsumed();
        this._fullyWritten = result.isComplete();
        while (!this._buffers.isEmpty() && !(buf = this._buffers.peek()).hasRemaining()) {
            this._buffers.poll();
            buf.dispose();
        }
        return this._fullyWritten;
    }

    protected long readFromNetwork() throws IOException {
        QpidByteBuffer buffer = this._delegate.getNetInputBuffer();
        long read = buffer.read(this._socketChannel);
        if (read == -1L) {
            this._closed.set(true);
        }
        boolean bl = this._partialRead = read != 0L;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Read " + read + " byte(s)");
        }
        return read;
    }

    @Override
    public boolean isDirectBufferPreferred() {
        return true;
    }

    @Override
    public void send(QpidByteBuffer msg) {
        if (this._closed.get()) {
            LOGGER.warn("Send ignored as the connection is already closed");
        } else {
            int remaining = msg.remaining();
            if (remaining > 0) {
                this._buffers.add(msg.duplicate());
                this._bufferedSize += (long)remaining;
            }
        }
        msg.position(msg.limit());
    }

    @Override
    public void flush() {
    }

    public final void pushScheduler(NetworkConnectionScheduler scheduler) {
        this._schedulerDeque.addFirst(scheduler);
    }

    public final NetworkConnectionScheduler popScheduler() {
        return this._schedulerDeque.removeFirst();
    }

    public final NetworkConnectionScheduler getScheduler() {
        return this._schedulerDeque.peekFirst();
    }

    public String toString() {
        return "[NonBlockingConnection " + this._remoteSocketAddress + "]";
    }

    public void processAmqpData(QpidByteBuffer applicationData) {
        this._protocolEngine.received(applicationData);
    }

    public void setTransportEncryption(TransportEncryption transportEncryption) {
        NonBlockingConnectionDelegate oldDelegate = this._delegate;
        switch (transportEncryption) {
            case TLS: {
                this._onTransportEncryptionAction.run();
                this._delegate = new NonBlockingConnectionTLSDelegate(this, this._port);
                break;
            }
            case NONE: {
                this._delegate = new NonBlockingConnectionPlainDelegate(this, this._port);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown TransportEncryption " + (Object)((Object)transportEncryption));
            }
        }
        if (oldDelegate != null) {
            try (QpidByteBuffer src = oldDelegate.getNetInputBuffer().duplicate();){
                src.flip();
                this._delegate.getNetInputBuffer().put(src);
            }
            oldDelegate.shutdownInput();
            oldDelegate.shutdownOutput();
        }
        LOGGER.debug("Identified transport encryption as " + (Object)((Object)transportEncryption));
    }

    public boolean setScheduled() {
        boolean scheduled = this._scheduled.compareAndSet(false, true);
        if (scheduled) {
            this._scheduledTime = System.currentTimeMillis();
        }
        return scheduled;
    }

    public void clearScheduled() {
        this._scheduled.set(false);
        this._scheduledTime = 0L;
    }

    @Override
    public long getScheduledTime() {
        return this._scheduledTime;
    }

    void reportUnexpectedByteBufferSizeUsage() {
        if (!this._unexpectedByteBufferSizeReported) {
            LOGGER.info("At least one frame unexpectedly does not fit into default byte buffer size ({}B) on a connection {}.", (Object)this._port.getNetworkBufferSize(), (Object)this.toString());
            this._unexpectedByteBufferSizeReported = true;
        }
    }

    public SelectorThread.SelectionTask getSelectionTask() {
        return this._selectionTask;
    }

    public void setSelectionTask(SelectorThread.SelectionTask selectionTask) {
        this._selectionTask = selectionTask;
    }

    public void setSelectedHost(String selectedHost) {
        this._selectedHost = selectedHost;
    }

    @Override
    public String getSelectedHost() {
        return this._selectedHost;
    }
}

