/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.transport.NonBlockingConnection;
import org.apache.qpid.server.transport.NonBlockingConnectionDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingConnectionPlainDelegate
implements NonBlockingConnectionDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonBlockingConnectionPlainDelegate.class);
    private final NonBlockingConnection _parent;
    private final int _networkBufferSize;
    private volatile QpidByteBuffer _netInputBuffer;

    public NonBlockingConnectionPlainDelegate(NonBlockingConnection parent, AmqpPort<?> port) {
        this._parent = parent;
        this._networkBufferSize = port.getNetworkBufferSize();
        this._netInputBuffer = QpidByteBuffer.allocateDirect(this._networkBufferSize);
    }

    @Override
    public boolean readyForRead() {
        return true;
    }

    @Override
    public boolean processData() {
        this._netInputBuffer.flip();
        this._parent.processAmqpData(this._netInputBuffer);
        this.restoreApplicationBufferForWrite();
        return false;
    }

    protected void restoreApplicationBufferForWrite() {
        try (QpidByteBuffer oldNetInputBuffer = this._netInputBuffer;){
            int unprocessedDataLength = this._netInputBuffer.remaining();
            this._netInputBuffer.limit(this._netInputBuffer.capacity());
            this._netInputBuffer = oldNetInputBuffer.slice();
            this._netInputBuffer.limit(unprocessedDataLength);
        }
        if (this._netInputBuffer.limit() != this._netInputBuffer.capacity()) {
            this._netInputBuffer.position(this._netInputBuffer.limit());
            this._netInputBuffer.limit(this._netInputBuffer.capacity());
        } else {
            var2_2 = null;
            try (QpidByteBuffer currentBuffer = this._netInputBuffer;){
                int newBufSize;
                if (currentBuffer.capacity() < this._networkBufferSize) {
                    newBufSize = this._networkBufferSize;
                } else {
                    newBufSize = currentBuffer.capacity() + this._networkBufferSize;
                    this._parent.reportUnexpectedByteBufferSizeUsage();
                }
                this._netInputBuffer = QpidByteBuffer.allocateDirect(newBufSize);
                this._netInputBuffer.put(currentBuffer);
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
        }
    }

    @Override
    public NonBlockingConnectionDelegate.WriteResult doWrite(Collection<QpidByteBuffer> buffers) throws IOException {
        long bytesToWrite = 0L;
        if (!buffers.isEmpty()) {
            for (QpidByteBuffer buf : buffers) {
                bytesToWrite += (long)buf.remaining();
            }
        }
        if (bytesToWrite == 0L) {
            return new NonBlockingConnectionDelegate.WriteResult(true, 0L);
        }
        long bytesWritten = this._parent.writeToTransport(buffers);
        return new NonBlockingConnectionDelegate.WriteResult(bytesWritten >= bytesToWrite, bytesWritten);
    }

    @Override
    public Principal getPeerPrincipal() {
        return null;
    }

    @Override
    public Certificate getPeerCertificate() {
        return null;
    }

    @Override
    public boolean needsWork() {
        return false;
    }

    @Override
    public QpidByteBuffer getNetInputBuffer() {
        return this._netInputBuffer;
    }

    @Override
    public void shutdownInput() {
        if (this._netInputBuffer != null) {
            this._netInputBuffer.dispose();
            this._netInputBuffer = null;
        }
    }

    @Override
    public void shutdownOutput() {
    }

    @Override
    public String getTransportInfo() {
        return "";
    }
}

