/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport.network.security.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class QpidPeersOnlyTrustManager
implements X509TrustManager {
    private final X509TrustManager _delegate;
    private final List<Certificate> _trustedCerts = new ArrayList<Certificate>();

    public QpidPeersOnlyTrustManager(KeyStore ts, X509TrustManager trustManager) throws KeyStoreException {
        this._delegate = trustManager;
        Enumeration<String> aliases = ts.aliases();
        while (aliases.hasMoreElements()) {
            this._trustedCerts.add(ts.getCertificate(aliases.nextElement()));
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this._delegate.checkClientTrusted(chain, authType);
        for (Certificate serverTrustedCert : this._trustedCerts) {
            if (!chain[0].equals(serverTrustedCert)) continue;
            return;
        }
        throw new CertificateException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this._delegate.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

