/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport.network.security.ssl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.transport.TransportException;
import org.apache.qpid.server.transport.network.security.ssl.QpidMultipleTrustManager;
import org.apache.qpid.server.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLUtil.class);
    private static final Integer DNS_NAME_TYPE = 2;
    public static final String[] TLS_PROTOCOL_PREFERENCES = new String[]{"TLSv1.2", "TLSv1.1", "TLS", "TLSv1"};

    private SSLUtil() {
    }

    public static void verifyHostname(SSLEngine engine, String hostnameExpected) {
        try {
            Certificate cert = engine.getSession().getPeerCertificates()[0];
            if (!(cert instanceof X509Certificate)) {
                throw new TransportException("Cannot verify peer's hostname as peer does not present a X509Certificate. Presented certificate : " + cert);
            }
            SSLUtil.verifyHostname(hostnameExpected, (X509Certificate)cert);
        }
        catch (SSLPeerUnverifiedException e) {
            throw new TransportException("Failed to verify peer's hostname", e);
        }
    }

    public static void verifyHostname(String hostnameExpected, X509Certificate cert) {
        Principal p = cert.getSubjectDN();
        TreeSet<String> names = new TreeSet<String>();
        String dn = p.getName();
        try {
            LdapName ldapName = new LdapName(dn);
            for (Rdn rdn : ldapName.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                names.add(rdn.getValue().toString());
                break;
            }
            if (cert.getSubjectAlternativeNames() != null) {
                for (List list : cert.getSubjectAlternativeNames()) {
                    if (!DNS_NAME_TYPE.equals(list.get(0))) continue;
                    names.add((String)list.get(1));
                }
            }
            if (names.isEmpty()) {
                throw new TransportException("SSL hostname verification failed. Certificate for did not contain CN or DNS subjectAlt");
            }
            boolean match = false;
            String string = hostnameExpected.trim().toLowerCase();
            for (String cn : names) {
                boolean doWildcard;
                boolean bl = doWildcard = cn.startsWith("*.") && cn.lastIndexOf(46) >= 3 && !cn.matches("\\*\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
                boolean bl2 = doWildcard ? string.endsWith(cn.substring(1)) && string.indexOf(".") == 1 + string.length() - cn.length() : string.equals(cn);
                match = bl2;
                if (!match) continue;
                break;
            }
            if (!match) {
                throw new TransportException("SSL hostname verification failed. Expected : " + hostnameExpected + " Found in cert : " + names);
            }
        }
        catch (InvalidNameException e) {
            throw new TransportException("SSL hostname verification failed. Could not parse name " + dn, e);
        }
        catch (CertificateParsingException e) {
            throw new TransportException("SSL hostname verification failed. Could not parse certificate:  " + e.getMessage(), e);
        }
    }

    public static String getIdFromSubjectDN(String dn) {
        String cnStr = null;
        String dcStr = null;
        if (dn == null) {
            return "";
        }
        try {
            LdapName ln = new LdapName(dn);
            for (Rdn rdn : ln.getRdns()) {
                if ("CN".equalsIgnoreCase(rdn.getType())) {
                    cnStr = rdn.getValue().toString();
                    continue;
                }
                if (!"DC".equalsIgnoreCase(rdn.getType())) continue;
                if (dcStr == null) {
                    dcStr = rdn.getValue().toString();
                    continue;
                }
                dcStr = rdn.getValue().toString() + '.' + dcStr;
            }
            return cnStr == null || cnStr.length() == 0 ? "" : (dcStr == null ? cnStr : cnStr + '@' + dcStr);
        }
        catch (InvalidNameException e) {
            LOGGER.warn("Invalid name: '{}'", (Object)dn);
            return "";
        }
    }

    public static String retrieveIdentity(SSLEngine engine) {
        String id = "";
        Certificate cert = engine.getSession().getLocalCertificates()[0];
        Principal p = ((X509Certificate)cert).getSubjectDN();
        String dn = p.getName();
        try {
            id = SSLUtil.getIdFromSubjectDN(dn);
        }
        catch (Exception e) {
            LOGGER.info("Exception received while trying to retrieve client identity from SSL cert", (Throwable)e);
        }
        LOGGER.debug("Extracted Identity from client certificate : {}", (Object)id);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getInitializedKeyStore(String storePath, String storePassword, String keyStoreType) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        InputStream in = null;
        try {
            File f = new File(storePath);
            in = f.exists() ? new FileInputStream(f) : Thread.currentThread().getContextClassLoader().getResourceAsStream(storePath);
            if (in == null && !"PKCS11".equalsIgnoreCase(keyStoreType)) {
                throw new IOException("Unable to load keystore resource: " + storePath);
            }
            char[] storeCharPassword = storePassword == null ? null : storePassword.toCharArray();
            ks.load(in, storeCharPassword);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    public static KeyStore getInitializedKeyStore(URL storePath, String storePassword, String keyStoreType) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        try (InputStream in = storePath.openStream();){
            if (in == null && !"PKCS11".equalsIgnoreCase(keyStoreType)) {
                throw new IOException("Unable to load keystore resource: " + storePath);
            }
            char[] storeCharPassword = storePassword == null ? null : storePassword.toCharArray();
            ks.load(in, storeCharPassword);
        }
        return ks;
    }

    public static X509Certificate[] readCertificates(URL certFile) throws IOException, GeneralSecurityException {
        try (InputStream is = certFile.openStream();){
            X509Certificate[] x509CertificateArray = SSLUtil.readCertificates(certFile.openStream());
            return x509CertificateArray;
        }
    }

    public static X509Certificate[] readCertificates(InputStream input) throws IOException, GeneralSecurityException {
        ArrayList<X509Certificate> crt;
        block3: {
            crt = new ArrayList<X509Certificate>();
            try {
                do {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    crt.add((X509Certificate)cf.generateCertificate(input));
                } while (input.available() != 0);
            }
            catch (CertificateException e) {
                if (!crt.isEmpty()) break block3;
                throw e;
            }
        }
        return crt.toArray(new X509Certificate[crt.size()]);
    }

    public static PrivateKey readPrivateKey(URL url) throws IOException, GeneralSecurityException {
        try (InputStream urlStream = url.openStream();){
            PrivateKey privateKey = SSLUtil.readPrivateKey(urlStream);
            return privateKey;
        }
    }

    public static PrivateKey readPrivateKey(InputStream input) throws IOException, GeneralSecurityException {
        byte[] content = SSLUtil.toByteArray(input);
        String contentAsString = new String(content, StandardCharsets.US_ASCII);
        if (contentAsString.contains("-----BEGIN ") && contentAsString.contains(" PRIVATE KEY-----")) {
            String line;
            BufferedReader lineReader = new BufferedReader(new StringReader(contentAsString));
            while (!((line = lineReader.readLine()) == null || line.startsWith("-----BEGIN ") && line.endsWith(" PRIVATE KEY-----"))) {
            }
            if (line != null) {
                StringBuilder keyBuilder = new StringBuilder();
                while (!((line = lineReader.readLine()) == null || line.startsWith("-----END ") && line.endsWith(" PRIVATE KEY-----"))) {
                    keyBuilder.append(line);
                }
                content = Strings.decodeBase64(keyBuilder.toString());
            }
        }
        return SSLUtil.readPrivateKey(content, "RSA");
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int read;
            byte[] tmp = new byte[1024];
            while ((read = input.read(tmp)) != -1) {
                buffer.write(tmp, 0, read);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    public static PrivateKey readPrivateKey(byte[] content, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey key;
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(content);
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            key = kf.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            RSAPrivateCrtKeySpec keySpec = SSLUtil.getRSAKeySpec(content);
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            try {
                key = kf.generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException e2) {
                throw new InvalidKeySpecException("Cannot parse the provided key as either PKCS#1 or PCKS#8 format");
            }
        }
        return key;
    }

    private static RSAPrivateCrtKeySpec getRSAKeySpec(byte[] keyBytes) throws InvalidKeySpecException {
        ByteBuffer buffer = ByteBuffer.wrap(keyBytes);
        try {
            int tag = buffer.get() & 0xFF;
            if ((tag & 0x20) != 32 || (tag & 0x1F) != 16) {
                throw new InvalidKeySpecException("Unable to parse key as PKCS#1 format");
            }
            int length = SSLUtil.getLength(buffer);
            buffer = buffer.slice();
            buffer.limit(length);
            byte versionTag = buffer.get();
            int versionLength = SSLUtil.getLength(buffer);
            buffer.position(buffer.position() + versionLength);
            RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer), SSLUtil.getInteger(buffer));
            return keySpec;
        }
        catch (BufferUnderflowException e) {
            throw new InvalidKeySpecException("Unable to parse key as PKCS#1 format");
        }
    }

    private static int getLength(ByteBuffer buffer) {
        int i = buffer.get() & 0xFF;
        if ((i & 0xFFFFFF80) == 0) {
            return i;
        }
        byte[] bytes = new byte[i & 0x7F];
        buffer.get(bytes);
        return new BigInteger(1, bytes).intValue();
    }

    private static BigInteger getInteger(ByteBuffer buffer) throws InvalidKeySpecException {
        int tag = buffer.get() & 0xFF;
        if ((tag & 0x1F) != 2) {
            throw new InvalidKeySpecException("Unable to parse key as PKCS#1 format");
        }
        byte[] num = new byte[SSLUtil.getLength(buffer)];
        buffer.get(num);
        return new BigInteger(num);
    }

    public static void updateEnabledTlsProtocols(SSLEngine engine, List<String> protocolWhiteList, List<String> protocolBlackList) {
        String[] filteredProtocols = SSLUtil.filterEnabledProtocols(engine.getEnabledProtocols(), engine.getSupportedProtocols(), protocolWhiteList, protocolBlackList);
        engine.setEnabledProtocols(filteredProtocols);
    }

    public static void updateEnabledTlsProtocols(SSLSocket socket, List<String> protocolWhiteList, List<String> protocolBlackList) {
        String[] filteredProtocols = SSLUtil.filterEnabledProtocols(socket.getEnabledProtocols(), socket.getSupportedProtocols(), protocolWhiteList, protocolBlackList);
        socket.setEnabledProtocols(filteredProtocols);
    }

    public static String[] filterEnabledProtocols(String[] enabledProtocols, String[] supportedProtocols, List<String> protocolWhiteList, List<String> protocolBlackList) {
        return SSLUtil.filterEntries(enabledProtocols, supportedProtocols, protocolWhiteList, protocolBlackList);
    }

    public static String[] filterEnabledCipherSuites(String[] enabledCipherSuites, String[] supportedCipherSuites, List<String> cipherSuiteWhiteList, List<String> cipherSuiteBlackList) {
        return SSLUtil.filterEntries(enabledCipherSuites, supportedCipherSuites, cipherSuiteWhiteList, cipherSuiteBlackList);
    }

    public static void updateEnabledCipherSuites(SSLEngine engine, List<String> cipherSuitesWhiteList, List<String> cipherSuitesBlackList) {
        String[] filteredCipherSuites = SSLUtil.filterEntries(engine.getEnabledCipherSuites(), engine.getSupportedCipherSuites(), cipherSuitesWhiteList, cipherSuitesBlackList);
        engine.setEnabledCipherSuites(filteredCipherSuites);
    }

    public static void updateEnabledCipherSuites(SSLSocket socket, List<String> cipherSuitesWhiteList, List<String> cipherSuitesBlackList) {
        String[] filteredCipherSuites = SSLUtil.filterEntries(socket.getEnabledCipherSuites(), socket.getSupportedCipherSuites(), cipherSuitesWhiteList, cipherSuitesBlackList);
        socket.setEnabledCipherSuites(filteredCipherSuites);
    }

    static String[] filterEntries(String[] enabledEntries, String[] supportedEntries, List<String> whiteList, List<String> blackList) {
        ArrayList<String> filteredList;
        if (whiteList != null && !whiteList.isEmpty()) {
            filteredList = new ArrayList();
            ArrayList<String> supportedList = new ArrayList<String>(Arrays.asList(supportedEntries));
            for (String whiteListedRegEx : whiteList) {
                Iterator supportedIter = supportedList.iterator();
                while (supportedIter.hasNext()) {
                    String supportedEntry = (String)supportedIter.next();
                    if (!supportedEntry.matches(whiteListedRegEx)) continue;
                    filteredList.add(supportedEntry);
                    supportedIter.remove();
                }
            }
        } else {
            filteredList = new ArrayList<String>(Arrays.asList(enabledEntries));
        }
        if (blackList != null && !blackList.isEmpty()) {
            for (String blackListedRegEx : blackList) {
                Iterator entriesIter = filteredList.iterator();
                while (entriesIter.hasNext()) {
                    if (!((String)entriesIter.next()).matches(blackListedRegEx)) continue;
                    entriesIter.remove();
                }
            }
        }
        return filteredList.toArray(new String[filteredList.size()]);
    }

    public static SSLContext tryGetSSLContext() throws NoSuchAlgorithmException {
        return SSLUtil.tryGetSSLContext(TLS_PROTOCOL_PREFERENCES);
    }

    public static SSLContext tryGetSSLContext(String[] protocols) throws NoSuchAlgorithmException {
        for (String protocol : protocols) {
            try {
                return SSLContext.getInstance(protocol);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        throw new NoSuchAlgorithmException(String.format("Could not create SSLContext with one of the requested protocols: %s", Arrays.toString(protocols)));
    }

    public static boolean isSufficientToDetermineClientSNIHost(QpidByteBuffer buffer) {
        if (buffer.remaining() < 6) {
            return false;
        }
        if (SSLUtil.looksLikeSSLv3ClientHello(buffer)) {
            int position = buffer.position();
            int recordSize = 5 + ((buffer.get(position + 3) & 0xFF) << 8 | buffer.get(position + 4) & 0xFF);
            return buffer.remaining() >= recordSize;
        }
        return true;
    }

    private static boolean looksLikeSSLv3ClientHello(QpidByteBuffer buffer) {
        byte contentType = buffer.get(buffer.position() + 0);
        byte majorVersion = buffer.get(buffer.position() + 1);
        byte minorVersion = buffer.get(buffer.position() + 2);
        byte messageType = buffer.get(buffer.position() + 5);
        return contentType == 22 && majorVersion == 3 && (minorVersion == 0 || minorVersion == 1 || minorVersion == 2 || minorVersion == 3) && messageType == 1;
    }

    public static final String getServerNameFromTLSClientHello(QpidByteBuffer source) {
        try (QpidByteBuffer input = source.duplicate();){
            if (!SSLUtil.isSufficientToDetermineClientSNIHost(source)) {
                throw new IllegalArgumentException("Source buffer does not contain enough data to determine the SNI name");
            }
            if (!SSLUtil.looksLikeSSLv3ClientHello(source)) {
                String string = null;
                return string;
            }
            byte contentType = input.get();
            byte majorVersion = input.get();
            byte minorVersion = input.get();
            if (minorVersion != 0) {
                int recordLength = input.getUnsignedShort();
                byte messageType = input.get();
                int length = input.getUnsignedByte() << 16 | input.getUnsignedByte() << 8 | input.getUnsignedByte();
                if (input.remaining() < length) {
                    String string = null;
                    return string;
                }
                input.limit(length + input.position());
                input.position(input.position() + 34);
                int skip = input.get();
                input.position(input.position() + skip);
                skip = input.getUnsignedShort();
                input.position(input.position() + skip);
                skip = input.get();
                input.position(input.position() + skip);
                if (input.hasRemaining()) {
                    int remaining = input.getUnsignedShort();
                    if (input.remaining() < remaining) {
                        String string = null;
                        return string;
                    }
                    input.limit(input.position() + remaining);
                    while (input.hasRemaining()) {
                        int extensionType = input.getUnsignedShort();
                        int extensionLength = input.getUnsignedShort();
                        if (extensionType == 0) {
                            int extensionDataRemaining = extensionLength;
                            if (extensionDataRemaining >= 2) {
                                int listLength = input.getUnsignedShort();
                                if (listLength + 2 != extensionDataRemaining) {
                                    String string = null;
                                    return string;
                                }
                                extensionDataRemaining -= 2;
                                while (extensionDataRemaining > 0) {
                                    byte code = input.get();
                                    int serverNameLength = input.getUnsignedShort();
                                    if (serverNameLength > extensionDataRemaining) {
                                        String string = null;
                                        return string;
                                    }
                                    byte[] encoded = new byte[serverNameLength];
                                    input.get(encoded);
                                    if (code == 0) {
                                        String string = new SNIHostName(encoded).getAsciiName();
                                        return string;
                                    }
                                    extensionDataRemaining -= serverNameLength + 3;
                                }
                            }
                            String string = null;
                            return string;
                        }
                        if (input.remaining() < extensionLength) {
                            String string = null;
                            return string;
                        }
                        input.position(input.position() + extensionLength);
                    }
                }
            }
            String string = null;
            return string;
        }
    }

    public static SSLContext createSslContext(org.apache.qpid.server.model.KeyStore keyStore, Collection<TrustStore> trustStores, String portName) {
        SSLContext sslContext;
        try {
            TrustManager[] trustManagers;
            sslContext = SSLUtil.tryGetSSLContext();
            KeyManager[] keyManagers = keyStore.getKeyManagers();
            if (trustStores == null || trustStores.isEmpty()) {
                trustManagers = null;
            } else if (trustStores.size() == 1) {
                trustManagers = trustStores.iterator().next().getTrustManagers();
            } else {
                ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
                QpidMultipleTrustManager mulTrustManager = new QpidMultipleTrustManager();
                for (TrustStore ts : trustStores) {
                    TrustManager[] managers = ts.getTrustManagers();
                    if (managers == null) continue;
                    for (TrustManager manager : managers) {
                        if (manager instanceof X509TrustManager) {
                            mulTrustManager.addTrustManager((X509TrustManager)manager);
                            continue;
                        }
                        trustManagerList.add(manager);
                    }
                }
                if (!mulTrustManager.isEmpty()) {
                    trustManagerList.add(mulTrustManager);
                }
                trustManagers = trustManagerList.toArray(new TrustManager[trustManagerList.size()]);
            }
            sslContext.init(keyManagers, trustManagers, null);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(String.format("Cannot configure TLS on port '%s'", portName), e);
        }
        return sslContext;
    }
}

