/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import com.google.common.util.concurrent.ListenableFuture;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.qpid.server.logging.messages.VirtualHostMessages;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.protocol.LinkModel;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.virtualhost.ConnectionEstablishmentPolicy;
import org.apache.qpid.server.virtualhost.VirtualHostPrincipal;

public abstract class AbstractNonConnectionAcceptingVirtualHost<X extends AbstractNonConnectionAcceptingVirtualHost<X>>
extends AbstractConfiguredObject<X>
implements VirtualHost<X> {
    private final VirtualHostPrincipal _principal = new VirtualHostPrincipal(this);

    public AbstractNonConnectionAcceptingVirtualHost(ConfiguredObject<?> parent, Map<String, Object> attributes) {
        super(parent, attributes);
        this.setState(State.UNAVAILABLE);
    }

    @Override
    public String getRedirectHost(AmqpPort<?> port) {
        return null;
    }

    @Override
    public Principal getPrincipal() {
        return this._principal;
    }

    @Override
    public boolean registerConnection(AMQPConnection<?> connection, ConnectionEstablishmentPolicy connectionEstablishmentPolicy) {
        this.throwUnsupported();
        return false;
    }

    @Override
    public void deregisterConnection(AMQPConnection<?> connection) {
        this.throwUnsupported();
    }

    protected void throwUnsupported() {
        throw new IllegalStateException("The virtual host '" + this.getName() + "' does not permit this operation.");
    }

    @Override
    public Collection<? extends Connection<?>> getConnections() {
        return Collections.emptyList();
    }

    @Override
    public MessageSource getAttainedMessageSource(String name) {
        return null;
    }

    @Override
    public MessageDestination getDefaultDestination() {
        return null;
    }

    @Override
    public MessageStore getMessageStore() {
        return null;
    }

    @Override
    public <T extends MessageSource> T createMessageSource(Class<T> clazz, Map<String, Object> attributes) {
        this.throwUnsupported();
        return null;
    }

    @Override
    public <T extends MessageDestination> T createMessageDestination(Class<T> clazz, Map<String, Object> attributes) {
        this.throwUnsupported();
        return null;
    }

    @Override
    public boolean hasMessageSources() {
        return false;
    }

    @Override
    public DtxRegistry getDtxRegistry() {
        return null;
    }

    @Override
    public <T extends LinkModel> T getSendingLink(String remoteContainerId, String linkName) {
        this.throwUnsupported();
        return null;
    }

    @Override
    public <T extends LinkModel> T getReceivingLink(String remoteContainerId, String linkName) {
        this.throwUnsupported();
        return null;
    }

    @Override
    public <T extends LinkModel> Collection<T> findSendingLinks(Pattern containerIdPattern, Pattern linkNamePattern) {
        this.throwUnsupported();
        return null;
    }

    @Override
    public boolean authoriseCreateConnection(AMQPConnection<?> connection) {
        return false;
    }

    @Override
    public List<String> getGlobalAddressDomains() {
        return Collections.emptyList();
    }

    @Override
    public String getLocalAddress(String routingAddress) {
        return routingAddress;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public String getModelVersion() {
        return "7.0";
    }

    @Override
    public String getProductVersion() {
        return this.getAncestor(Broker.class).getProductVersion();
    }

    @Override
    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes) {
        this.throwUnsupported();
        return null;
    }

    @Override
    public MessageDestination getAttainedMessageDestination(String name) {
        return null;
    }

    @Override
    public MessageDestination getAttainedMessageDestination(String name, boolean mayCreate) {
        return null;
    }

    @Override
    protected void logOperation(String operation) {
        this.getAncestor(Broker.class).getEventLogger().message(VirtualHostMessages.OPERATION(operation));
    }
}

