/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import com.google.common.util.concurrent.ListenableFuture;
import java.security.AccessControlContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManageableMessage;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.security.auth.SocketConnectionMetaData;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.preferences.UserPreferencesCreator;
import org.apache.qpid.server.virtualhost.CacheProvider;
import org.apache.qpid.server.virtualhost.HouseKeepingTask;
import org.apache.qpid.server.virtualhost.NodeAutoCreationPolicy;

public interface QueueManagingVirtualHost<X extends QueueManagingVirtualHost<X>>
extends VirtualHost<X>,
EventListener,
StatisticsGatherer,
UserPreferencesCreator,
EventLoggerProvider,
CacheProvider {
    public static final String HOUSEKEEPING_CHECK_PERIOD = "housekeepingCheckPeriod";
    public static final String STORE_TRANSACTION_IDLE_TIMEOUT_CLOSE = "storeTransactionIdleTimeoutClose";
    public static final String STORE_TRANSACTION_IDLE_TIMEOUT_WARN = "storeTransactionIdleTimeoutWarn";
    public static final String STORE_TRANSACTION_OPEN_TIMEOUT_CLOSE = "storeTransactionOpenTimeoutClose";
    public static final String STORE_TRANSACTION_OPEN_TIMEOUT_WARN = "storeTransactionOpenTimeoutWarn";
    public static final String HOUSE_KEEPING_THREAD_COUNT = "houseKeepingThreadCount";
    public static final String ENABLED_CONNECTION_VALIDATORS = "enabledConnectionValidators";
    public static final String DISABLED_CONNECTION_VALIDATORS = "disabledConnectionValidators";
    public static final String NUMBER_OF_SELECTORS = "numberOfSelectors";
    public static final String CONNECTION_THREAD_POOL_SIZE = "connectionThreadPoolSize";
    public static final String GLOBAL_ADDRESS_DOMAINS = "globalAddressDomains";
    public static final String NODE_AUTO_CREATION_POLICIES = "nodeAutoCreationPolicies";
    public static final String STATISTICS_REPORTING_PERIOD = "statisticsReportingPeriod";
    @ManagedContextDefault(name="virtualhost.housekeepingCheckPeriod")
    public static final long DEFAULT_HOUSEKEEPING_CHECK_PERIOD = 30000L;
    public static final String FLOW_TO_DISK_CHECK_PERIOD = "virtualhost.flowToDiskCheckPeriod";
    @ManagedContextDefault(name="virtualhost.flowToDiskCheckPeriod")
    public static final long DEFAULT_FLOW_TO_DISK_CHECK_PERIOD = 30000L;
    public static final String CONNECTION_THREAD_POOL_KEEP_ALIVE_TIMEOUT = "connectionThreadPoolKeepAliveTimeout";
    @ManagedContextDefault(name="connectionThreadPoolKeepAliveTimeout")
    public static final long DEFAULT_CONNECTION_THREAD_POOL_KEEP_ALIVE_TIMEOUT = 60L;
    @ManagedContextDefault(name="virtualhost.storeTransactionIdleTimeoutClose")
    public static final long DEFAULT_STORE_TRANSACTION_IDLE_TIMEOUT_CLOSE = 0L;
    @ManagedContextDefault(name="virtualhost.housekeepingThreadCount")
    public static final int DEFAULT_HOUSEKEEPING_THREAD_COUNT = 4;
    public static final String VIRTUALHOST_STATISTICS_REPORING_PERIOD = "virtualhost.statisticsReportingPeriod";
    @ManagedContextDefault(name="virtualhost.statisticsReportingPeriod")
    public static final int DEFAULT_STATISTICS_REPORTING_PERIOD = 0;
    public static final String DISCARD_GLOBAL_SHARED_SUBSCRIPTION_LINKS_ON_DETACH = "qpid.jms.discardGlobalSharedSubscriptionLinksOnDetach";
    @ManagedContextDefault(name="qpid.jms.discardGlobalSharedSubscriptionLinksOnDetach", description="If true AMQP 1.0 links of global shared subscriptions are discarded when the link detaches. This is to avoid leaking links with the Qpid JMS client.")
    public static final boolean DEFAULT_DISCARD_GLOBAL_SHARED_SUBSCRIPTION_LINKS_ON_DETACH = true;
    @ManagedContextDefault(name="virtualhost.storeTransactionIdleTimeoutWarn")
    public static final long DEFAULT_STORE_TRANSACTION_IDLE_TIMEOUT_WARN = 180000L;
    @ManagedContextDefault(name="virtualhost.storeTransactionOpenTimeoutClose")
    public static final long DEFAULT_STORE_TRANSACTION_OPEN_TIMEOUT_CLOSE = 0L;
    @ManagedContextDefault(name="virtualhost.storeTransactionOpenTimeoutWarn")
    public static final long DEFAULT_STORE_TRANSACTION_OPEN_TIMEOUT_WARN = 300000L;
    public static final String VIRTUALHOST_CONNECTION_THREAD_POOL_SIZE = "virtualhost.connectionThreadPool.size";
    @ManagedContextDefault(name="virtualhost.connectionThreadPool.size")
    public static final long DEFAULT_VIRTUALHOST_CONNECTION_THREAD_POOL_SIZE = Math.max(Runtime.getRuntime().availableProcessors() * 2, 64);
    public static final String VIRTUALHOST_CONNECTION_THREAD_POOL_NUMBER_OF_SELECTORS = "virtualhost.connectionThreadPool.numberOfSelectors";
    @ManagedContextDefault(name="virtualhost.connectionThreadPool.numberOfSelectors")
    public static final long DEFAULT_VIRTUALHOST_CONNECTION_THREAD_POOL_NUMBER_OF_SELECTORS = Math.max(DEFAULT_VIRTUALHOST_CONNECTION_THREAD_POOL_SIZE / 8L, 1L);
    public static final String NAMED_CACHE_MAXIMUM_SIZE = "virtualhost.namedCache.maximumSize";
    @ManagedContextDefault(name="virtualhost.namedCache.maximumSize", description="Maximum number of entries within the named cached")
    public static final int DEFAULT_NAMED_CACHE_SIZE = 100;
    public static final String NAMED_CACHE_MAXIMUM_SIZE_FORMAT = "virtualhost.namedCache.%s.maximumSize";
    public static final String NAMED_CACHE_EXPIRATION = "virtualhost.namedCache.expiration";
    @ManagedContextDefault(name="virtualhost.namedCache.expiration", description="Expiration time (in millis) applied to cached values within the named cache")
    public static final long DEFAULT_NAMED_CACHE_EXPIRATION = 300000L;
    public static final String NAMED_CACHE_EXPIRATION_FORMAT = "virtualhost.namedCache.%s.expiration";
    @ManagedContextDefault(name="virtualhost.enabledConnectionValidators")
    public static final String DEFAULT_ENABLED_VALIDATORS = "[]";
    @ManagedContextDefault(name="virtualhost.disabledConnectionValidators")
    public static final String DEFAULT_DISABLED_VALIDATORS = "[]";

    @ManagedAttribute(defaultValue="${virtualhost.statisticsReportingPeriod}", description="Period (in seconds) of the statistic report.")
    public int getStatisticsReportingPeriod();

    @ManagedAttribute(defaultValue="${virtualhost.storeTransactionIdleTimeoutClose}", description="The maximum length of time, in milliseconds, that an open store transaction may remain idle. If a transaction exceeds this threshold, the resource that created the transaction will be closed automatically.")
    public long getStoreTransactionIdleTimeoutClose();

    @ManagedAttribute(defaultValue="${virtualhost.storeTransactionIdleTimeoutWarn}", description="The maximum length of time, in milliseconds, that an open store transaction may remain idle. If a transaction exceeds this threshold, warnings will be written to the logs.")
    public long getStoreTransactionIdleTimeoutWarn();

    @ManagedAttribute(defaultValue="${virtualhost.storeTransactionOpenTimeoutClose}", description="The maximum length of time, in milliseconds, that a store transaction may remain open. If a transaction exceeds this threshold, the resource that created the transaction will be closed automatically.")
    public long getStoreTransactionOpenTimeoutClose();

    @ManagedAttribute(defaultValue="${virtualhost.storeTransactionOpenTimeoutWarn}", description="The maximum length of time, in milliseconds, that a store transaction may remain open. If a transaction exceeds this threshold, warnings will be written to the logs.")
    public long getStoreTransactionOpenTimeoutWarn();

    @ManagedAttribute(defaultValue="${virtualhost.housekeepingCheckPeriod}")
    public long getHousekeepingCheckPeriod();

    @DerivedAttribute(description="Time (in milliseconds) between checks whether existing messages need to be flowed to disk in order to free memory.")
    public long getFlowToDiskCheckPeriod();

    @DerivedAttribute(description="Indicates whether global shared durable subscriptions are disabled")
    public boolean isDiscardGlobalSharedSubscriptionLinksOnDetach();

    @ManagedAttribute(defaultValue="${virtualhost.connectionThreadPool.size}")
    public int getConnectionThreadPoolSize();

    @ManagedAttribute(defaultValue="${virtualhost.connectionThreadPool.numberOfSelectors}")
    public int getNumberOfSelectors();

    @ManagedAttribute(defaultValue="${virtualhost.housekeepingThreadCount}")
    public int getHousekeepingThreadCount();

    @ManagedAttribute(defaultValue="[]", description="a list of policies used for auto-creating nodes (such as Queues or Exchanges) when an address is published to or subscribed from and no node matching the address currently exists. Each policy describes a pattern to match against the address, the circumstances when auto-creation should occur (on publish, on consume, or both), the type of node to be created, and the properties of the node.")
    public List<NodeAutoCreationPolicy> getNodeAutoCreationPolicies();

    @ManagedAttribute(defaultValue="${virtualhost.enabledConnectionValidators}")
    public List<String> getEnabledConnectionValidators();

    @ManagedAttribute(defaultValue="${virtualhost.disabledConnectionValidators}")
    public List<String> getDisabledConnectionValidators();

    @Override
    @ManagedAttribute(defaultValue="[]")
    public List<String> getGlobalAddressDomains();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Queues", description="Current number of queues on this virtualhost.")
    public long getQueueCount();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Exchanges", description="Current number of exchanges on this virtualhost.")
    public long getExchangeCount();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Connections", description="Current number of messaging connections made to this virtualhost.")
    public long getConnectionCount();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.COUNT, label="Total Connections", description="Total number of messaging connections made to this virtualhost since broker startup")
    public long getTotalConnectionCount();

    @Override
    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Inbound", description="Total size of all messages received by this virtualhost.")
    public long getBytesIn();

    @Override
    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Outbound", description="Total size of all messages delivered by this virtualhost.")
    public long getBytesOut();

    @Override
    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Inbound", description="Total number of messages received by this virtualhost.")
    public long getMessagesIn();

    @Override
    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Outbound", description="Total number of messages delivered by this virtualhost.")
    public long getMessagesOut();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Transacted Inbound", description="Total number of messages delivered by this virtualhost within a transaction.")
    public long getTransactedMessagesIn();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Transacted Outbound", description="Total number of messages received by this virtualhost within a transaction.")
    public long getTransactedMessagesOut();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Queue Depth", description="Current size of all messages enqueued by this virtualhost.")
    public long getTotalDepthOfQueuesBytes();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Queue Depth", description="Current number of messages enqueued by this virtualhost.")
    public long getTotalDepthOfQueuesMessages();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="In-Memory Message Bytes", description="Current size of all messages cached in-memory.")
    public long getInMemoryMessageSize();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Evacuated Message Bytes", description="Total Number of Bytes Evacuated from Memory Due to Flow to Disk.")
    public long getBytesEvacuatedFromMemory();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Maximum recorded size of inbound messages", description="Maximum size of message published into the Virtual Host since start-up.")
    public long getInboundMessageSizeHighWatermark();

    @Override
    @ManagedOperation(nonModifying=true, changesConfiguredObjectState=false)
    public Collection<? extends Connection<?>> getConnections();

    @ManagedOperation(nonModifying=true, changesConfiguredObjectState=false)
    public Connection<?> getConnection(@Param(name="name", mandatory=true) String var1);

    @ManagedOperation(secure=true, description="Publishes a message to a specified address. Returns the number of queues onto which it has been placed,  or zero, if the address routes to no queues.", changesConfiguredObjectState=false)
    public int publishMessage(@Param(name="message", mandatory=true) ManageableMessage var1);

    @ManagedOperation(nonModifying=true, description="Extract configuration", paramRequiringSecure="includeSecureAttributes", changesConfiguredObjectState=false)
    public Map<String, Object> extractConfig(@Param(name="includeSecureAttributes", description="include attributes that may contain passwords or other confidential information", defaultValue="false") boolean var1);

    @ManagedOperation(nonModifying=true, description="Extract message store content", secure=true, changesConfiguredObjectState=false)
    public Content exportMessageStore();

    @ManagedOperation(description="Import message store content", secure=true, changesConfiguredObjectState=false)
    public void importMessageStore(@Param(name="source", description="Extract file", mandatory=true) String var1);

    @ManagedOperation(nonModifying=true, description="Returns metadata concerning the current connection", changesConfiguredObjectState=false, skipAclCheck=true)
    public SocketConnectionMetaData getConnectionMetaData();

    @ManagedOperation(nonModifying=true, description="Dumps link registry", changesConfiguredObjectState=false)
    public Object dumpLinkRegistry();

    @ManagedOperation(description="Removes links with the given name and containerId pattern from the link registry.", changesConfiguredObjectState=false)
    public void purgeLinkRegistry(@Param(name="containerIdPattern", description="Regular Expression to match the remote container id.", defaultValue=".*") String var1, @Param(name="role", description="whether to remove only sending links (\"SENDER\"), receiving links (\"RECEIVER\") or both (\"BOTH\")", validValues={"SENDER", "RECEIVER", "BOTH"}, defaultValue="BOTH") String var2, @Param(name="linkNamePattern", description="Regular Expression to match the link names to be removed.", defaultValue=".*") String var3);

    public Queue<?> getSubscriptionQueue(String var1, Map<String, Object> var2, Map<String, Map<String, Object>> var3);

    public void removeSubscriptionQueue(String var1);

    public Broker<?> getBroker();

    public DurableConfigurationStore getDurableConfigurationStore();

    public void executeTransaction(TransactionalOperation var1);

    public void executeTask(String var1, Runnable var2, AccessControlContext var3);

    public void scheduleHouseKeepingTask(long var1, HouseKeepingTask var3);

    public ScheduledFuture<?> scheduleTask(long var1, Runnable var3);

    public Queue<?> getAttainedQueue(UUID var1);

    public Queue<?> getAttainedQueue(String var1);

    public <T extends ConfiguredObject<?>> T getAttainedChildFromAddress(Class<T> var1, String var2);

    public void setFirstOpening(boolean var1);

    public long getTargetSize();

    public void setTargetSize(long var1);

    public MessageDestination getSystemDestination(String var1);

    public ListenableFuture<Void> reallocateMessages();

    public boolean isOverTargetSize();

    public static interface TransactionalOperation {
        public void withinTransaction(Transaction var1);

        public List<Long> getModifiedMessageIds();
    }

    public static interface Transaction {
        public void dequeue(QueueEntry var1);

        public void copy(QueueEntry var1, Queue<?> var2);

        public void move(QueueEntry var1, Queue<?> var2);
    }
}

