/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode;

import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.virtualhost.AbstractNonConnectionAcceptingVirtualHost;
import org.apache.qpid.server.virtualhostnode.RedirectingVirtualHost;
import org.apache.qpid.server.virtualhostnode.RedirectingVirtualHostNode;

@ManagedObject(category=false, type="REDIRECTOR", register=false, description="<p>A virtualhost is a namespace in which messaging is performed. Virtualhosts are independent; the messaging goes on a within a virtualhost is independent of any messaging that goes on in another virtualhost. For instance, a queue named <i>foo</i> defined in one virtualhost is completely independent of a queue named <i>foo</i> in another virtualhost.</p><p>A virtualhost is backed by storage which is used to store the messages.</p>")
class RedirectingVirtualHostImpl
extends AbstractNonConnectionAcceptingVirtualHost<RedirectingVirtualHostImpl>
implements RedirectingVirtualHost<RedirectingVirtualHostImpl> {
    public static final String VIRTUAL_HOST_TYPE = "REDIRECTOR";

    @ManagedObjectFactoryConstructor
    public RedirectingVirtualHostImpl(Map<String, Object> attributes, VirtualHostNode<?> virtualHostNode) {
        super(virtualHostNode, attributes);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        if (changedAttributes.contains("desiredState") && proxyForValidation.getDesiredState() == State.DELETED) {
            throw new IllegalConfigurationException("Directly deleting a redirecting virtualhost is not supported. Delete the parent virtual host node '" + (VirtualHostNode)this.getParent() + "' instead.");
        }
        throw new IllegalConfigurationException("A redirecting virtualhost does not support changing of its attributes");
    }

    @Override
    public String getRedirectHost(AmqpPort<?> port) {
        return ((RedirectingVirtualHostNode)((VirtualHostNode)this.getParent())).getRedirects().get(port);
    }
}

