/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.MessageCreditUnit;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;

public final class MessageFlow
extends Method {
    public static final int TYPE = 1034;
    private short packing_flags = 0;
    private String destination;
    private MessageCreditUnit unit;
    private long value;

    @Override
    public final int getStructType() {
        return 1034;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public MessageFlow() {
    }

    public MessageFlow(String destination, MessageCreditUnit unit, long value, Option ... _options) {
        if (destination != null) {
            this.setDestination(destination);
        }
        if (unit != null) {
            this.setUnit(unit);
        }
        this.setValue(value);
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + _options[i]);
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.messageFlow(context, this);
    }

    public final boolean hasDestination() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final MessageFlow clearDestination() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.destination = null;
        this.setDirty(true);
        return this;
    }

    public final String getDestination() {
        return this.destination;
    }

    public final MessageFlow setDestination(String value) {
        this.destination = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final MessageFlow destination(String value) {
        return this.setDestination(value);
    }

    public final boolean hasUnit() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final MessageFlow clearUnit() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.unit = null;
        this.setDirty(true);
        return this;
    }

    public final MessageCreditUnit getUnit() {
        return this.unit;
    }

    public final MessageFlow setUnit(MessageCreditUnit value) {
        this.unit = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final MessageFlow unit(MessageCreditUnit value) {
        return this.setUnit(value);
    }

    public final boolean hasValue() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final MessageFlow clearValue() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.value = 0L;
        this.setDirty(true);
        return this;
    }

    public final long getValue() {
        return this.value;
    }

    public final MessageFlow setValue(long value) {
        this.value = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.setDirty(true);
        return this;
    }

    public final MessageFlow value(long value) {
        return this.setValue(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.destination);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeUint8(this.unit.getValue());
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeUint32(this.value);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.destination = dec.readStr8();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.unit = MessageCreditUnit.get(dec.readUint8());
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.value = dec.readUint32();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("destination", this.getDestination());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("unit", (Object)this.getUnit());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("value", this.getValue());
        }
        return result;
    }
}

