/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.config;

import java.util.Optional;
import org.apache.qpid.server.user.connection.limits.config.CombinableLimit;
import org.apache.qpid.server.user.connection.limits.config.ConnectionLimitsImpl;
import org.apache.qpid.server.user.connection.limits.config.Rule;

@FunctionalInterface
public interface ConnectionCountLimit
extends CombinableLimit<ConnectionCountLimit> {
    public Integer getCountLimit();

    default public boolean isUserBlocked() {
        return false;
    }

    @Override
    default public boolean isEmpty() {
        return this.getCountLimit() == null;
    }

    @Override
    default public ConnectionCountLimit then(ConnectionCountLimit other) {
        if (other != null && this.isEmpty()) {
            return other;
        }
        return this;
    }

    @Override
    default public ConnectionCountLimit mergeWith(ConnectionCountLimit second) {
        if (second == null || this.isUserBlocked()) {
            return this;
        }
        if (second.isUserBlocked()) {
            return second;
        }
        Integer counter = ConnectionLimitsImpl.min(this.getCountLimit(), second.getCountLimit());
        return () -> counter;
    }

    public static ConnectionCountLimit newInstance(Rule rule) {
        if (rule.isUserBlocked()) {
            return ConnectionCountLimit.blockedUser();
        }
        if (rule.getCountLimit() == null) {
            return ConnectionCountLimit.noLimits();
        }
        Integer counterLimit = rule.getCountLimit();
        return () -> counterLimit;
    }

    public static ConnectionCountLimit noLimits() {
        return NoLimits.INSTANCE;
    }

    public static ConnectionCountLimit blockedUser() {
        return Blocked.INSTANCE;
    }

    public static final class Blocked
    implements ConnectionCountLimit {
        static final Blocked INSTANCE = new Blocked();

        private Blocked() {
        }

        @Override
        public Integer getCountLimit() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isUserBlocked() {
            return true;
        }

        @Override
        public ConnectionCountLimit then(ConnectionCountLimit other) {
            return this;
        }

        @Override
        public ConnectionCountLimit mergeWith(ConnectionCountLimit second) {
            return this;
        }
    }

    public static final class NoLimits
    implements ConnectionCountLimit {
        static final NoLimits INSTANCE = new NoLimits();

        private NoLimits() {
        }

        @Override
        public Integer getCountLimit() {
            return null;
        }

        @Override
        public boolean isUserBlocked() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public ConnectionCountLimit mergeWith(ConnectionCountLimit second) {
            return Optional.ofNullable(second).orElse(this);
        }

        @Override
        public ConnectionCountLimit then(ConnectionCountLimit other) {
            return Optional.ofNullable(other).orElse(this);
        }
    }
}

