/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.rat.Defaults;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.config.ConfigurationUtil;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.license.ILicenseFamily;

public class DefaultPolicy
implements IDocumentAnalyser {
    private List<String> approvedLicenseNames = new ArrayList<String>();

    DefaultPolicy() {
        this(new ArrayList<String>(0), true);
    }

    public DefaultPolicy(ILicenseFamily[] approvedLicenses, boolean mergeWithDefault) {
        this(ConfigurationUtil.toNames(approvedLicenses), mergeWithDefault);
    }

    public DefaultPolicy(List<String> approvedLicenseNames, boolean mergeWithDefault) {
        if (approvedLicenseNames == null || approvedLicenseNames.isEmpty()) {
            if (mergeWithDefault) {
                this.approvedLicenseNames = new ArrayList<String>(Defaults.DEFAULT_LICENSE_FAMILIES);
            }
        } else {
            HashSet<String> mergedLicenses = new HashSet<String>(approvedLicenseNames);
            if (mergeWithDefault) {
                mergedLicenses.addAll(Defaults.DEFAULT_LICENSE_FAMILIES);
            }
            this.approvedLicenseNames = new ArrayList<String>(mergedLicenses);
        }
        Collections.sort(this.approvedLicenseNames);
    }

    @Override
    public void analyse(Document subject) throws RatDocumentAnalysisException {
        String name;
        if (subject != null && (name = subject.getMetaData().value("http://org/apache/rat/meta-data#LicenseFamilyName")) != null) {
            boolean isApproved = Collections.binarySearch(this.approvedLicenseNames, name) >= 0;
            this.reportLicenseApprovalClaim(subject, isApproved);
        }
    }

    public void reportLicenseApprovalClaim(Document subject, boolean isAcceptable) {
        subject.getMetaData().set(isAcceptable ? MetaData.RAT_APPROVED_LICENSE_DATIM_TRUE : MetaData.RAT_APPROVED_LICENSE_DATIM_FALSE);
    }

    public List<String> getApprovedLicenseNames() {
        return Collections.unmodifiableList(this.approvedLicenseNames);
    }
}

