/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.function.IOSupplier;
import org.apache.rat.configuration.Format;
import org.apache.rat.configuration.LicenseReader;
import org.apache.rat.configuration.MatcherReader;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseSetFactory;

public class Defaults {
    private static final URL DEFAULT_CONFIG_URL = Defaults.class.getResource("/org/apache/rat/default.xml");
    public static final String PLAIN_STYLESHEET = "org/apache/rat/plain-rat.xsl";
    public static final String UNAPPROVED_LICENSES_STYLESHEET = "org/apache/rat/unapproved-licenses.xsl";
    private final LicenseSetFactory setFactory;

    public static void init() {
        Format fmt = Format.fromURL(DEFAULT_CONFIG_URL);
        MatcherReader mReader = fmt.matcherReader();
        mReader.addMatchers(DEFAULT_CONFIG_URL);
        mReader.readMatcherBuilders();
    }

    private Defaults(Set<URL> urls) {
        this.setFactory = Defaults.readConfigFiles(urls);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static LicenseSetFactory readConfigFiles(Collection<URL> urls) {
        SortedSet<ILicense> licenses = LicenseSetFactory.emptyLicenseSet();
        TreeSet<String> approvedLicenseIds = new TreeSet<String>();
        for (URL url : urls) {
            LicenseReader lReader;
            Format fmt = Format.fromURL(url);
            MatcherReader mReader = fmt.matcherReader();
            if (mReader != null) {
                mReader.addMatchers(url);
                mReader.readMatcherBuilders();
            }
            if ((lReader = fmt.licenseReader()) == null) continue;
            lReader.addLicenses(url);
            licenses.addAll(lReader.readLicenses());
            lReader.approvedLicenseId().stream().map(ILicenseFamily::makeCategory).forEach(approvedLicenseIds::add);
        }
        return new LicenseSetFactory(licenses, approvedLicenseIds);
    }

    public static IOSupplier<InputStream> getPlainStyleSheet() {
        return () -> Defaults.class.getClassLoader().getResourceAsStream(PLAIN_STYLESHEET);
    }

    public static IOSupplier<InputStream> getUnapprovedLicensesStyleSheet() {
        return () -> Defaults.class.getClassLoader().getResourceAsStream(UNAPPROVED_LICENSES_STYLESHEET);
    }

    public SortedSet<ILicense> getLicenses(LicenseSetFactory.LicenseFilter filter) {
        return this.setFactory.getLicenses(filter);
    }

    public SortedSet<ILicenseFamily> getLicenseFamilies(LicenseSetFactory.LicenseFilter filter) {
        return this.setFactory.getLicenseFamilies(filter);
    }

    public SortedSet<String> getLicenseIds(LicenseSetFactory.LicenseFilter filter) {
        return this.setFactory.getLicenseFamilyIds(filter);
    }

    public static class Builder {
        private final Set<URL> fileNames = new TreeSet<URL>(Comparator.comparing(URL::toString));

        private Builder() {
            this.fileNames.add(DEFAULT_CONFIG_URL);
        }

        public Builder add(URL url) {
            this.fileNames.add(url);
            return this;
        }

        public Builder add(String fileName) throws MalformedURLException {
            return this.add(new File(fileName));
        }

        public Builder add(File file) throws MalformedURLException {
            return this.add(file.toURI().toURL());
        }

        public Builder remove(URL url) {
            this.fileNames.remove(url);
            return this;
        }

        public Builder remove(String fileName) throws MalformedURLException {
            return this.remove(new File(fileName));
        }

        public Builder remove(File file) throws MalformedURLException {
            return this.remove(file.toURI().toURL());
        }

        public Builder noDefault() {
            return this.remove(DEFAULT_CONFIG_URL);
        }

        public Defaults build() {
            return new Defaults(this.fileNames);
        }
    }
}

