/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.function.IOSupplier;
import org.apache.rat.ConfigurationException;
import org.apache.rat.Defaults;
import org.apache.rat.config.AddLicenseHeaders;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseFamilySetFactory;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.report.IReportable;
import org.apache.rat.utils.Log;
import org.apache.rat.utils.ReportingSet;
import org.apache.rat.walker.NameBasedHiddenFileFilter;

public class ReportConfiguration {
    private final ReportingSet<ILicenseFamily> families;
    private final ReportingSet<ILicense> licenses;
    private final SortedSet<String> approvedLicenseCategories;
    private final SortedSet<String> removedLicenseCategories;
    private boolean addingLicenses;
    private boolean addingLicensesForced;
    private String copyrightMessage;
    private IOSupplier<OutputStream> out;
    private boolean styleReport;
    private IOSupplier<InputStream> styleSheet;
    private IReportable reportable;
    private FilenameFilter inputFileFilter;
    private IOFileFilter directoryFilter;
    private Log log;

    public ReportConfiguration(Log log) {
        this.log = log;
        this.families = new ReportingSet<ILicenseFamily>(LicenseFamilySetFactory.emptyLicenseFamilySet()).setLog(log).setMsgFormat(s -> String.format("Duplicate LicenseFamily category: %s", s.getFamilyCategory()));
        this.licenses = new ReportingSet<ILicense>(LicenseSetFactory.emptyLicenseSet()).setLog(log).setMsgFormat(s -> String.format("Duplicate License %s (%s) of type %s", s.getName(), s.getId(), s.getLicenseFamily().getFamilyCategory()));
        this.approvedLicenseCategories = new TreeSet<String>();
        this.removedLicenseCategories = new TreeSet<String>();
        this.directoryFilter = NameBasedHiddenFileFilter.HIDDEN;
        this.styleReport = true;
    }

    public Log getLog() {
        return this.log;
    }

    public void logFamilyCollisions(Log.Level level) {
        this.families.setLogLevel(level);
    }

    public void familyDuplicateOption(ReportingSet.Options state) {
        this.families.setDuplicateOption(state);
    }

    public void logLicenseCollisions(Log.Level level) {
        this.licenses.setLogLevel(level);
    }

    public void licenseDuplicateOption(ReportingSet.Options state) {
        this.licenses.setDuplicateOption(state);
    }

    public FilenameFilter getInputFileFilter() {
        return this.inputFileFilter;
    }

    public void setInputFileFilter(FilenameFilter inputFileFilter) {
        this.inputFileFilter = inputFileFilter;
    }

    public IOFileFilter getDirectoryFilter() {
        return this.directoryFilter;
    }

    public void setDirectoryFilter(IOFileFilter directoryFilter) {
        this.directoryFilter = directoryFilter == null ? FalseFileFilter.FALSE : directoryFilter;
    }

    public void addDirectoryFilter(IOFileFilter directoryFilter) {
        this.directoryFilter = this.directoryFilter.and(directoryFilter);
    }

    public IReportable getReportable() {
        return this.reportable;
    }

    public void setReportable(IReportable reportable) {
        this.reportable = reportable;
    }

    public IOSupplier<InputStream> getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(IOSupplier<InputStream> styleSheet) {
        this.styleSheet = styleSheet;
    }

    public void setFrom(Defaults defaults) {
        this.addLicensesIfNotPresent(defaults.getLicenses(LicenseSetFactory.LicenseFilter.all));
        this.addApprovedLicenseCategories(defaults.getLicenseIds(LicenseSetFactory.LicenseFilter.approved));
        if (this.isStyleReport() && this.getStyleSheet() == null) {
            this.setStyleSheet(Defaults.getPlainStyleSheet());
        }
    }

    public void setStyleSheet(File styleSheet) {
        Objects.requireNonNull(styleSheet, "styleSheet file should not be null");
        this.setStyleSheet(styleSheet.toURI());
    }

    public void setStyleSheet(URI styleSheet) {
        Objects.requireNonNull(styleSheet, "styleSheet file should not be null");
        try {
            this.setStyleSheet(styleSheet.toURL());
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Unable to process stylesheet", e);
        }
    }

    public void setStyleSheet(URL styleSheet) {
        Objects.requireNonNull(styleSheet, "styleSheet file should not be null");
        this.setStyleSheet((IOSupplier<InputStream>)((IOSupplier)styleSheet::openStream));
    }

    public boolean isStyleReport() {
        return this.styleReport;
    }

    public void setStyleReport(boolean styleReport) {
        this.styleReport = styleReport;
    }

    public void setOut(IOSupplier<OutputStream> out) {
        this.out = out;
    }

    public void setOut(File file) {
        Objects.requireNonNull(file, "output file should not be null");
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                this.log.warn("Unable to delete file:" + file);
            }
        }
        this.setOut((IOSupplier<OutputStream>)((IOSupplier)() -> new FileOutputStream(file, true)));
    }

    public IOSupplier<OutputStream> getOutput() {
        return this.out == null ? () -> new NoCloseOutputStream(System.out) : this.out;
    }

    public IOSupplier<PrintWriter> getWriter() {
        return () -> new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutput().get(), StandardCharsets.UTF_8));
    }

    public void addLicense(ILicense license) {
        if (license != null) {
            this.licenses.add(license);
            this.families.addIfNotPresent(license.getLicenseFamily());
        }
    }

    public ILicense addLicense(ILicense.Builder builder) {
        if (builder != null) {
            ILicense license = builder.build(this.families);
            this.licenses.add(license);
            return license;
        }
        return null;
    }

    public void addLicenses(Collection<ILicense> licenses) {
        this.licenses.addAll(licenses);
        licenses.stream().map(ILicense::getLicenseFamily).forEach(this.families::add);
    }

    public void addLicensesIfNotPresent(Collection<ILicense> licenses) {
        this.licenses.addAllIfNotPresent(licenses);
        licenses.stream().map(ILicense::getLicenseFamily).forEach(this.families::addIfNotPresent);
    }

    public void addFamily(ILicenseFamily family) {
        if (family != null) {
            this.families.add(family);
        }
    }

    public void addFamily(ILicenseFamily.Builder builder) {
        if (builder != null) {
            this.families.add(builder.build());
        }
    }

    public void addFamilies(Collection<ILicenseFamily> families) {
        this.families.addAll(families);
    }

    public void addApprovedLicenseCategory(ILicenseFamily approvedILicenseFamily) {
        this.approvedLicenseCategories.add(approvedILicenseFamily.getFamilyCategory());
    }

    public void addApprovedLicenseCategory(String familyCategory) {
        this.approvedLicenseCategories.add(ILicenseFamily.makeCategory(familyCategory));
    }

    public void addApprovedLicenseCategories(Collection<String> approvedLicenseCategories) {
        approvedLicenseCategories.forEach(this::addApprovedLicenseCategory);
    }

    public void removeApprovedLicenseCategory(String familyCategory) {
        this.removedLicenseCategories.add(ILicenseFamily.makeCategory(familyCategory));
    }

    public void removeApprovedLicenseCategories(Collection<String> familyCategory) {
        familyCategory.forEach(this::removeApprovedLicenseCategory);
    }

    public SortedSet<String> getApprovedLicenseCategories() {
        TreeSet<String> result = new TreeSet<String>(this.approvedLicenseCategories);
        result.removeAll(this.removedLicenseCategories);
        return result;
    }

    public String getCopyrightMessage() {
        return this.copyrightMessage;
    }

    public void setCopyrightMessage(String copyrightMessage) {
        this.copyrightMessage = copyrightMessage;
    }

    public boolean isAddingLicensesForced() {
        return this.addingLicensesForced;
    }

    public boolean isAddingLicenses() {
        return this.addingLicenses;
    }

    public void setAddLicenseHeaders(AddLicenseHeaders addLicenseHeaders) {
        this.addingLicenses = false;
        this.addingLicensesForced = false;
        switch (addLicenseHeaders) {
            case FALSE: {
                break;
            }
            case FORCED: {
                this.addingLicensesForced = true;
            }
            case TRUE: {
                this.addingLicenses = true;
            }
        }
    }

    public SortedSet<ILicense> getLicenses(LicenseSetFactory.LicenseFilter filter) {
        switch (filter) {
            case all: {
                return Collections.unmodifiableSortedSet(this.licenses);
            }
            case approved: {
                return new LicenseSetFactory(this.licenses, this.getApprovedLicenseCategories()).getLicenses(filter);
            }
        }
        return LicenseSetFactory.emptyLicenseSet();
    }

    public SortedSet<ILicenseFamily> getLicenseFamilies(LicenseSetFactory.LicenseFilter filter) {
        return new LicenseFamilySetFactory(this.families, this.getApprovedLicenseCategories()).getFamilies(filter);
    }

    public void validate(Consumer<String> logger) {
        if (this.reportable == null) {
            throw new ConfigurationException("Reportable may not be null");
        }
        if (this.licenses.isEmpty()) {
            throw new ConfigurationException("You must specify at least one license");
        }
        if (this.styleSheet != null && !this.isStyleReport()) {
            logger.accept("Ignoring stylesheet because styling is not selected");
        }
        if (this.styleSheet == null && this.isStyleReport()) {
            throw new ConfigurationException("Stylesheet must be specified if report styling is selected");
        }
    }

    public static class NoCloseOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        public NoCloseOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int arg0) throws IOException {
            this.delegate.write(arg0);
        }

        @Override
        public void close() throws IOException {
            this.delegate.flush();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void write(byte[] arg0, int arg1, int arg2) throws IOException {
            this.delegate.write(arg0, arg1, arg2);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }
    }
}

