/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.api.RatException;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.claim.ClaimStatistic;
import org.apache.rat.report.xml.XmlReportFactory;
import org.apache.rat.report.xml.writer.impl.base.XmlWriter;

public class Reporter {
    private static final String LICENSE_FAMILY_FORMAT = "\t%s: %s\n";
    private static final String LICENSE_FORMAT = "%s:\t%s\n\t\t%s\n";

    private Reporter() {
    }

    /*
     * Exception decompiling
     */
    public static ClaimStatistic report(ReportConfiguration configuration) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ClaimStatistic report(Writer outputWriter, ReportConfiguration configuration) throws IOException, RatException {
        ClaimStatistic claimStatistic;
        XmlWriter writer = new XmlWriter(outputWriter);
        try {
            ClaimStatistic statistic = new ClaimStatistic();
            RatReport report = XmlReportFactory.createStandardReport(writer, statistic, configuration);
            report.startReport();
            configuration.getReportable().run(report);
            report.endReport();
            claimStatistic = statistic;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        writer.close();
        return claimStatistic;
    }

    public static void listLicenseFamilies(ReportConfiguration configuration, LicenseSetFactory.LicenseFilter filter) throws IOException {
        try (PrintWriter pw = (PrintWriter)configuration.getWriter().get();){
            pw.format("Families (%s):%n", new Object[]{filter});
            configuration.getLicenseFamilies(filter).forEach(x -> pw.format(LICENSE_FAMILY_FORMAT, x.getFamilyCategory(), x.getFamilyName()));
            pw.println();
        }
    }

    public static void listLicenses(ReportConfiguration configuration, LicenseSetFactory.LicenseFilter filter) throws IOException {
        try (PrintWriter pw = (PrintWriter)configuration.getWriter().get();){
            pw.format("Licenses (%s):%n", new Object[]{filter});
            configuration.getLicenses(filter).forEach(lic -> pw.format(LICENSE_FORMAT, lic.getLicenseFamily().getFamilyCategory(), lic.getLicenseFamily().getFamilyName(), lic.getNotes()));
            pw.println();
        }
    }
}

