/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.Defaults;
import org.apache.rat.configuration.builders.AbstractBuilder;

public class MatcherBuilderTracker {
    private static MatcherBuilderTracker INSTANCE;
    private final Map<String, Class<? extends AbstractBuilder>> matcherBuilders = new HashMap<String, Class<? extends AbstractBuilder>>();

    private static synchronized MatcherBuilderTracker instance() {
        if (INSTANCE == null) {
            INSTANCE = new MatcherBuilderTracker();
            Defaults.init();
        }
        return INSTANCE;
    }

    public static void addBuilder(String className, String name) {
        MatcherBuilderTracker.instance().addBuilderImpl(className, name);
    }

    public static AbstractBuilder getMatcherBuilder(String name) {
        Class<? extends AbstractBuilder> clazz = MatcherBuilderTracker.instance().matcherBuilders.get(name);
        if (clazz == null) {
            StringBuilder sb = new StringBuilder("\nValid builders\n");
            MatcherBuilderTracker.instance().matcherBuilders.keySet().forEach(x -> sb.append((String)x).append("\n"));
            sb.append("ERROR MSG\n");
            throw new ConfigurationException(sb.append("No matcher builder named ").append(name).toString());
        }
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ConfigurationException(String.format("Can not instantiate matcher builder named %s (%s)", name, clazz.getName()), e);
        }
    }

    private MatcherBuilderTracker() {
    }

    private void addBuilderImpl(String className, String name) {
        Class<?> candidate;
        Class<?> clazz;
        Objects.requireNonNull(className, "className may not be null");
        try {
            clazz = this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(e);
        }
        if (AbstractBuilder.class.isAssignableFrom(clazz)) {
            candidate = clazz;
            if (StringUtils.isBlank((CharSequence)name)) {
                name = candidate.getSimpleName();
                if (!name.endsWith("Builder")) {
                    throw new ConfigurationException("name is required, or " + candidate.getName() + " must end with 'Builder'");
                }
                if (StringUtils.isBlank((CharSequence)(name = name.substring(0, name.lastIndexOf("Builder"))))) {
                    throw new ConfigurationException("Last segment of " + candidate.getName() + " may not be 'Builder', but must end in 'Builder'");
                }
                name = name.replaceFirst(".", StringUtils.lowerCase((String)name.substring(0, 1)));
            }
        } else {
            throw new ConfigurationException("Class " + clazz.getName() + " does not extend " + AbstractBuilder.class);
        }
        this.matcherBuilders.put(name, candidate);
    }
}

