/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration.builders;

import java.util.regex.Pattern;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.matchers.SimpleRegexMatcher;
import org.apache.rat.configuration.builders.AbstractBuilder;

public class RegexBuilder
extends AbstractBuilder {
    private Pattern pattern;

    public RegexBuilder setExpr(String exp) {
        this.pattern = exp == null ? null : Pattern.compile(exp);
        return this;
    }

    @Override
    public IHeaderMatcher build() {
        if (null == this.pattern) {
            throw new ConfigurationException("'regex' type matcher requires an expression");
        }
        return new SimpleRegexMatcher(this.pattern);
    }

    @Override
    public String toString() {
        return String.format("RegexBuilder: %s", this.pattern == null ? null : this.pattern.pattern());
    }
}

