/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion.fileProcessors;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.config.exclusion.MatcherSet;
import org.apache.rat.config.exclusion.plexus.MatchPatterns;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;

public abstract class AbstractFileProcessorBuilder {
    protected static final String REGEX_FMT = "%%regex[%s]";
    protected final String fileName;
    protected final Predicate<String> commentFilter;
    private final SortedMap<Integer, LevelBuilder> levelBuilders = new TreeMap<Integer, LevelBuilder>();
    private final boolean includeProcessorFile;

    protected AbstractFileProcessorBuilder(String fileName, Iterable<String> commentPrefixes, boolean includeProcessorFile) {
        this(fileName, commentPrefixes == null ? StringUtils::isNotBlank : ExclusionUtils.commentFilter(commentPrefixes), includeProcessorFile);
    }

    protected AbstractFileProcessorBuilder(String fileName, String commentPrefix, boolean includeProcessorFile) {
        this(fileName, commentPrefix == null ? null : Collections.singletonList(commentPrefix), includeProcessorFile);
    }

    protected AbstractFileProcessorBuilder(String fileName, Predicate<String> commentFilter, boolean includeProcessorFile) {
        this.fileName = fileName;
        this.commentFilter = commentFilter;
        this.includeProcessorFile = includeProcessorFile;
    }

    private List<MatcherSet> createMatcherSetList() {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.levelBuilders.keySet());
        keys.sort((a, b) -> Integer.compare(b, a));
        return keys.stream().map(key -> ((LevelBuilder)this.levelBuilders.get(key)).asMatcherSet()).collect(Collectors.toList());
    }

    public final List<MatcherSet> build(DocumentName root) {
        if (this.includeProcessorFile) {
            String name = String.format("**/%s", this.fileName);
            String pattern = ExclusionUtils.qualifyPattern(root, name);
            MatcherSet matcherSet = new MatcherSet.Builder().addExcluded(new DocumentNameMatcher(name, MatchPatterns.from(root.getDirectorySeparator(), Collections.singletonList(pattern)), root)).build();
            LevelBuilder levelBuilder = this.levelBuilders.computeIfAbsent(0, k -> new LevelBuilder());
            levelBuilder.add(matcherSet);
        }
        this.checkDirectory(0, root, root, (FileFilter)new NameFileFilter(this.fileName));
        List<MatcherSet> result = this.levelBuilders.size() == 1 ? Collections.singletonList(((LevelBuilder)this.levelBuilders.get(0)).asMatcherSet()) : this.createMatcherSetList();
        this.levelBuilders.clear();
        return result;
    }

    protected MatcherSet process(Consumer<MatcherSet> matcherSetConsumer, DocumentName root, DocumentName documentName) {
        MatcherSet.Builder matcherSetBuilder = new MatcherSet.Builder();
        ArrayList<String> iterable = new ArrayList<String>();
        ExclusionUtils.asIterator(documentName.asFile(), this.commentFilter).map(entry -> this.modifyEntry(matcherSetConsumer, documentName, (String)entry).orElse(null)).filter(Objects::nonNull).map(entry -> ExclusionUtils.qualifyPattern(documentName, entry)).forEachRemaining(iterable::add);
        HashSet<String> included = new HashSet<String>();
        HashSet<String> excluded = new HashSet<String>();
        MatcherSet.Builder.segregateList(excluded, included, iterable);
        DocumentName displayName = DocumentName.builder(root).setName(documentName.getName()).build();
        matcherSetBuilder.addExcluded(displayName, excluded);
        matcherSetBuilder.addIncluded(displayName, included);
        return matcherSetBuilder.build();
    }

    private void checkDirectory(int level, DocumentName root, DocumentName directory, FileFilter fileFilter) {
        File dirFile = directory.asFile();
        for (File file : this.listFiles(dirFile, fileFilter)) {
            LevelBuilder levelBuilder = this.levelBuilders.computeIfAbsent(level, k -> new LevelBuilder());
            levelBuilder.add(this.process(levelBuilder::add, root, DocumentName.builder(file).build()));
        }
        for (File dir : this.listFiles(dirFile, (FileFilter)DirectoryFileFilter.DIRECTORY)) {
            this.checkDirectory(level + 1, root, DocumentName.builder(dir).setBaseName(directory.getBaseName()).build(), fileFilter);
        }
    }

    protected Optional<String> modifyEntry(Consumer<MatcherSet> matcherSetConsumer, DocumentName documentName, String entry) {
        return Optional.of(entry);
    }

    protected File[] listFiles(File dir, FileFilter filter) {
        File[] result = dir.listFiles(filter);
        return result == null ? new File[]{} : result;
    }

    protected LevelBuilder getLevelBuilder(int level) {
        return this.levelBuilders.computeIfAbsent(level, k -> new LevelBuilder());
    }

    protected static final class LevelBuilder {
        private final MatcherSet.Builder builder = new MatcherSet.Builder();

        protected LevelBuilder() {
        }

        public void add(MatcherSet matcherSet) {
            matcherSet.includes().ifPresent(this.builder::addIncluded);
            matcherSet.excludes().ifPresent(this.builder::addExcluded);
        }

        public MatcherSet asMatcherSet() {
            return this.builder.build();
        }
    }
}

