/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ImplementationException;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.api.RatException;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.Description;
import org.apache.rat.configuration.MatcherBuilderTracker;
import org.apache.rat.configuration.XMLConfig;
import org.apache.rat.configuration.builders.AbstractBuilder;
import org.apache.rat.configuration.builders.MatcherRefBuilder;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.report.xml.writer.IXmlWriter;
import org.apache.rat.report.xml.writer.XmlWriter;

public class XMLConfigurationWriter {
    private final ReportConfiguration configuration;
    private final Set<String> matchers;
    private final Set<String> licenseChildren;

    public XMLConfigurationWriter(ReportConfiguration configuration) {
        this.configuration = configuration;
        this.matchers = new HashSet<String>();
        this.licenseChildren = new HashSet<String>(Arrays.asList(XMLConfig.LICENSE_CHILDREN));
    }

    private Predicate<Description> attributeFilter(Description parent) {
        return d -> {
            if (d.getType() == ComponentType.PARAMETER) {
                switch (parent.getType()) {
                    case MATCHER: {
                        return !XMLConfig.isInlineNode(parent.getCommonName(), d.getCommonName());
                    }
                    case LICENSE: {
                        return !this.licenseChildren.contains(d.getCommonName());
                    }
                }
                return true;
            }
            return false;
        };
    }

    public void write(Writer plainWriter) throws RatException {
        this.write(new XmlWriter(plainWriter));
    }

    public void write(IXmlWriter writer) throws RatException {
        if (this.configuration.listFamilies() != LicenseSetFactory.LicenseFilter.NONE || this.configuration.listLicenses() != LicenseSetFactory.LicenseFilter.NONE) {
            try {
                SortedSet<ILicense> licenses;
                writer.openElement("rat-config");
                SortedSet<ILicenseFamily> families = this.configuration.getLicenseFamilies(this.configuration.listFamilies());
                if (!families.isEmpty()) {
                    writer.openElement("families");
                    for (ILicenseFamily iLicenseFamily : families) {
                        this.writeFamily(writer, iLicenseFamily);
                    }
                    writer.closeElement();
                }
                if (!(licenses = this.configuration.getLicenses(this.configuration.listLicenses())).isEmpty()) {
                    writer.openElement("licenses");
                    for (ILicense license : licenses) {
                        this.writeDescription(writer, license.getDescription(), license);
                    }
                    writer.closeElement();
                }
                writer.openElement("approved");
                for (String family : this.configuration.getLicenseCategories(LicenseSetFactory.LicenseFilter.APPROVED)) {
                    writer.openElement("approved").attribute("license_ref", family.trim()).closeElement();
                }
                writer.closeElement();
                MatcherBuilderTracker matcherBuilderTracker = MatcherBuilderTracker.instance();
                writer.openElement("matchers");
                for (Class<? extends AbstractBuilder> clazz : matcherBuilderTracker.getClasses()) {
                    writer.openElement("matcher").attribute("class", clazz.getCanonicalName()).closeElement();
                }
                writer.closeElement();
                writer.closeElement();
            }
            catch (IOException e) {
                throw new RatException(e);
            }
        }
    }

    private void writeFamily(IXmlWriter writer, ILicenseFamily family) throws RatException {
        try {
            writer.openElement("family").attribute("id", family.getFamilyCategory().trim()).attribute("name", family.getFamilyName());
            writer.closeElement();
        }
        catch (IOException e) {
            throw new RatException(e);
        }
    }

    private void writeDescriptions(IXmlWriter writer, Collection<Description> descriptions, IHeaderMatcher component) throws RatException {
        for (Description description : descriptions) {
            this.writeDescription(writer, description, component);
        }
    }

    private void writeChildren(IXmlWriter writer, Description description, IHeaderMatcher component) throws RatException {
        this.writeAttributes(writer, description.filterChildren(this.attributeFilter(component.getDescription())), component);
        this.writeDescriptions(writer, description.filterChildren(this.attributeFilter(component.getDescription()).negate()), component);
    }

    private void writeAttributes(IXmlWriter writer, Collection<Description> descriptions, IHeaderMatcher component) throws RatException {
        for (Description d : descriptions) {
            try {
                this.writeAttribute(writer, d, component);
            }
            catch (IOException e) {
                throw new RatException(e);
            }
        }
    }

    private void writeComment(IXmlWriter writer, Description description) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)description.getDescription())) {
            writer.comment(description.getDescription().replace("-->", "-&ndash;>"));
        }
    }

    private void writeAttribute(IXmlWriter writer, Description description, IHeaderMatcher component) throws IOException {
        String paramValue = description.getParamValue(component);
        if (paramValue != null) {
            writer.attribute(description.getCommonName(), paramValue);
        }
    }

    /*
     * Unable to fully structure code
     */
    void writeDescription(IXmlWriter writer, Description desc, IHeaderMatcher comp) throws RatException {
        description = desc;
        component = comp;
        try {
            switch (1.$SwitchMap$org$apache$rat$config$parameters$ComponentType[description.getType().ordinal()]) {
                case 1: {
                    id = description.childrenOfType(ComponentType.PARAMETER).stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$writeDescription$1(org.apache.rat.config.parameters.Description ), (Lorg/apache/rat/config/parameters/Description;)Z)()).findFirst();
                    if (!id.isPresent()) ** GOTO lbl25
                    matcherId = id.get().getParamValue(component);
                    if (this.matchers.contains(matcherId)) {
                        component = new MatcherRefBuilder.IHeaderMatcherProxy(matcherId, null);
                        description = component.getDescription();
                    } else {
                        this.matchers.add(matcherId);
                    }
                    try {
                        UUID.fromString(matcherId);
                        description.getChildren().remove("id");
                    }
                    catch (IllegalArgumentException expected) {
                        if (!description.getCommonName().equals("spdx")) ** GOTO lbl25
                        description.getChildren().remove("id");
                    }
lbl25:
                    // 4 sources

                    if ((resource = description.childrenOfType(ComponentType.PARAMETER).stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$writeDescription$2(org.apache.rat.config.parameters.Description ), (Lorg/apache/rat/config/parameters/Description;)Z)()).findFirst()).isPresent() && StringUtils.isNotBlank((CharSequence)(resourceStr = resource.get().getParamValue(component)))) {
                        description.getChildren().remove("enclosed");
                    }
                    this.writeComment(writer, description);
                    writer.openElement(description.getCommonName());
                    this.writeChildren(writer, description, component);
                    writer.closeElement();
                    break;
                }
                case 2: {
                    writer.openElement("license");
                    this.writeChildren(writer, description, component);
                    writer.closeElement();
                    break;
                }
                case 3: {
                    if ("id".equals(description.getCommonName())) {
                        try {
                            paramId = description.getParamValue(component);
                            if (paramId != null) {
                                UUID.fromString(paramId);
                                return;
                            }
                        }
                        catch (IllegalArgumentException paramId) {
                            // empty catch block
                        }
                    }
                    if (description.getChildType() == String.class) {
                        inline = XMLConfig.isInlineNode(component.getDescription().getCommonName(), description.getCommonName());
                        s = description.getParamValue(component);
                        if (StringUtils.isNotBlank((CharSequence)s)) {
                            if (!inline) {
                                writer.openElement(description.getCommonName());
                            }
                            writer.content(description.getParamValue(component));
                            if (!inline) {
                                writer.closeElement();
                            }
                        }
                        break;
                    }
                    try {
                        if (description.isCollection()) {
                            for (IHeaderMatcher matcher : (Collection)description.getter(component.getClass()).invoke((Object)component, new Object[0])) {
                                this.writeDescription(writer, matcher.getDescription(), matcher);
                            }
                            break;
                        }
                        matcher = (IHeaderMatcher)description.getter(component.getClass()).invoke((Object)component, new Object[0]);
                        this.writeDescription(writer, matcher.getDescription(), matcher);
                        break;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | RatException e) {
                        throw new ImplementationException(e);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RatException(e);
        }
    }

    private static /* synthetic */ boolean lambda$writeDescription$2(Description i) {
        return "resource".equals(i.getCommonName());
    }

    private static /* synthetic */ boolean lambda$writeDescription$1(Description i) {
        return "id".equals(i.getCommonName());
    }
}

