/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DocumentName
implements Comparable<DocumentName> {
    private final String name;
    private final DocumentName baseName;
    private final FSInfo fsInfo;
    private final String root;

    public static Builder builder() {
        return new Builder(FSInfo.getDefault());
    }

    public static Builder builder(FSInfo fsInfo) {
        return new Builder(fsInfo);
    }

    public static Builder builder(FileSystem fileSystem) {
        return new Builder(fileSystem);
    }

    public static Builder builder(File file) {
        return new Builder(file);
    }

    public static Builder builder(DocumentName documentName) {
        return new Builder(documentName);
    }

    DocumentName(Builder builder) {
        this.name = builder.name;
        this.fsInfo = builder.fsInfo;
        this.root = builder.root;
        this.baseName = builder.sameNameFlag ? this : builder.baseName;
    }

    public File asFile() {
        return new File(this.getName());
    }

    public Path asPath() {
        return Paths.get(this.name, new String[0]);
    }

    public DocumentName resolve(String child) {
        String pattern;
        if (StringUtils.isBlank((CharSequence)child)) {
            return this;
        }
        String separator = this.getDirectorySeparator();
        String string = pattern = separator.equals("/") ? child.replace('\\', '/') : child.replace('/', '\\');
        if (!pattern.startsWith(separator)) {
            pattern = this.name + separator + pattern;
        }
        return new Builder(this).setName(this.fsInfo.normalize(pattern)).build();
    }

    public String getName() {
        return this.root + this.fsInfo.dirSeparator() + this.name;
    }

    public String getBaseName() {
        return this.baseName.getName();
    }

    public String getRoot() {
        return this.root;
    }

    public DocumentName getBaseDocumentName() {
        return this.baseName;
    }

    public String getDirectorySeparator() {
        return this.fsInfo.dirSeparator();
    }

    boolean startsWithRootOrSeparator(String candidate, String root, String separator) {
        boolean result;
        if (StringUtils.isBlank((CharSequence)candidate)) {
            return false;
        }
        boolean bl = result = !StringUtils.isBlank((CharSequence)root) && candidate.startsWith(root);
        if (!result) {
            result = !StringUtils.isBlank((CharSequence)separator) && candidate.startsWith(separator);
        }
        return result;
    }

    public String localized() {
        String baseNameStr;
        String result = this.getName();
        if (result.startsWith(baseNameStr = this.baseName.getName())) {
            result = result.substring(baseNameStr.length());
        }
        if (!this.startsWithRootOrSeparator(result, this.getRoot(), this.fsInfo.dirSeparator())) {
            result = this.fsInfo.dirSeparator() + result;
        }
        return result;
    }

    public String localized(String dirSeparator) {
        CharSequence[] tokens = this.fsInfo.tokenize(this.localized());
        if (tokens.length == 0) {
            return dirSeparator;
        }
        if (tokens.length == 1) {
            return dirSeparator + tokens[0];
        }
        String modifiedRoot = dirSeparator.equals("/") ? this.root.replace('\\', '/') : this.root.replace('/', '\\');
        String result = String.join((CharSequence)dirSeparator, tokens);
        return this.startsWithRootOrSeparator(result, modifiedRoot, dirSeparator) ? result : dirSeparator + result;
    }

    public String getShortName() {
        int pos = this.name.lastIndexOf(this.fsInfo.dirSeparator());
        return pos == -1 ? this.name : this.name.substring(pos + 1);
    }

    public boolean isCaseSensitive() {
        return this.fsInfo.isCaseSensitive();
    }

    public String toString() {
        return this.localized();
    }

    @Override
    public int compareTo(DocumentName other) {
        return CompareToBuilder.reflectionCompare((Object)this, (Object)other);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public static class FSInfo
    implements Comparable<FSInfo> {
        private final String name;
        private final String separator;
        private final boolean isCaseSensitive;
        private final List<String> roots;

        public static FSInfo getDefault() {
            FSInfo result = (FSInfo)System.getProperties().get("FSInfo");
            return result == null ? new FSInfo("default", FileSystems.getDefault()) : result;
        }

        public FSInfo(FileSystem fileSystem) {
            this("anon", fileSystem);
        }

        public FSInfo(String name, FileSystem fileSystem) {
            this.name = name;
            this.separator = fileSystem.getSeparator();
            this.isCaseSensitive = FSInfo.isCaseSensitive(fileSystem);
            this.roots = new ArrayList<String>();
            fileSystem.getRootDirectories().forEach(r -> this.roots.add(r.toString()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private static boolean isCaseSensitive(FileSystem fileSystem) {
            boolean isCaseSensitive;
            block15: {
                isCaseSensitive = false;
                Path nameSet = null;
                Path filea = null;
                Path fileA = null;
                try {
                    block14: {
                        try {
                            Path root = fileSystem.getPath("", new String[0]);
                            nameSet = Files.createTempDirectory(root, "NameSet", new FileAttribute[0]);
                            filea = nameSet.resolve("a");
                            fileA = nameSet.resolve("A");
                            Files.createFile(filea, new FileAttribute[0]);
                            Files.createFile(fileA, new FileAttribute[0]);
                            isCaseSensitive = true;
                            if (filea == null) break block14;
                        }
                        catch (IOException iOException) {
                            if (filea != null) {
                                Files.deleteIfExists(filea);
                            }
                            if (fileA != null) {
                                Files.deleteIfExists(fileA);
                            }
                            if (nameSet != null) {
                                Files.deleteIfExists(nameSet);
                            }
                            break block15;
                            catch (Throwable throwable) {
                                if (filea != null) {
                                    Files.deleteIfExists(filea);
                                }
                                if (fileA != null) {
                                    Files.deleteIfExists(fileA);
                                }
                                if (nameSet != null) {
                                    Files.deleteIfExists(nameSet);
                                }
                                throw throwable;
                            }
                        }
                        Files.deleteIfExists(filea);
                    }
                    if (fileA != null) {
                        Files.deleteIfExists(fileA);
                    }
                    if (nameSet != null) {
                        Files.deleteIfExists(nameSet);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return isCaseSensitive;
        }

        public String toString() {
            return this.name;
        }

        FSInfo(String name, String separator, boolean isCaseSensitive, List<String> roots) {
            this.name = name;
            this.separator = separator;
            this.isCaseSensitive = isCaseSensitive;
            this.roots = new ArrayList<String>(roots);
        }

        public String dirSeparator() {
            return this.separator;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public Optional<String> rootFor(String name) {
            for (String sysRoot : this.roots) {
                if (!name.startsWith(sysRoot)) continue;
                return Optional.of(sysRoot);
            }
            return Optional.empty();
        }

        public String[] tokenize(String source) {
            return source.split("\\Q" + this.dirSeparator() + "\\E");
        }

        public String normalize(String pattern) {
            if (StringUtils.isBlank((CharSequence)pattern)) {
                return "";
            }
            ArrayList<String> parts = new ArrayList<String>(Arrays.asList(this.tokenize(pattern)));
            for (int i = 0; i < parts.size(); ++i) {
                String part = (String)parts.get(i);
                if (part.equals("..")) {
                    if (i == 0) {
                        throw new IllegalStateException("Unable to create path before root");
                    }
                    parts.set(i - 1, null);
                    parts.set(i, null);
                    continue;
                }
                if (!part.equals(".")) continue;
                parts.set(i, null);
            }
            return parts.stream().filter(Objects::nonNull).collect(Collectors.joining(this.dirSeparator()));
        }

        @Override
        public int compareTo(FSInfo other) {
            return CompareToBuilder.reflectionCompare((Object)this, (Object)other);
        }

        public boolean equals(Object other) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }
    }

    public static final class Builder {
        private String name;
        private DocumentName baseName;
        private final FSInfo fsInfo;
        private String root;
        private boolean sameNameFlag;

        private Builder(FSInfo fsInfo) {
            this.fsInfo = fsInfo;
            this.root = "";
        }

        private Builder(FileSystem fileSystem) {
            this(new FSInfo(fileSystem));
        }

        private Builder(File file) {
            this(FSInfo.getDefault());
            this.setName(file);
        }

        Builder(FSInfo fsInfo, File file) {
            this(fsInfo);
            this.setName(file);
        }

        Builder(DocumentName documentName) {
            this.root = documentName.root;
            this.name = documentName.name;
            this.baseName = documentName.baseName;
            this.fsInfo = documentName.fsInfo;
        }

        public String directorySeparator() {
            return this.fsInfo.dirSeparator();
        }

        private void verify() {
            Objects.requireNonNull(this.name, "Name must not be null");
            if (this.name.startsWith(this.fsInfo.dirSeparator())) {
                this.name = this.name.substring(this.fsInfo.dirSeparator().length());
            }
            if (!this.sameNameFlag) {
                Objects.requireNonNull(this.baseName, "Basename must not be null");
            }
        }

        public Builder setRoot(String root) {
            this.root = (String)StringUtils.defaultIfBlank((CharSequence)root, (CharSequence)"");
            return this;
        }

        public Builder setName(String name) {
            Pair<String, String> pair = this.splitRoot((String)StringUtils.defaultIfBlank((CharSequence)name, (CharSequence)""));
            if (this.root.isEmpty()) {
                this.root = (String)pair.getLeft();
            }
            this.name = this.fsInfo.normalize((String)pair.getRight());
            if (this.baseName != null && !this.baseName.name.isEmpty() && !this.name.startsWith(this.baseName.name)) {
                this.name = this.name.isEmpty() ? this.baseName.name : this.baseName.name + this.fsInfo.dirSeparator() + this.name;
            }
            return this;
        }

        Pair<String, String> splitRoot(String name) {
            String workingName = name;
            Optional<String> maybeRoot = this.fsInfo.rootFor(name);
            String root = maybeRoot.orElse("");
            if (!root.isEmpty() && workingName.startsWith(root) && !(workingName = workingName.substring(root.length())).startsWith(this.fsInfo.dirSeparator()) && root.endsWith(this.fsInfo.dirSeparator())) {
                root = root.substring(0, root.length() - this.fsInfo.dirSeparator().length());
            }
            return ImmutablePair.of((Object)root, (Object)workingName);
        }

        private void setEmptyRoot(String root) {
            if (this.root.isEmpty()) {
                this.root = root;
            }
        }

        public Builder setName(File file) {
            Pair<String, String> pair = this.splitRoot(file.getAbsolutePath());
            this.setEmptyRoot((String)pair.getLeft());
            this.name = this.fsInfo.normalize((String)pair.getRight());
            if (file.isDirectory()) {
                this.sameNameFlag = true;
            } else {
                File p = file.getParentFile();
                if (p != null) {
                    this.setBaseName(p);
                } else {
                    Builder baseBuilder = new Builder(this.fsInfo).setName(this.directorySeparator());
                    baseBuilder.sameNameFlag = true;
                    this.setBaseName(baseBuilder.build());
                }
            }
            return this;
        }

        public Builder setBaseName(String baseName) {
            Builder builder = DocumentName.builder(this.fsInfo).setName(baseName);
            builder.sameNameFlag = true;
            this.setBaseName(builder);
            return this;
        }

        public Builder setBaseName(DocumentName baseName) {
            this.baseName = baseName;
            if (!baseName.getRoot().isEmpty()) {
                this.root = baseName.getRoot();
            }
            return this;
        }

        private void setBaseName(Builder builder) {
            this.baseName = builder.build();
            this.sameNameFlag = false;
        }

        public Builder setBaseName(File file) {
            Builder builder = DocumentName.builder(this.fsInfo).setName(file);
            builder.sameNameFlag = true;
            this.setBaseName(builder);
            return this;
        }

        public DocumentName build() {
            this.verify();
            return new DocumentName(this);
        }
    }
}

