/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.help;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.Description;
import org.apache.rat.config.parameters.DescriptionBuilder;
import org.apache.rat.configuration.MatcherBuilderTracker;
import org.apache.rat.configuration.builders.AbstractBuilder;
import org.apache.rat.help.AbstractHelp;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseSetFactory;

public final class Licenses
extends AbstractHelp {
    private final ReportConfiguration config;
    private final SortedSet<ILicense> licenses;
    private final HelpFormatter formatter;
    private final PrintWriter printWriter;

    public Licenses(ReportConfiguration config, Writer writer) {
        this.config = config;
        this.licenses = config.getLicenses(LicenseSetFactory.LicenseFilter.ALL);
        this.printWriter = new PrintWriter(writer);
        this.formatter = HelpFormatter.builder().setShowDeprecated(false).setPrintWriter(this.printWriter).get();
    }

    void print(int indent, String text) {
        int leftMargin = indent * 4;
        int tabStop = leftMargin + 2;
        this.formatter.printWrapped(this.printWriter, 120, tabStop, Licenses.createPadding(leftMargin) + text);
    }

    public void printHelp() throws IOException {
        this.print(0, String.format("Listing of licenses for %s", this.versionInfo));
        this.output();
    }

    public void output() throws IOException {
        this.print(0, Licenses.header("LICENSES"));
        if (this.licenses.isEmpty()) {
            this.print(0, "No licenses defined");
        } else {
            Description licenseDescription = DescriptionBuilder.build(this.licenses.first());
            Collection<Description> licenseParams = licenseDescription.filterChildren(d -> d.getType() == ComponentType.PARAMETER);
            this.print(0, String.format("Licenses have the following properties:%n", new Object[0]));
            for (Description param : licenseParams) {
                this.print(1, String.format("%s: %s%n", param.getCommonName(), param.getDescription()));
            }
            this.print(0, String.format("%nThe defined licenses are:%n", new Object[0]));
            for (ILicense l : this.licenses) {
                this.print(0, System.lineSeparator());
                this.printObject(0, l);
            }
        }
        this.print(0, Licenses.header("DEFINED MATCHERS"));
        TreeSet<Description> matchers = new TreeSet<Description>(Comparator.comparing(Description::getCommonName));
        for (Class<? extends AbstractBuilder> mClazz : MatcherBuilderTracker.instance().getClasses()) {
            try {
                AbstractBuilder builder = mClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                matchers.add(builder.getDescription());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new ConfigurationException(String.format("Can not instantiate matcher builder  %s ", mClazz.getName()), e);
            }
        }
        for (Description description : matchers) {
            this.print(0, String.format("%n%s: %s%n", description.getCommonName(), description.getDescription()));
            for (Description child : description.getChildren().values()) {
                if (IHeaderMatcher.class.isAssignableFrom(child.getChildType())) {
                    if (child.isCollection()) {
                        this.print(2, "Encloses multiple matchers");
                        continue;
                    }
                    this.print(2, "Wraps a single matcher");
                    continue;
                }
                this.print(1, String.format("%s: %s%s", child.getCommonName(), child.isRequired() ? "(required) " : "", child.getDescription()));
            }
        }
        this.print(0, Licenses.header("DEFINED FAMILIES"));
        for (ILicenseFamily family : this.config.getLicenseFamilies(LicenseSetFactory.LicenseFilter.ALL)) {
            this.print(1, String.format("%s - %s%n", family.getFamilyCategory(), family.getFamilyName()));
        }
        this.printWriter.flush();
    }

    private void printObject(int indent, Object object) throws IOException {
        if (object == null) {
            return;
        }
        Description description = DescriptionBuilder.build(object);
        if (description == null) {
            this.print(indent, String.format("Unknown Object of class: %s%n", object.getClass().getName()));
        } else {
            this.print(indent, String.format("%s (%s)%n", description.getCommonName(), description.getDescription()));
            this.printChildren(indent + 1, object, description.getChildren());
        }
    }

    private boolean isUUID(String s) {
        try {
            UUID.fromString(s);
            return true;
        }
        catch (IllegalArgumentException expected) {
            return false;
        }
    }

    private void printChildren(int indent, Object parent, Map<String, Description> children) throws IOException {
        block9: for (Description d : children.values()) {
            switch (d.getType()) {
                case PARAMETER: {
                    if (d.isCollection()) {
                        this.print(indent, String.format("%s: %n", d.getCommonName()));
                        try {
                            Collection result = (Collection)d.getter(parent.getClass()).invoke(parent, new Object[0]);
                            for (Object o : result) {
                                this.printObject(indent + 1, o);
                            }
                            return;
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (IHeaderMatcher.class.isAssignableFrom(d.getChildType())) {
                        this.print(indent, String.format("%s: %n", d.getCommonName()));
                        try {
                            Object matcher = d.getter(parent.getClass()).invoke(parent, new Object[0]);
                            this.printObject(indent + 1, matcher);
                            break;
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    String txt = ((String)StringUtils.defaultIfBlank((CharSequence)d.getParamValue(parent), (CharSequence)"")).replaceAll("\\s{2,}", " ");
                    if (txt.isEmpty() || d.getCommonName().equals("id") && this.isUUID(txt)) continue block9;
                    this.print(indent, String.format("%s: %s%n", d.getCommonName(), txt.replaceAll("\\s{2,}", " ")));
                    break;
                }
                case BUILD_PARAMETER: 
                case LICENSE: {
                    break;
                }
                case MATCHER: {
                    this.printChildren(indent + 1, parent, d.getChildren());
                }
            }
        }
    }
}

