/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.license;

import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;

public interface ILicenseFamily
extends Comparable<ILicenseFamily> {
    public static final ILicenseFamily UNKNOWN = new Builder().setLicenseFamilyName("Unknown license").setLicenseFamilyCategory("?????").build();

    public String getFamilyName();

    public String getFamilyCategory();

    public static Builder builder() {
        return new Builder();
    }

    public static String makeCategory(String cat) {
        return cat == null ? "     " : cat.concat("     ").substring(0, 5);
    }

    @Override
    default public int compareTo(ILicenseFamily other) {
        return this.getFamilyCategory().compareTo(other.getFamilyCategory());
    }

    public static class Builder {
        private static final int CATEGORY_LENGTH = 5;
        private String licenseFamilyCategory;
        private String licenseFamilyName;

        public Builder setLicenseFamilyCategory(String licenseFamilyCategory) {
            this.licenseFamilyCategory = licenseFamilyCategory;
            return this;
        }

        public Builder setLicenseFamilyName(String licenseFamilyName) {
            this.licenseFamilyName = licenseFamilyName;
            return this;
        }

        public String getCategory() {
            return this.licenseFamilyCategory;
        }

        public ILicenseFamily build() {
            if (StringUtils.isBlank((CharSequence)this.licenseFamilyCategory)) {
                throw new ConfigurationException("LicenseFamily Category must be specified");
            }
            if (StringUtils.isBlank((CharSequence)this.licenseFamilyName)) {
                throw new ConfigurationException("LicenseFamily Name must be specified");
            }
            return new ILicenseFamily(){
                private final String cat;
                private final String name;
                {
                    this.cat = ILicenseFamily.makeCategory(licenseFamilyCategory);
                    this.name = licenseFamilyName;
                }

                public String toString() {
                    return String.format("%s %s", this.getFamilyCategory(), this.getFamilyName());
                }

                @Override
                public String getFamilyName() {
                    return this.name;
                }

                @Override
                public String getFamilyCategory() {
                    return this.cat;
                }

                public boolean equals(Object other) {
                    if (other == this) {
                        return true;
                    }
                    if (other instanceof ILicenseFamily) {
                        return this.getFamilyCategory().equals(((ILicenseFamily)other).getFamilyCategory());
                    }
                    return false;
                }

                public int hashCode() {
                    return this.getFamilyCategory().hashCode();
                }
            };
        }
    }
}

