/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.commons.collections4.iterators.TransformIterator;

public final class ExtendedIterator<T>
implements Iterator<T> {
    private final boolean removeDenied;
    private final Iterator<? extends T> base;

    public static <T> ExtendedIterator<T> createNoRemove(Iterator<T> it) {
        return new ExtendedIterator<T>(it, true);
    }

    public static <T> ExtendedIterator<T> create(Stream<T> stream) {
        return new ExtendedIterator(stream.iterator(), true);
    }

    public static <T> ExtendedIterator<T> flatten(Iterator<Iterator<T>> it) {
        return new ExtendedIterator<T>(new UnwindingIterator<T>(it), false);
    }

    public static ExtendedIterator<?> emptyIterator() {
        return new ExtendedIterator(Collections.emptyIterator(), false);
    }

    public static <T> ExtendedIterator<T> create(Iterator<T> it) {
        return it instanceof ExtendedIterator ? (ExtendedIterator<T>)it : new ExtendedIterator<T>(it, false);
    }

    private ExtendedIterator(Iterator<? extends T> base, boolean removeDenied) {
        this.base = base;
        this.removeDenied = removeDenied;
    }

    @Override
    public boolean hasNext() {
        return this.base.hasNext();
    }

    @Override
    public T next() {
        return this.base.next();
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.base.forEachRemaining(action);
    }

    @Override
    public void remove() {
        if (this.removeDenied) {
            throw new UnsupportedOperationException();
        }
        this.base.remove();
    }

    public T removeNext() {
        T result = this.next();
        this.remove();
        return result;
    }

    public <X extends T> ExtendedIterator<T> andThen(Iterator<X> other) {
        if (this.base instanceof IteratorChain) {
            ((IteratorChain)this.base).addIterator(other);
            return this;
        }
        return new ExtendedIterator<T>(new IteratorChain(this.base, other), this.removeDenied);
    }

    public ExtendedIterator<T> filter(Predicate<T> predicate) {
        return new ExtendedIterator<T>(new FilterIterator((Iterator)this, predicate::test), this.removeDenied);
    }

    public <U> ExtendedIterator<U> map(Function<T, U> function) {
        return new ExtendedIterator<T>(new TransformIterator((Iterator)this, function::apply), false);
    }

    public <U extends Collection<T>> U addTo(U collection) {
        this.forEachRemaining((Consumer<? super T>)((Consumer<Object>)collection::add));
        return collection;
    }

    private static class UnwindingIterator<T>
    implements Iterator<T> {
        private final Iterator<Iterator<T>> inner;
        private Iterator<T> outer;

        UnwindingIterator(Iterator<Iterator<T>> it) {
            this.inner = it;
        }

        @Override
        public boolean hasNext() {
            if (this.outer == null) {
                if (!this.inner.hasNext()) {
                    return false;
                }
                this.outer = this.inner.next();
            }
            while (!this.outer.hasNext()) {
                if (!this.inner.hasNext()) {
                    return false;
                }
                this.outer = this.inner.next();
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.outer.next();
        }
    }
}

