/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.rave.rest;

import org.apache.rave.rest.model.Category;
import org.apache.rave.rest.model.PageLayout;
import org.apache.rave.rest.model.SearchResult;

import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;

/**
 * Created with IntelliJ IDEA.
 * User: erinnp
 * Date: 8/9/13
 * Time: 1:55 PM
 * To change this template use File | Settings | File Templates.
 */
@Path("/pageLayouts")
public interface PageLayoutResource {

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public SearchResult<PageLayout> getPageLayouts();

    @POST
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public PageLayout createPageLayout(PageLayout pageLayout);

    @GET
    @Path("/{code}")
    @Produces(MediaType.APPLICATION_JSON)
    public PageLayout getPageLayout(@PathParam("code") String code);

    @PUT
    @Path("/{code}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public PageLayout updatePageLayout(@PathParam("code") String code, PageLayout pageLayout);
}
