/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.rave.model.FriendRequest;
import org.apache.rave.rest.model.Person;
import org.apache.rave.rest.model.SearchResult;

@Path(value="/people")
public interface PeopleResource {
    @GET
    @Produces(value={"application/json", "application/xml"})
    public SearchResult<Person> getPeople();

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/xml"})
    public Person getPerson(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/friends")
    @Produces(value={"application/json", "application/xml"})
    public Response getFriends(@PathParam(value="id") String var1);

    @GET
    @Path(value="/{id}/friends/{friendID}")
    @Produces(value={"application/json", "application/xml"})
    public Response getFriend(@PathParam(value="id") String var1, @PathParam(value="friendID") String var2);

    @DELETE
    @Path(value="/{id}/friends/{friendID}")
    public Response deleteFriend(@PathParam(value="id") String var1, @PathParam(value="friendID") String var2);

    @GET
    @Path(value="/{id}/requests")
    @Produces(value={"application/json", "application/xml"})
    public Response getRequests(@PathParam(value="id") String var1);

    @POST
    @Path(value="/{id}/requests")
    @Consumes(value={"application/json", "application/xml"})
    public Response createRequest(@PathParam(value="id") String var1, FriendRequest var2);

    @GET
    @Path(value="/{id}/requests/{id}")
    @Produces(value={"application/json", "application/xml"})
    public Response getRequest(@PathParam(value="id") String var1, @PathParam(value="id") String var2);

    @DELETE
    @Path(value="/{id}/requests/{id}")
    public Response deleteRequest(@PathParam(value="id") String var1, @PathParam(value="id") String var2);
}

