/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.rest.model;

import java.util.HashMap;
import java.util.List;
import org.apache.rave.rest.model.SearchResult;

public class JsonResponseWrapper {
    private HashMap<String, String> metadata;
    private Object data;

    public JsonResponseWrapper() {
    }

    public JsonResponseWrapper(SearchResult searchResult) {
        this.metadata = new HashMap();
        this.data = searchResult.getResultSet();
        this.buildPaginationData(searchResult.getPageSize(), searchResult.getOffset(), searchResult.getTotalResults());
    }

    public JsonResponseWrapper(List list) {
        this.metadata = new HashMap();
        this.data = list;
        this.buildPaginationData(0, 0, list.size());
    }

    public JsonResponseWrapper(Object data) {
        this.metadata = new HashMap();
        this.data = data;
    }

    public JsonResponseWrapper(Object data, Integer limit, Integer offset, Integer count) {
        this.metadata = new HashMap();
        this.data = data;
        this.buildPaginationData(limit, offset, count);
    }

    private void buildPaginationData(Integer limit, Integer offset, Integer count) {
        Integer prevOffset = null;
        Integer nextOffset = null;
        if (limit > 0) {
            if (offset > 0 && (prevOffset = Integer.valueOf(offset - limit)) < 0) {
                prevOffset = 0;
            }
            if (limit + offset < count) {
                nextOffset = limit + offset;
            }
        }
        if (prevOffset != null) {
            this.metadata.put("prev", "?limit=" + limit + "&offset=" + prevOffset);
        }
        if (nextOffset != null) {
            this.metadata.put("next", "?limit=" + limit + "&offset=" + nextOffset);
        }
        this.metadata.put("limit", limit.toString());
        this.metadata.put("offset", offset.toString());
        this.metadata.put("count", count.toString());
    }

    public HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

