/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.rest.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.rave.model.RegionWidgetPreference;
import org.apache.rave.rest.model.RestEntity;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RegionWidget", propOrder={"id", "type", "widgetId", "widgetUrl", "regionId", "collapsed", "locked", "hideChrome", "ownerId", "userPrefs"})
@XmlRootElement(name="RegionWidget")
public class RegionWidget
implements RestEntity {
    @XmlAttribute(name="id")
    protected String id;
    @XmlAttribute(name="type")
    protected String type;
    @XmlElement(name="widgetId")
    protected String widgetId;
    @XmlElement(name="widgetUrl")
    protected String widgetUrl;
    @XmlElement(name="regionId")
    protected String regionId;
    @XmlElement(name="collapsed")
    protected boolean collapsed;
    @XmlElement(name="locked")
    protected boolean locked;
    @XmlElement(name="hideChrome")
    protected boolean hideChrome;
    @XmlElement(name="ownerId")
    protected String ownerId;
    @XmlElement(name="userPrefs")
    protected HashMap<String, String> userPrefs;
    @XmlElement(name="properties")
    protected Map<String, Object> properties;

    public RegionWidget() {
    }

    public RegionWidget(org.apache.rave.model.RegionWidget widget) {
        this.id = widget.getId();
        this.widgetId = widget.getWidgetId();
        this.regionId = widget.getRegion().getId();
        this.collapsed = widget.isCollapsed();
        this.locked = widget.isLocked();
        this.ownerId = widget.getRegion().getPage().getOwnerId();
        this.hideChrome = widget.isHideChrome();
        this.userPrefs = this.createPrefs(widget);
        this.properties = widget.getProperties();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getWidgetId() {
        return this.widgetId;
    }

    public void setWidgetId(String widgetId) {
        this.widgetId = widgetId;
    }

    public String getWidgetUrl() {
        return this.widgetUrl;
    }

    public void setWidgetUrl(String widgetUrl) {
        this.widgetUrl = widgetUrl;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isHideChrome() {
        return this.hideChrome;
    }

    public void setHideChrome(boolean hideChrome) {
        this.hideChrome = hideChrome;
    }

    public HashMap<String, String> getUserPrefs() {
        return this.userPrefs;
    }

    public void setUserPrefs(HashMap<String, String> userPrefs) {
        this.userPrefs = userPrefs;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    protected HashMap<String, String> createPrefs(org.apache.rave.model.RegionWidget widget) {
        HashMap<String, String> created = null;
        List<RegionWidgetPreference> preferences = widget.getPreferences();
        if (preferences != null) {
            created = new HashMap<String, String>();
            for (RegionWidgetPreference pref : preferences) {
                created.put(pref.getName(), pref.getValue());
            }
        }
        return created;
    }
}

