/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.events;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.rave.portal.events.RaveEvent;
import org.apache.rave.portal.events.RaveEventListener;
import org.springframework.stereotype.Component;

@Component
public class RaveEventManager {
    private final Map<Class<? extends RaveEvent>, Set<RaveEventListener>> eventListenerMap = new Hashtable<Class<? extends RaveEvent>, Set<RaveEventListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Class<? extends RaveEvent> event, RaveEventListener listener) {
        Map<Class<? extends RaveEvent>, Set<RaveEventListener>> map = this.eventListenerMap;
        synchronized (map) {
            if (this.eventListenerMap.containsKey(event)) {
                Set<RaveEventListener> eventListeners = this.eventListenerMap.get(event);
                if (eventListeners == null) {
                    eventListeners = new HashSet<RaveEventListener>();
                }
                eventListeners.add(listener);
            } else {
                HashSet<RaveEventListener> eventListeners = new HashSet<RaveEventListener>();
                eventListeners.add(listener);
                this.eventListenerMap.put(event, eventListeners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Class<? extends RaveEvent> event, RaveEventListener listener) {
        Map<Class<? extends RaveEvent>, Set<RaveEventListener>> map = this.eventListenerMap;
        synchronized (map) {
            if (this.eventListenerMap.containsKey(event)) {
                this.eventListenerMap.get(event).remove(listener);
            }
        }
    }

    public synchronized void fireEvent(RaveEvent event) {
        Set<RaveEventListener> listeners = this.eventListenerMap.get(event.getClass());
        if (listeners != null && !listeners.isEmpty()) {
            for (RaveEventListener listener : this.eventListenerMap.get(event.getClass())) {
                listener.handleEvent(event);
            }
        }
    }
}

