/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.rave.model.Authority;
import org.apache.rave.model.PageLayout;
import org.apache.rave.model.Person;
import org.apache.rave.model.User;
import org.apache.rave.portal.model.impl.PersonImpl;
import org.apache.rave.util.CollectionUtils;
import org.springframework.security.core.GrantedAuthority;

public class UserImpl
extends PersonImpl
implements User,
Serializable {
    private String password;
    private boolean expired;
    private boolean credsExpired;
    private boolean locked;
    private boolean enabled;
    private String openId;
    private String forgotPasswordHash;
    private Date forgotPasswordTime;
    private PageLayout defaultPageLayout;
    private String confirmPassword;
    private String defaultPageLayoutCode;
    private List<Authority> authorities = new ArrayList<Authority>();

    public UserImpl() {
    }

    public UserImpl(String id) {
        this.id = id;
    }

    public UserImpl(String userid, String username) {
        this.id = userid;
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAccountNonLocked() {
        return !this.locked;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isCredentialsNonExpired() {
        return !this.credsExpired;
    }

    public void setCredsExpired(boolean credsExpired) {
        this.credsExpired = credsExpired;
    }

    public boolean isAccountNonExpired() {
        return !this.expired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getOpenId() {
        return this.openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getForgotPasswordHash() {
        return this.forgotPasswordHash;
    }

    public void setForgotPasswordHash(String forgotPasswordHash) {
        this.forgotPasswordHash = forgotPasswordHash;
    }

    public Date getForgotPasswordTime() {
        return this.forgotPasswordTime;
    }

    public void setForgotPasswordTime(Date forgotPasswordTime) {
        this.forgotPasswordTime = forgotPasswordTime;
    }

    public PageLayout getDefaultPageLayout() {
        return this.defaultPageLayout;
    }

    public void setDefaultPageLayout(PageLayout defaultPageLayout) {
        this.defaultPageLayout = defaultPageLayout;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public Person toPerson() {
        PersonImpl p = new PersonImpl();
        p.setId(this.getId());
        p.setAboutMe(this.getAboutMe());
        p.setAdditionalName(this.getAdditionalName());
        p.setAddresses(this.getAddresses());
        p.setDisplayName(this.getDisplayName());
        p.setEmail(this.getEmail());
        p.setFamilyName(this.getFamilyName());
        p.setGivenName(this.getGivenName());
        p.setHonorificPrefix(this.getHonorificPrefix());
        p.setHonorificSuffix(this.getHonorificSuffix());
        p.setOrganizations(this.getOrganizations());
        p.setPreferredName(this.getPreferredName());
        p.setProperties(this.getProperties());
        p.setStatus(this.getStatus());
        p.setUsername(this.getUsername());
        return p;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getDefaultPageLayoutCode() {
        return this.defaultPageLayoutCode;
    }

    public void setDefaultPageLayoutCode(String defaultPageLayoutCode) {
        this.defaultPageLayoutCode = defaultPageLayoutCode;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return CollectionUtils.toBaseTypedList(this.authorities);
    }

    public void addAuthority(Authority authority) {
        this.authorities.add(authority);
    }

    public void removeAuthority(Authority authority) {
        this.authorities.remove(authority);
    }

    public void setAuthorities(Collection<Authority> authorities) {
        if (this.authorities == null) {
            this.authorities = new ArrayList<Authority>();
        }
        this.authorities.clear();
        if (authorities != null) {
            this.authorities.addAll(authorities);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserImpl user = (UserImpl)o;
        if (this.credsExpired != user.credsExpired) {
            return false;
        }
        if (this.enabled != user.enabled) {
            return false;
        }
        if (this.expired != user.expired) {
            return false;
        }
        if (this.locked != user.locked) {
            return false;
        }
        if (this.authorities != null ? !((Object)this.authorities).equals(user.authorities) : user.authorities != null) {
            return false;
        }
        if (this.confirmPassword != null ? !this.confirmPassword.equals(user.confirmPassword) : user.confirmPassword != null) {
            return false;
        }
        if (this.defaultPageLayout != null ? !this.defaultPageLayout.equals(user.defaultPageLayout) : user.defaultPageLayout != null) {
            return false;
        }
        if (this.defaultPageLayoutCode != null ? !this.defaultPageLayoutCode.equals(user.defaultPageLayoutCode) : user.defaultPageLayoutCode != null) {
            return false;
        }
        if (this.forgotPasswordHash != null ? !this.forgotPasswordHash.equals(user.forgotPasswordHash) : user.forgotPasswordHash != null) {
            return false;
        }
        if (this.forgotPasswordTime != null ? !this.forgotPasswordTime.equals(user.forgotPasswordTime) : user.forgotPasswordTime != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(user.id) : user.id != null) {
            return false;
        }
        if (this.openId != null ? !this.openId.equals(user.openId) : user.openId != null) {
            return false;
        }
        return !(this.password != null ? !this.password.equals(user.password) : user.password != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.expired ? 1 : 0);
        result = 31 * result + (this.credsExpired ? 1 : 0);
        result = 31 * result + (this.locked ? 1 : 0);
        result = 31 * result + (this.enabled ? 1 : 0);
        result = 31 * result + (this.openId != null ? this.openId.hashCode() : 0);
        result = 31 * result + (this.forgotPasswordHash != null ? this.forgotPasswordHash.hashCode() : 0);
        result = 31 * result + (this.forgotPasswordTime != null ? this.forgotPasswordTime.hashCode() : 0);
        result = 31 * result + (this.defaultPageLayout != null ? this.defaultPageLayout.hashCode() : 0);
        result = 31 * result + (this.confirmPassword != null ? this.confirmPassword.hashCode() : 0);
        result = 31 * result + (this.defaultPageLayoutCode != null ? this.defaultPageLayoutCode.hashCode() : 0);
        result = 31 * result + (this.authorities != null ? ((Object)this.authorities).hashCode() : 0);
        return result;
    }
}

