/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.util.omdl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.rave.portal.model.util.omdl.OmdlConstants;
import org.apache.rave.portal.model.util.omdl.OmdlWidgetReference;

public class OmdlInputAdapter
implements OmdlConstants {
    public boolean LEFT_FOUND = false;
    public boolean CENTER_FOUND = false;
    public boolean RIGHT_FOUND = false;
    private String name;
    private String layoutCode;
    private List<OmdlWidgetReference> topLeft = new ArrayList<OmdlWidgetReference>();
    private List<OmdlWidgetReference> middleLeft = new ArrayList<OmdlWidgetReference>();
    private List<OmdlWidgetReference> bottomLeft = new ArrayList<OmdlWidgetReference>();
    private List<OmdlWidgetReference> topCenter = new ArrayList<OmdlWidgetReference>();
    private List<OmdlWidgetReference> middleCenter = new ArrayList<OmdlWidgetReference>();
    private List<OmdlWidgetReference> bottomCenter = new ArrayList<OmdlWidgetReference>();
    private List<OmdlWidgetReference> topRight = new ArrayList<OmdlWidgetReference>();
    private List<OmdlWidgetReference> middleRight = new ArrayList<OmdlWidgetReference>();
    private List<OmdlWidgetReference> bottomRight = new ArrayList<OmdlWidgetReference>();
    private List<OmdlWidgetReference> unknown = new ArrayList<OmdlWidgetReference>();

    public List<OmdlWidgetReference> getAllUrls() {
        ArrayList<OmdlWidgetReference> newList = new ArrayList<OmdlWidgetReference>();
        newList.addAll(this.getAllLeftUrls());
        newList.addAll(this.getAllCenterUrls());
        newList.addAll(this.getAllRightUrls());
        newList.addAll(this.getAllUnknownUrls());
        return newList;
    }

    public List<OmdlWidgetReference> getAllUnknownUrls() {
        Collections.reverse(this.unknown);
        return this.unknown;
    }

    public List<OmdlWidgetReference> getAllRightUrls() {
        Collections.reverse(this.topRight);
        Collections.reverse(this.middleRight);
        Collections.reverse(this.bottomRight);
        ArrayList<OmdlWidgetReference> newList = new ArrayList<OmdlWidgetReference>();
        newList.addAll(this.topRight);
        newList.addAll(this.middleRight);
        newList.addAll(this.bottomRight);
        Collections.reverse(newList);
        return newList;
    }

    public List<OmdlWidgetReference> getAllCenterUrls() {
        Collections.reverse(this.topCenter);
        Collections.reverse(this.middleCenter);
        Collections.reverse(this.bottomCenter);
        ArrayList<OmdlWidgetReference> newList = new ArrayList<OmdlWidgetReference>();
        newList.addAll(this.topCenter);
        newList.addAll(this.middleCenter);
        newList.addAll(this.bottomCenter);
        Collections.reverse(newList);
        return newList;
    }

    public List<OmdlWidgetReference> getAllLeftUrls() {
        Collections.reverse(this.topLeft);
        Collections.reverse(this.middleLeft);
        Collections.reverse(this.bottomLeft);
        ArrayList<OmdlWidgetReference> newList = new ArrayList<OmdlWidgetReference>();
        newList.addAll(this.topLeft);
        newList.addAll(this.middleLeft);
        newList.addAll(this.bottomLeft);
        Collections.reverse(newList);
        return newList;
    }

    public void addToAppMap(OmdlWidgetReference widgetReference, String position) {
        if (position.contains("LEFT")) {
            this.LEFT_FOUND = true;
            if (position.contains("TOP")) {
                this.topLeft.add(widgetReference);
            } else if (position.contains("MIDDLE")) {
                this.middleLeft.add(widgetReference);
            } else {
                this.bottomLeft.add(widgetReference);
            }
        } else if (position.contains("CENTER")) {
            this.CENTER_FOUND = true;
            if (position.contains("TOP")) {
                this.topCenter.add(widgetReference);
            } else if (position.contains("MIDDLE")) {
                this.middleCenter.add(widgetReference);
            } else {
                this.bottomCenter.add(widgetReference);
            }
        } else if (position.contains("RIGHT")) {
            this.RIGHT_FOUND = true;
            if (position.contains("TOP")) {
                this.topRight.add(widgetReference);
            } else if (position.contains("MIDDLE")) {
                this.middleRight.add(widgetReference);
            } else {
                this.bottomRight.add(widgetReference);
            }
        } else {
            this.unknown.add(widgetReference);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLayoutCode() {
        return this.layoutCode;
    }

    public void setLayoutCode(String layoutCode) {
        this.layoutCode = layoutCode;
    }
}

