/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.util.omdl;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.rave.portal.model.util.omdl.OmdlConstants;
import org.apache.rave.portal.model.util.omdl.OmdlInputAdapter;

public class OmdlModelUtils
implements OmdlConstants {
    public static String getOmdlLayoutForExport(String raveLayoutCode) {
        switch (InternalLayoutCodes.convertString(raveLayoutCode)) {
            case columns_1: {
                return InternalLayoutCodes.columns_1.toString();
            }
            case columns_2: {
                return InternalLayoutCodes.columns_2.toString();
            }
            case columns_2wn: {
                return InternalLayoutCodes.columns_2wn.toString();
            }
            case columns_3: {
                return InternalLayoutCodes.columns_3.toString();
            }
            case columns_3nwn: {
                return InternalLayoutCodes.columns_3nwn.toString();
            }
            case columns_3_newuser: {
                return InternalLayoutCodes.columns_3_newuser.toString();
            }
            case columns_4: {
                return InternalLayoutCodes.columns_4.toString();
            }
            case columns_3nwn_1_bottom: {
                return InternalLayoutCodes.columns_3nwn_1_bottom.toString();
            }
        }
        return InternalLayoutCodes.columns_1.toString();
    }

    public static String getPositionString(int region, int totalRegions, int widget, int totalWidget) {
        String vs = OmdlModelUtils.getVerticalStringForWidget(widget, totalWidget);
        String hs = OmdlModelUtils.getColumnStringForWidget(region, totalRegions);
        String both = vs + " " + hs;
        return both.trim();
    }

    public static String getVerticalStringForWidget(int thisWidgetIndex, int totalWidgets) {
        int count = (totalWidgets + 3 - 1) / 3;
        if (totalWidgets < 2) {
            return "";
        }
        if (thisWidgetIndex <= count) {
            return "TOP";
        }
        if (thisWidgetIndex <= count * 2) {
            return "MIDDLE";
        }
        return "BOTTOM";
    }

    public static String getColumnStringForWidget(int currentRegion, int numberOfRegions) {
        String columnStr = "";
        block0 : switch (numberOfRegions) {
            case 1: {
                break;
            }
            case 2: {
                switch (currentRegion) {
                    case 1: {
                        columnStr = "LEFT";
                        break block0;
                    }
                    case 2: {
                        columnStr = "RIGHT";
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (currentRegion) {
                    case 1: {
                        columnStr = "LEFT";
                        break block0;
                    }
                    case 2: {
                        columnStr = "CENTER";
                        break block0;
                    }
                    case 3: {
                        columnStr = "RIGHT";
                        break block0;
                    }
                }
            }
        }
        return columnStr;
    }

    public static String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        return dateFormat.format(new Date());
    }

    public static String getRaveLayoutForImport(OmdlInputAdapter omdlInputAdapter) {
        String omdlLayoutString = omdlInputAdapter.getLayoutCode();
        if (omdlLayoutString == null) {
            return OmdlModelUtils.getLayoutFromWidgetsPosition(omdlInputAdapter);
        }
        if (omdlLayoutString.equals(InternalLayoutCodes.columns_1.toString())) {
            return "columns_1";
        }
        if (omdlLayoutString.equals(InternalLayoutCodes.columns_2.toString())) {
            return "columns_2";
        }
        if (omdlLayoutString.equals(InternalLayoutCodes.columns_2wn.toString())) {
            return "columns_2wn";
        }
        if (omdlLayoutString.equals(InternalLayoutCodes.columns_3.toString())) {
            return "columns_3";
        }
        if (omdlLayoutString.equals(InternalLayoutCodes.columns_3nwn.toString())) {
            return "columns_3nwn";
        }
        if (omdlLayoutString.equals(InternalLayoutCodes.columns_3_newuser.toString())) {
            return "columns_3_newuser";
        }
        if (omdlLayoutString.equals(InternalLayoutCodes.columns_4.toString())) {
            return "columns_4";
        }
        if (omdlLayoutString.equals(InternalLayoutCodes.columns_3nwn_1_bottom.toString())) {
            return "columns_3nwn_1_bottom";
        }
        return OmdlModelUtils.getLayoutFromWidgetsPosition(omdlInputAdapter);
    }

    public static String getLayoutFromWidgetsPosition(OmdlInputAdapter omdlInputAdapter) {
        if (omdlInputAdapter.LEFT_FOUND && omdlInputAdapter.CENTER_FOUND && omdlInputAdapter.RIGHT_FOUND) {
            return "columns_3";
        }
        if (omdlInputAdapter.LEFT_FOUND && !omdlInputAdapter.CENTER_FOUND && omdlInputAdapter.RIGHT_FOUND) {
            return "columns_2";
        }
        return "columns_1";
    }

    public static enum InternalLayoutCodes {
        columns_1{

            public String toString() {
                return "ONE COLUMNS";
            }
        }
        ,
        columns_2{

            public String toString() {
                return "TWO COLUMNS";
            }
        }
        ,
        columns_2wn{

            public String toString() {
                return "TWO COLUMNS WIDE NARROW";
            }
        }
        ,
        columns_3{

            public String toString() {
                return "THREE COLUMNS";
            }
        }
        ,
        columns_3nwn{

            public String toString() {
                return "THREE COLUMNS NARROW WIDE NARROW";
            }
        }
        ,
        columns_3_newuser{

            public String toString() {
                return "TWO COLUMNS TWO ROWS WIDE";
            }
        }
        ,
        columns_4{

            public String toString() {
                return "FOUR COLUMNS";
            }
        }
        ,
        columns_3nwn_1_bottom{

            public String toString() {
                return "THREE COLUMNS NARROW WIDE NARROW TWO ROWS WIDE";
            }
        };


        public static InternalLayoutCodes convertString(String code) {
            try {
                return InternalLayoutCodes.valueOf(code);
            }
            catch (Exception e) {
                return columns_1;
            }
        }
    }
}

