/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageType;
import org.apache.rave.model.PageUser;
import org.apache.rave.model.User;
import org.apache.rave.portal.repository.PageRepository;
import org.apache.rave.portal.repository.UserRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultPagePermissionEvaluator
extends AbstractModelPermissionEvaluator<Page> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private PageRepository pageRepository;
    private UserRepository userRepository;

    @Autowired
    public DefaultPagePermissionEvaluator(PageRepository pageRepository, UserRepository userRepository) {
        this.pageRepository = pageRepository;
        this.userRepository = userRepository;
    }

    @Override
    public Class<Page> getType() {
        return Page.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, Page page, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, page, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId) : this.hasPermission(authentication, (Page)this.pageRepository.get((String)((Object)targetId)), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, Page page, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList<Page> trustedPageContainer = new ArrayList<Page>();
        if (super.hasPermission(authentication, page, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case ADMINISTER: {
                break;
            }
            case CREATE: 
            case DELETE: 
            case UPDATE: {
                hasPermission = this.isPageOwner(authentication, page, trustedPageContainer, trustedDomainObject) || this.isPageMember(authentication, page, trustedPageContainer, trustedDomainObject, true);
                break;
            }
            case READ: {
                hasPermission = this.isReadablePage(authentication, page, trustedPageContainer, trustedDomainObject) || this.isPageMember(authentication, page, trustedPageContainer, trustedDomainObject, false);
                break;
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private Page getTrustedPage(String pageId, List<Page> trustedPageContainer) {
        Page p = null;
        if (trustedPageContainer.isEmpty()) {
            p = (Page)this.pageRepository.get(pageId);
            trustedPageContainer.add(p);
        } else {
            p = trustedPageContainer.get(0);
        }
        return p;
    }

    private boolean isPageOwner(Authentication authentication, Page page, List<Page> trustedPageContainer, boolean trustedDomainObject) {
        Page trustedPage = null;
        trustedPage = trustedDomainObject ? page : this.getTrustedPage(page.getId(), trustedPageContainer);
        return this.isPageOwnerByUserId(authentication, trustedPage.getOwnerId());
    }

    private boolean isPageOwnerByUserId(Authentication authentication, String userId) {
        return ((User)authentication.getPrincipal()).getId().equals(userId);
    }

    private boolean isPageOwnerById(Authentication authentication, String userId) {
        return ((User)authentication.getPrincipal()).getId().equals(userId);
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (User.class == clazz) {
            return this.isPageOwnerById(authentication, (String)raveSecurityContext.getId());
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }

    private boolean isReadablePage(Authentication authentication, Page page, List<Page> trustedPageContainer, boolean trustedDomainObject) {
        return this.isPersonProfilePageOrSubPage(page) || this.isPageOwner(authentication, page, trustedPageContainer, trustedDomainObject) || this.isPageMember(authentication, page, trustedPageContainer, trustedDomainObject, false);
    }

    private boolean isPersonProfilePageOrSubPage(Page page) {
        String pageType = page.getPageType();
        String parentPageType = page.getParentPage() == null ? null : page.getParentPage().getPageType();
        return PageType.PERSON_PROFILE.toString().equals(pageType) || PageType.PERSON_PROFILE.toString().equals(parentPageType);
    }

    private boolean isPageMember(Authentication authentication, Page page, List<Page> trustedPageContainer, boolean trustedDomainObject, boolean checkEditorStatus) {
        Page trustedPage = null;
        trustedPage = trustedDomainObject ? page : this.getTrustedPage(page.getId(), trustedPageContainer);
        if (trustedPage.getMembers() == null) {
            return false;
        }
        String viewer = ((User)authentication.getPrincipal()).getUsername();
        List members = trustedPage.getMembers();
        if (members != null) {
            for (PageUser pageUser : members) {
                User user = (User)this.userRepository.get(pageUser.getUserId());
                if (user == null || !user.getUsername().equals(viewer)) continue;
                this.log.info("User " + viewer + " is a member of page " + trustedPage.getId());
                if (checkEditorStatus) {
                    this.log.info("checking editor:" + trustedPage.getId() + "@" + viewer + "@" + pageUser.isEditor());
                    return pageUser.isEditor();
                }
                return true;
            }
        }
        this.log.info("User " + viewer + " is NOT a member of page " + trustedPage.getId());
        return false;
    }
}

