/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.model.User;
import org.apache.rave.model.WidgetComment;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.AbstractModelPermissionEvaluator;
import org.apache.rave.portal.security.impl.RaveSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class DefaultWidgetCommentPermissionEvaluator
extends AbstractModelPermissionEvaluator<WidgetComment> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private WidgetRepository widgetRepository;

    @Autowired
    public DefaultWidgetCommentPermissionEvaluator(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    @Override
    public Class<WidgetComment> getType() {
        return WidgetComment.class;
    }

    @Override
    public boolean hasPermission(Authentication authentication, WidgetComment widgetComment, ModelPermissionEvaluator.Permission permission) {
        return this.hasPermission(authentication, widgetComment, permission, false);
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, ModelPermissionEvaluator.Permission permission) {
        boolean hasPermission = false;
        hasPermission = targetId instanceof RaveSecurityContext ? this.verifyRaveSecurityContext(authentication, (RaveSecurityContext)targetId, permission) : this.hasPermission(authentication, this.widgetRepository.getCommentById(null, (String)((Object)targetId)), permission, true);
        return hasPermission;
    }

    private boolean hasPermission(Authentication authentication, WidgetComment widgetComment, ModelPermissionEvaluator.Permission permission, boolean trustedDomainObject) {
        ArrayList<WidgetComment> trustedWidgetCommentContainer = new ArrayList<WidgetComment>();
        if (super.hasPermission(authentication, widgetComment, permission)) {
            return true;
        }
        boolean hasPermission = false;
        switch (permission) {
            case ADMINISTER: {
                break;
            }
            case READ: {
                hasPermission = true;
                break;
            }
            case CREATE: {
                hasPermission = true;
                break;
            }
            case CREATE_OR_UPDATE: 
            case DELETE: 
            case UPDATE: {
                hasPermission = this.isWidgetCommentOwner(authentication, widgetComment, trustedWidgetCommentContainer, trustedDomainObject);
                break;
            }
            default: {
                this.log.warn("unknown permission: " + (Object)((Object)permission));
            }
        }
        return hasPermission;
    }

    private boolean verifyRaveSecurityContext(Authentication authentication, RaveSecurityContext raveSecurityContext, ModelPermissionEvaluator.Permission permission) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(raveSecurityContext.getType());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("unknown class specified in RaveSecurityContext: ", ex);
        }
        if (WidgetComment.class == clazz) {
            boolean hasPermission = false;
            switch (permission) {
                case ADMINISTER: {
                    break;
                }
                case READ: {
                    hasPermission = true;
                    break;
                }
                case CREATE: 
                case CREATE_OR_UPDATE: 
                case DELETE: 
                case UPDATE: {
                    hasPermission = this.isWidgetCommentOwnerById(authentication, (String)raveSecurityContext.getId());
                    break;
                }
                default: {
                    this.log.warn("unknown permission: " + (Object)((Object)permission));
                }
            }
            return hasPermission;
        }
        throw new IllegalArgumentException("unknown RaveSecurityContext type: " + raveSecurityContext.getType());
    }

    private boolean isWidgetCommentOwner(Authentication authentication, WidgetComment widgetComment, List<WidgetComment> trustedPageContainer, boolean trustedDomainObject) {
        WidgetComment trustedWidgetComment = null;
        trustedWidgetComment = trustedDomainObject ? widgetComment : this.getTrustedWidgetComment(widgetComment.getId(), trustedPageContainer);
        return this.isWidgetCommentOwnerById(authentication, trustedWidgetComment.getUserId());
    }

    private WidgetComment getTrustedWidgetComment(String widgetCommentId, List<WidgetComment> trustedWidgetCommentContainer) {
        WidgetComment p = null;
        if (trustedWidgetCommentContainer.isEmpty()) {
            p = this.widgetRepository.getCommentById(null, widgetCommentId);
            trustedWidgetCommentContainer.add(p);
        } else {
            p = trustedWidgetCommentContainer.get(0);
        }
        return p;
    }

    private boolean isWidgetCommentOwnerByUsername(Authentication authentication, String username) {
        return ((User)authentication.getPrincipal()).getUsername().equals(username);
    }

    private boolean isWidgetCommentOwnerById(Authentication authentication, String userId) {
        return ((User)authentication.getPrincipal()).getId().equals(userId);
    }
}

