/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.portal.security.ModelPermissionEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class RavePermissionEvaluator
implements PermissionEvaluator {
    private Map<Class, ModelPermissionEvaluator<?>> modelPermissionEvaluatorMap;

    @Autowired
    public RavePermissionEvaluator(List<ModelPermissionEvaluator<?>> modelPermissionEvaluatorList) {
        Collections.sort(modelPermissionEvaluatorList, new Comparator<ModelPermissionEvaluator>(){

            @Override
            public int compare(ModelPermissionEvaluator o1, ModelPermissionEvaluator o2) {
                return new Integer(o1.getLoadOrder()).compareTo(new Integer(o2.getLoadOrder()));
            }
        });
        this.modelPermissionEvaluatorMap = new HashMap();
        for (ModelPermissionEvaluator<?> mpe : modelPermissionEvaluatorList) {
            this.modelPermissionEvaluatorMap.put(mpe.getType(), mpe);
        }
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permissionString) {
        if (targetDomainObject == null) {
            return false;
        }
        return this.getEvaluator(targetDomainObject.getClass()).hasPermission(authentication, targetDomainObject, this.getPermission(targetDomainObject, (String)permissionString));
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permissionString) {
        ModelPermissionEvaluator.Permission permission = ModelPermissionEvaluator.Permission.fromString((String)permissionString);
        if (permission == ModelPermissionEvaluator.Permission.CREATE_OR_UPDATE) {
            throw new IllegalArgumentException("CREATE_OR_UPDATE not supported in this context.");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(targetType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class " + targetType + " not found", e);
        }
        return this.getEvaluator(clazz).hasPermission(authentication, targetId, targetType, permission);
    }

    private ModelPermissionEvaluator getEvaluator(Class targetType) throws IllegalArgumentException {
        ModelPermissionEvaluator mpe = this.modelPermissionEvaluatorMap.get(targetType);
        if (mpe == null && (mpe = this.findAndRegisterCompatibleModelPermissionEvaluator(targetType)) == null) {
            throw new IllegalArgumentException("ModelPermissionEvaluator not found for type " + targetType);
        }
        return mpe;
    }

    private ModelPermissionEvaluator findAndRegisterCompatibleModelPermissionEvaluator(Class modelClass) {
        for (Map.Entry<Class, ModelPermissionEvaluator<?>> classModelPermissionEvaluatorEntry : this.modelPermissionEvaluatorMap.entrySet()) {
            Class registeredModelClass = classModelPermissionEvaluatorEntry.getKey();
            ModelPermissionEvaluator<?> registeredMpe = classModelPermissionEvaluatorEntry.getValue();
            if (!registeredModelClass.isAssignableFrom(modelClass)) continue;
            this.modelPermissionEvaluatorMap.put(modelClass, registeredMpe);
            return registeredMpe;
        }
        return null;
    }

    private ModelPermissionEvaluator.Permission getPermission(Object targetDomainObject, String permissionString) {
        ModelPermissionEvaluator.Permission permission = ModelPermissionEvaluator.Permission.fromString(permissionString);
        return permission;
    }
}

